/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.hints.errors.AddParameterOrLocalFix;
import org.netbeans.modules.java.hints.errors.CreateClassFix;
import org.netbeans.modules.java.hints.errors.CreateElementUtilities;
import org.netbeans.modules.java.hints.errors.CreateEnumConstant;
import org.netbeans.modules.java.hints.errors.CreateFieldFix;
import org.netbeans.modules.java.hints.errors.CreateMethodFix;
import org.netbeans.modules.java.hints.errors.ErrorFixesFakeHint;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.infrastructure.Pair;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateElement
implements ErrorRule<Void> {
    @Override
    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.resolve.location", "compiler.err.cant.resolve.location.args", "compiler.err.cant.apply.symbol", "compiler.err.cant.resolve", "compiler.err.cant.resolve.args"));
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<Void> data) {
        try {
            return CreateElement.analyze(compilationInfo, n);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
        catch (ClassCastException classCastException) {
            Logger.getLogger(CreateElement.class.getName()).log(Level.FINE, null, classCastException);
            return null;
        }
    }

    static List<Fix> analyze(CompilationInfo compilationInfo, int n) throws IOException {
        Element element;
        Object object;
        List<? extends TypeMirror> list;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        TreePath treePath = ErrorHintsProvider.findUnresolvedElement(compilationInfo, n);
        if (treePath == null) {
            return Collections.emptyList();
        }
        if (compilationInfo.getElements().getTypeElement("java.lang.Object") == null) {
            return Collections.emptyList();
        }
        TreePath treePath2 = null;
        TreePath treePath3 = null;
        TreePath treePath4 = null;
        TreePath treePath5 = null;
        TreePath treePath6 = null;
        TreePath treePath7 = null;
        boolean bl = true;
        boolean bl2 = true;
        for (TreePath treePath8 = compilationInfo.getTreeUtilities().pathFor(n + 1); treePath8 != null; treePath8 = treePath8.getParentPath()) {
            object6 = treePath8.getLeaf();
            object5 = object6.getKind();
            if (treePath2 != null && treePath2.getLeaf() == treePath.getLeaf()) {
                treePath2 = treePath8;
            }
            if (object6 == treePath.getLeaf() && treePath2 == null) {
                treePath2 = treePath8;
            }
            if (object5 == Tree.Kind.CLASS && treePath3 == null) {
                treePath3 = treePath8;
            }
            if (object5 == Tree.Kind.METHOD && treePath4 == null && treePath3 == null) {
                treePath4 = treePath8;
            }
            if (object5 == Tree.Kind.BLOCK && treePath8.getParentPath().getLeaf().getKind() == Tree.Kind.CLASS && treePath4 == null && treePath3 == null) {
                treePath5 = treePath8;
            }
            if (bl && object5 == Tree.Kind.METHOD_INVOCATION) {
                treePath6 = treePath8;
            }
            if (bl2 && object5 == Tree.Kind.NEW_CLASS) {
                treePath7 = treePath8;
            }
            if (object5 == Tree.Kind.MEMBER_SELECT) {
                boolean bl3 = bl = object6 == treePath.getLeaf();
            }
            if (object5 != Tree.Kind.MEMBER_SELECT && object5 != Tree.Kind.IDENTIFIER) {
                bl = false;
            }
            if (object5 == Tree.Kind.MEMBER_SELECT || object5 == Tree.Kind.IDENTIFIER || object5 == Tree.Kind.PARAMETERIZED_TYPE) continue;
            bl2 = false;
        }
        if (treePath2 == null || treePath2.getLeaf() == treePath.getLeaf() || treePath3 == null) {
            return Collections.emptyList();
        }
        object6 = compilationInfo.getTrees().getElement(treePath);
        if (object6 == null) {
            return Collections.emptyList();
        }
        object5 = EnumSet.noneOf(Modifier.class);
        Name name = object6.getSimpleName();
        if (name == null) {
            if (ErrorHintsProvider.ERR.isLoggable(1)) {
                ErrorHintsProvider.ERR.log(1, "e.simpleName=null");
                ErrorHintsProvider.ERR.log(1, "offset=" + n);
                ErrorHintsProvider.ERR.log(1, "errorTree=" + treePath.getLeaf());
            }
            return Collections.emptyList();
        }
        String string = name.toString();
        TypeElement typeElement = (TypeElement)compilationInfo.getTrees().getElement(treePath3);
        TypeElement typeElement2 = null;
        boolean bl4 = false;
        if (treePath.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
            object4 = new TreePath(treePath, ((MemberSelectTree)treePath.getLeaf()).getExpression());
            object3 = compilationInfo.getTrees().getElement((TreePath)object4);
            object2 = compilationInfo.getTrees().getTypeMirror((TreePath)object4);
            if (object3 != null && object2 != null && object2.getKind() != TypeKind.ERROR) {
                switch (object3.getKind()) {
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        typeElement2 = (TypeElement)object3;
                        object5.add(Modifier.STATIC);
                        break;
                    }
                    case FIELD: 
                    case ENUM_CONSTANT: 
                    case LOCAL_VARIABLE: 
                    case PARAMETER: 
                    case EXCEPTION_PARAMETER: {
                        list = object3.asType();
                        if (list.getKind() != TypeKind.DECLARED) break;
                        typeElement2 = (TypeElement)((DeclaredType)((Object)list)).asElement();
                        break;
                    }
                    case METHOD: {
                        object = compilationInfo.getTypes().asElement(((ExecutableElement)object3).getReturnType());
                        if (object == null || !object.getKind().isClass() && !object.getKind().isInterface()) break;
                        typeElement2 = (TypeElement)object;
                        break;
                    }
                    case CONSTRUCTOR: {
                        typeElement2 = (TypeElement)object3.getEnclosingElement();
                    }
                }
            }
            bl4 = true;
        } else {
            object4 = object6.getEnclosingElement();
            if (object4 != null && object4.getKind() == ElementKind.ANNOTATION_TYPE) {
                typeElement2 = (TypeElement)object4;
            } else if (treePath.getLeaf().getKind() == Tree.Kind.IDENTIFIER) {
                typeElement2 = typeElement;
                if (treePath4 != null) {
                    if (((MethodTree)treePath4.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                        object5.add(Modifier.STATIC);
                    }
                } else if (treePath5 != null && ((BlockTree)treePath5.getLeaf()).isStatic()) {
                    object5.add(Modifier.STATIC);
                }
            }
        }
        if (typeElement2 == null) {
            if (ErrorHintsProvider.ERR.isLoggable(1)) {
                ErrorHintsProvider.ERR.log(1, "target=null");
                ErrorHintsProvider.ERR.log(1, "offset=" + n);
                ErrorHintsProvider.ERR.log(1, "errorTree=" + treePath.getLeaf());
            }
            return Collections.emptyList();
        }
        object5.addAll(CreateElement.getAccessModifiers(compilationInfo, typeElement, typeElement2));
        object4 = new ArrayList<Fix>();
        if (treePath6 != null) {
            object3 = (MethodInvocationTree)treePath6.getLeaf();
            object2 = EnumSet.noneOf(ElementKind.class);
            list = CreateElementUtilities.resolveType((Set<ElementKind>)object2, compilationInfo, treePath6.getParentPath(), treePath6.getLeaf(), n, null, null);
            if (list == null || list.isEmpty()) {
                return Collections.emptyList();
            }
            object4.addAll(CreateElement.prepareCreateMethodFix(compilationInfo, treePath6, (Set<Modifier>)object5, typeElement2, string, object3.getArguments(), list));
        }
        if (treePath7 != null) {
            object3 = (NewClassTree)treePath7.getLeaf();
            object2 = compilationInfo.getTrees().getElement(new TreePath(treePath7, object3.getIdentifier()));
            if (object2 == null || object2.asType().getKind() == TypeKind.ERROR || !object2.getKind().isClass() && !object2.getKind().isInterface()) {
                list = object3.getIdentifier();
                int n2 = 0;
                if (list.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                    n2 = ((ParameterizedTypeTree)((Object)list)).getTypeArguments().size();
                }
                if (bl4) {
                    return CreateElement.prepareCreateInnerClassFix(compilationInfo, treePath7, typeElement2, (Set<Modifier>)object5, string, object3.getArguments(), null, ElementKind.CLASS, n2);
                }
                return CreateElement.prepareCreateOuterClassFix(compilationInfo, treePath7, typeElement, EnumSet.noneOf(Modifier.class), string, object3.getArguments(), null, ElementKind.CLASS, n2);
            }
            if (object3.getClassBody() != null) {
                return Collections.emptyList();
            }
            list = (TypeElement)object2;
            object4.addAll(CreateElement.prepareCreateMethodFix(compilationInfo, treePath7, CreateElement.getAccessModifiers(compilationInfo, typeElement, (TypeElement)((Object)list)), (TypeElement)((Object)list), "<init>", object3.getArguments(), null));
        }
        object3 = EnumSet.noneOf(ElementKind.class);
        object2 = new TypeMirror[1];
        list = (List<? extends TypeMirror>)new int[1];
        object = CreateElementUtilities.resolveType((Set<ElementKind>)object3, compilationInfo, treePath2, treePath.getLeaf(), n, (TypeMirror[])object2, list);
        ElementKind elementKind = CreateElement.getClassType((Set<ElementKind>)object3);
        if (elementKind != null) {
            if (bl4) {
                object4.addAll(CreateElement.prepareCreateInnerClassFix(compilationInfo, null, typeElement2, (Set<Modifier>)object5, string, null, (TypeMirror)object2[0], elementKind, (int)list[0]));
            } else {
                object4.addAll(CreateElement.prepareCreateOuterClassFix(compilationInfo, null, typeElement, EnumSet.noneOf(Modifier.class), string, null, (TypeMirror)object2[0], elementKind, (int)list[0]));
            }
        }
        if (object == null || object.isEmpty()) {
            return object4;
        }
        TypeMirror typeMirror = (TypeMirror)object.get(0);
        if (typeMirror == null || typeMirror.getKind() == TypeKind.VOID || typeMirror.getKind() == TypeKind.EXECUTABLE) {
            return object4;
        }
        if (CreateElement.containsErrorsOrTypevarsRecursively(typeMirror)) {
            return object4;
        }
        if (object3.contains((Object)ElementKind.FIELD) && CreateElement.isTargetWritable(typeElement2, compilationInfo)) {
            element = object6.getEnclosingElement();
            if (element != null && element.getKind() == ElementKind.ANNOTATION_TYPE) {
                FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement2), (ClasspathInfo)compilationInfo.getClasspathInfo());
                if (fileObject != null) {
                    object4.add((Fix)new CreateMethodFix(compilationInfo, string, (Set<Modifier>)object5, typeElement2, typeMirror, (List<? extends TypeMirror>)object, Collections.<String>emptyList(), fileObject));
                }
                return object4;
            }
            FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement2), (ClasspathInfo)compilationInfo.getClasspathInfo());
            if (fileObject != null) {
                if (typeElement2.getKind() == ElementKind.ENUM) {
                    if (typeElement.equals(typeElement2)) {
                        object4.add((Fix)new CreateFieldFix(compilationInfo, string, (Set<Modifier>)object5, typeElement2, typeMirror, fileObject));
                    } else {
                        object4.add((Fix)new CreateEnumConstant(compilationInfo, string, (Set<Modifier>)object5, typeElement2, typeMirror, fileObject));
                    }
                } else {
                    if (treePath4 != null && compilationInfo.getTrees().getElement(treePath4).getKind() == ElementKind.CONSTRUCTOR && ErrorFixesFakeHint.isCreateFinalFieldsForCtor()) {
                        object5.add(Modifier.FINAL);
                    }
                    if (ErrorFixesFakeHint.enabled(ErrorFixesFakeHint.FixKind.CREATE_FINAL_FIELD_CTOR)) {
                        object4.add((Fix)new CreateFieldFix(compilationInfo, string, (Set<Modifier>)object5, typeElement2, typeMirror, fileObject));
                    }
                }
            }
        }
        if (!bl4 && (object3.contains((Object)ElementKind.LOCAL_VARIABLE) || object.contains((Object)ElementKind.PARAMETER))) {
            element = null;
            if (treePath4 != null) {
                element = (ExecutableElement)compilationInfo.getTrees().getElement(treePath4);
            }
            if (element != null && typeMirror != null) {
                int n3 = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
                if (element != null && object3.contains((Object)ElementKind.PARAMETER) && !Utilities.isMethodHeaderInsideGuardedBlock(compilationInfo, (MethodTree)treePath4.getLeaf())) {
                    object4.add((Fix)new AddParameterOrLocalFix(compilationInfo, typeMirror, string, true, n3));
                }
                if (object3.contains((Object)ElementKind.LOCAL_VARIABLE) && ErrorFixesFakeHint.enabled(ErrorFixesFakeHint.FixKind.CREATE_LOCAL_VARIABLE)) {
                    object4.add((Fix)new AddParameterOrLocalFix(compilationInfo, typeMirror, string, false, n3));
                }
            }
        }
        return object4;
    }

    private static List<Fix> prepareCreateMethodFix(CompilationInfo compilationInfo, TreePath treePath, Set<Modifier> set, TypeElement typeElement, String string, List<? extends ExpressionTree> list, List<? extends TypeMirror> list2) {
        TypeMirror typeMirror;
        Pair<List<? extends TypeMirror>, List<String>> pair = CreateElement.resolveArguments(compilationInfo, treePath, list);
        TypeMirror typeMirror2 = typeMirror = list2 != null ? list2.get(0) : null;
        if (pair == null || typeMirror != null && CreateElement.containsErrorsOrTypevarsRecursively(typeMirror)) {
            return Collections.emptyList();
        }
        if (!CreateElement.isTargetWritable(typeElement, compilationInfo)) {
            return Collections.emptyList();
        }
        FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement), (ClasspathInfo)compilationInfo.getClasspathInfo());
        if (fileObject == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new CreateMethodFix(compilationInfo, string, set, typeElement, typeMirror, pair.getA(), pair.getB(), fileObject));
    }

    private static Pair<List<? extends TypeMirror>, List<String>> resolveArguments(CompilationInfo compilationInfo, TreePath treePath, List<? extends ExpressionTree> list) {
        LinkedList<TypeMirror> linkedList = new LinkedList<TypeMirror>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (ExpressionTree expressionTree : list) {
            TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, expressionTree));
            if ((typeMirror = Utilities.convertIfAnonymous(typeMirror)) == null || CreateElement.containsErrorsOrTypevarsRecursively(typeMirror)) {
                return null;
            }
            if (typeMirror.getKind() == TypeKind.NULL) {
                typeMirror = compilationInfo.getElements().getTypeElement("java.lang.Object").asType();
            }
            linkedList.add(typeMirror);
            String string = Utilities.getName(expressionTree);
            if (string == null) {
                string = Utilities.getName(typeMirror);
            }
            if (string == null) {
                string = "arg";
            }
            if (hashSet.contains(string)) {
                int n = 0;
                while (hashSet.contains(string + n)) {
                    ++n;
                }
                string = string + n;
            }
            hashSet.add(string);
            linkedList2.add(string);
        }
        return new Pair<List<? extends TypeMirror>, List<String>>(linkedList, linkedList2);
    }

    private static List<Fix> prepareCreateOuterClassFix(CompilationInfo compilationInfo, TreePath treePath, TypeElement typeElement, Set<Modifier> set, String string, List<? extends ExpressionTree> list, TypeMirror typeMirror, ElementKind elementKind, int n) {
        Pair<List<? extends TypeMirror>, List<String>> pair;
        Pair<List<? extends TypeMirror>, List<String>> pair2 = pair = treePath != null ? CreateElement.resolveArguments(compilationInfo, treePath, list) : new Pair<List<? extends TypeMirror>, List<String>>(null, null);
        if (pair == null) {
            return Collections.emptyList();
        }
        ClassPath classPath = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
        FileObject fileObject = classPath.findOwnerRoot(compilationInfo.getFileObject());
        if (fileObject == null) {
            return Collections.emptyList();
        }
        TypeElement typeElement2 = compilationInfo.getElementUtilities().outermostTypeElement((Element)typeElement);
        PackageElement packageElement = (PackageElement)typeElement2.getEnclosingElement();
        return Collections.singletonList(new CreateClassFix.CreateOuterClassFix(compilationInfo, fileObject, packageElement.getQualifiedName().toString(), string, set, pair.getA(), pair.getB(), typeMirror, elementKind, n));
    }

    private static List<Fix> prepareCreateInnerClassFix(CompilationInfo compilationInfo, TreePath treePath, TypeElement typeElement, Set<Modifier> set, String string, List<? extends ExpressionTree> list, TypeMirror typeMirror, ElementKind elementKind, int n) {
        Pair<List<? extends TypeMirror>, List<String>> pair;
        Pair<List<? extends TypeMirror>, List<String>> pair2 = pair = treePath != null ? CreateElement.resolveArguments(compilationInfo, treePath, list) : new Pair<List<? extends TypeMirror>, List<String>>(null, null);
        if (pair == null) {
            return Collections.emptyList();
        }
        if (!CreateElement.isTargetWritable(typeElement, compilationInfo)) {
            return Collections.emptyList();
        }
        FileObject fileObject = SourceUtils.getFile((Element)typeElement, (ClasspathInfo)compilationInfo.getClasspathInfo());
        if (fileObject == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new CreateClassFix.CreateInnerClassFix(compilationInfo, string, set, typeElement, pair.getA(), pair.getB(), typeMirror, elementKind, n, fileObject));
    }

    private static ElementKind getClassType(Set<ElementKind> set) {
        if (set.contains((Object)ElementKind.CLASS)) {
            return ElementKind.CLASS;
        }
        if (set.contains((Object)ElementKind.ANNOTATION_TYPE)) {
            return ElementKind.ANNOTATION_TYPE;
        }
        if (set.contains((Object)ElementKind.INTERFACE)) {
            return ElementKind.INTERFACE;
        }
        if (set.contains((Object)ElementKind.ENUM)) {
            return ElementKind.ENUM;
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return CreateElement.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(CreateElement.class, (String)"LBL_Create_Field");
    }

    public String getDescription() {
        return NbBundle.getMessage(CreateElement.class, (String)"DSC_Create_Field");
    }

    private static boolean containsErrorsOrTypevarsRecursively(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case WILDCARD: 
            case TYPEVAR: 
            case ERROR: {
                return true;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                    if (!CreateElement.containsErrorsOrTypevarsRecursively(typeMirror2)) continue;
                    return true;
                }
                return false;
            }
            case ARRAY: {
                return CreateElement.containsErrorsOrTypevarsRecursively(((ArrayType)typeMirror).getComponentType());
            }
        }
        return false;
    }

    private static boolean isTargetWritable(TypeElement typeElement, CompilationInfo compilationInfo) {
        FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement.getEnclosingElement()), (ClasspathInfo)compilationInfo.getClasspathInfo());
        return fileObject != null && fileObject.canWrite();
    }

    static EnumSet<Modifier> getAccessModifiers(CompilationInfo compilationInfo, TypeElement typeElement, TypeElement typeElement2) {
        Element element;
        TypeElement typeElement3;
        if (typeElement2.getKind().isInterface()) {
            return EnumSet.of(Modifier.PUBLIC);
        }
        TypeElement typeElement4 = compilationInfo.getElementUtilities().outermostTypeElement((Element)typeElement);
        if (typeElement4.equals(typeElement3 = compilationInfo.getElementUtilities().outermostTypeElement((Element)typeElement2))) {
            return EnumSet.of(Modifier.PRIVATE);
        }
        Element element2 = typeElement4.getEnclosingElement();
        if (((Object)element2).equals(element = typeElement3.getEnclosingElement())) {
            return EnumSet.noneOf(Modifier.class);
        }
        return EnumSet.of(Modifier.PUBLIC);
    }
}

