/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.FinalFieldsFromCtorCustomiser;
import org.netbeans.modules.java.hints.errors.LocalVariableFixCustomizer;
import org.netbeans.modules.java.hints.errors.SurroundWithTryCatchLog;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorFixesFakeHint
extends AbstractHint {
    private FixKind kind;
    private static Map<FixKind, ErrorFixesFakeHint> kind2Hint = new EnumMap<FixKind, ErrorFixesFakeHint>(FixKind.class);
    public static final String LOCAL_VARIABLES_INPLACE = "create-local-variables-in-place";
    public static final String SURROUND_USE_EXCEPTIONS = "surround-try-catch-org-openide-util-Exceptions";
    public static final String SURROUND_USE_JAVA_LOGGER = "surround-try-catch-java-util-logging-Logger";
    public static final String FINAL_FIELDS_FROM_CTOR = "create-final-fields-from-ctor";

    private ErrorFixesFakeHint(FixKind fixKind) {
        super(true, false, null, new String[0]);
        this.kind = fixKind;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(ErrorFixesFakeHint.class, (String)("DESC_ErrorFixesFakeHint" + this.kind.name()));
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.noneOf(Tree.Kind.class);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        return null;
    }

    @Override
    public String getId() {
        return ErrorFixesFakeHint.class.getName() + this.kind.name();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ErrorFixesFakeHint.class, (String)("DN_ErrorFixesFakeHint" + this.kind.name()));
    }

    @Override
    public void cancel() {
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        switch (this.kind) {
            case CREATE_LOCAL_VARIABLE: {
                return new LocalVariableFixCustomizer(preferences);
            }
            case SURROUND_WITH_TRY_CATCH: {
                return new SurroundWithTryCatchLog(preferences);
            }
            case CREATE_FINAL_FIELD_CTOR: {
                return new FinalFieldsFromCtorCustomiser(preferences);
            }
        }
        return super.getCustomizer(preferences);
    }

    private static synchronized ErrorFixesFakeHint getHint(FixKind fixKind) {
        ErrorFixesFakeHint errorFixesFakeHint = kind2Hint.get((Object)fixKind);
        if (errorFixesFakeHint == null) {
            errorFixesFakeHint = new ErrorFixesFakeHint(fixKind);
            kind2Hint.put(fixKind, errorFixesFakeHint);
        }
        return errorFixesFakeHint;
    }

    public static boolean enabled(FixKind fixKind) {
        return ErrorFixesFakeHint.getHint(fixKind).isEnabled();
    }

    public static boolean isCreateFinalFieldsForCtor() {
        return ErrorFixesFakeHint.getHint(FixKind.CREATE_FINAL_FIELD_CTOR).getPreferences(null).getBoolean(FINAL_FIELDS_FROM_CTOR, true);
    }

    public static void setCreateFinalFieldsForCtor(Preferences preferences, boolean bl) {
        preferences.putBoolean(FINAL_FIELDS_FROM_CTOR, bl);
    }

    public static void setCreateFinalFieldsForCtor(boolean bl) {
        ErrorFixesFakeHint.setCreateFinalFieldsForCtor(ErrorFixesFakeHint.getHint(FixKind.CREATE_FINAL_FIELD_CTOR).getPreferences(null), bl);
    }

    public static boolean isCreateLocalVariableInPlace() {
        return ErrorFixesFakeHint.getHint(FixKind.CREATE_LOCAL_VARIABLE).getPreferences(null).getBoolean(LOCAL_VARIABLES_INPLACE, true);
    }

    public static void setCreateLocalVariableInPlace(boolean bl) {
        ErrorFixesFakeHint.setCreateLocalVariableInPlace(ErrorFixesFakeHint.getHint(FixKind.CREATE_LOCAL_VARIABLE).getPreferences(null), bl);
    }

    public static void setCreateLocalVariableInPlace(Preferences preferences, boolean bl) {
        preferences.putBoolean(LOCAL_VARIABLES_INPLACE, bl);
    }

    public static boolean isUseExceptions() {
        return ErrorFixesFakeHint.getHint(FixKind.SURROUND_WITH_TRY_CATCH).getPreferences(null).getBoolean(SURROUND_USE_EXCEPTIONS, true);
    }

    public static void setUseExceptions(boolean bl) {
        ErrorFixesFakeHint.setUseExceptions(ErrorFixesFakeHint.getHint(FixKind.SURROUND_WITH_TRY_CATCH).getPreferences(null), bl);
    }

    public static void setUseExceptions(Preferences preferences, boolean bl) {
        preferences.putBoolean(SURROUND_USE_EXCEPTIONS, bl);
    }

    public static boolean isUseLogger() {
        return ErrorFixesFakeHint.getHint(FixKind.SURROUND_WITH_TRY_CATCH).getPreferences(null).getBoolean(SURROUND_USE_JAVA_LOGGER, true);
    }

    public static void setUseLogger(boolean bl) {
        ErrorFixesFakeHint.setUseLogger(ErrorFixesFakeHint.getHint(FixKind.SURROUND_WITH_TRY_CATCH).getPreferences(null), bl);
    }

    public static void setUseLogger(Preferences preferences, boolean bl) {
        preferences.putBoolean(SURROUND_USE_JAVA_LOGGER, bl);
    }

    public static ErrorFixesFakeHint create(FileObject fileObject) {
        if (fileObject.getName().endsWith("surround")) {
            return ErrorFixesFakeHint.getHint(FixKind.SURROUND_WITH_TRY_CATCH);
        }
        if (fileObject.getName().endsWith("local")) {
            return ErrorFixesFakeHint.getHint(FixKind.CREATE_LOCAL_VARIABLE);
        }
        if (fileObject.getName().endsWith("finalfield")) {
            return ErrorFixesFakeHint.getHint(FixKind.CREATE_FINAL_FIELD_CTOR);
        }
        throw new IllegalArgumentException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FixKind {
        SURROUND_WITH_TRY_CATCH,
        CREATE_LOCAL_VARIABLE,
        CREATE_FINAL_FIELD_CTOR;

    }
}

