/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.plugins.mpowerplayer;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.netbeans.spi.mobility.cldcplatform.CLDCPlatformDescriptor;
import org.netbeans.spi.mobility.cldcplatform.CustomCLDCPlatformConfigurator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MPowerPlayerPlatformConfigurator
implements CustomCLDCPlatformConfigurator {
    private static final String DISPLY_NAME = "Emulator_displayname";
    private static final String DESCRIPTION = "Emulator_description";
    private static final String CONFIGURATIONS = "configurations";
    private static final String OPTIONAL = "optional";
    private static final String PROFILES = "profiles";
    private static final String PREVERIFY_COMMAND = "preverify.command";
    private static final String RUN_COMMAND = "run.command";
    private static final String DEBUG_COMMAND = "debug.command";
    private static final String TYPE = "CUSTOM";
    private static final String CHECK_FOLDER = "check.folder";
    private static final String DEVICES = "devices";
    private static final String JAVADOCS_FOLDER = "javadoc.folder";
    private static final String MAJOR_CHECK_FOLDER = "majorCheck.folder";
    private static final String OS_SUPPORTED = "os.supported";
    private Properties apiSettings;
    private List<CLDCPlatformDescriptor.Device> devices;

    private List<CLDCPlatformDescriptor.Profile> createAPISettings() {
        String string = this.apiSettings.getProperty(CONFIGURATIONS) + "," + this.apiSettings.getProperty(PROFILES) + "," + this.apiSettings.getProperty(OPTIONAL);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<CLDCPlatformDescriptor.Profile> arrayList = new ArrayList<CLDCPlatformDescriptor.Profile>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            CLDCPlatformDescriptor.ProfileType profileType;
            String string2 = stringTokenizer.nextToken().trim();
            if (this.apiSettings.getProperty(CONFIGURATIONS).contains(string2)) {
                profileType = CLDCPlatformDescriptor.ProfileType.Configuration;
            } else if (this.apiSettings.getProperty(PROFILES).contains(string2)) {
                profileType = CLDCPlatformDescriptor.ProfileType.Profile;
            } else if (this.apiSettings.getProperty(OPTIONAL).contains(string2)) {
                profileType = CLDCPlatformDescriptor.ProfileType.Optional;
            } else {
                throw new IllegalStateException("Type of profile is necessary to create Platform Descriptor");
            }
            arrayList.add(new CLDCPlatformDescriptor.Profile(this.apiSettings.getProperty(string2 + ".displayname"), this.apiSettings.getProperty(string2 + ".version"), this.apiSettings.getProperty(string2 + ".description"), profileType, this.apiSettings.getProperty(string2 + ".dependencies"), this.apiSettings.getProperty(string2 + ".bcp"), this.apiSettings.getProperty("default").contains(string2)));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static void main(String[] stringArray) {
        MPowerPlayerPlatformConfigurator mPowerPlayerPlatformConfigurator = new MPowerPlayerPlatformConfigurator();
        if (stringArray.length == 1) {
            if (mPowerPlayerPlatformConfigurator.isPossiblePlatform(new File(stringArray[0]))) {
                System.out.println("Found valid MPowerPlayer SDK at " + stringArray[0]);
            } else {
                System.out.println("Did not find valid MPowerPlayer SDK at " + stringArray[0]);
            }
        } else {
            System.out.println("Usage: MPowerPlayerConfigurator <mpp-sdk root>");
        }
    }

    public boolean isPossiblePlatform(File file) {
        File file2;
        String string;
        if (this.apiSettings == null) {
            this.apiSettings = new Properties();
            try {
                this.apiSettings.load(MPowerPlayerPlatformConfigurator.class.getResourceAsStream("Configuration.properties"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        String string2 = this.apiSettings.getProperty(CHECK_FOLDER);
        String string3 = this.apiSettings.getProperty(OS_SUPPORTED);
        if (!string3.equalsIgnoreCase(string = (String)System.getProperties().get("os.name"))) {
            return false;
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Null folder platform check");
        }
        return file.isDirectory() && file.listFiles(new JarFilenameFilter()).length == 4 && file.listFiles(new PlatformFileFilter()).length == 1 && (file2 = new File(file.getPath() + string2)).exists();
    }

    public CLDCPlatformDescriptor getPlatform(File file) {
        if (!this.isPossiblePlatform(file)) {
            return null;
        }
        String string = file.getAbsolutePath();
        String string2 = this.apiSettings.getProperty(JAVADOCS_FOLDER);
        String string3 = "";
        String string4 = this.apiSettings.getProperty(RUN_COMMAND);
        String string5 = this.apiSettings.getProperty(DEBUG_COMMAND);
        String string6 = this.apiSettings.getProperty(PREVERIFY_COMMAND);
        String string7 = NbBundle.getMessage(MPowerPlayerPlatformConfigurator.class, (String)DISPLY_NAME);
        if (string2 == null) {
            throw new IllegalArgumentException("null javadocs folder");
        }
        String string8 = string + string2;
        String string9 = this.apiSettings.getProperty(DEVICES);
        StringTokenizer stringTokenizer = new StringTokenizer(string9, ",");
        this.devices = new ArrayList<CLDCPlatformDescriptor.Device>();
        while (stringTokenizer.hasMoreTokens()) {
            String string10 = stringTokenizer.nextToken().trim();
            this.devices.add(new CLDCPlatformDescriptor.Device(this.apiSettings.getProperty(string10 + ".name"), NbBundle.getMessage(MPowerPlayerPlatformConfigurator.class, (String)DESCRIPTION), Collections.EMPTY_LIST, this.createAPISettings(), new CLDCPlatformDescriptor.Screen(Integer.valueOf(this.apiSettings.getProperty(string10 + ".screen.width").trim()).intValue(), Integer.valueOf(this.apiSettings.getProperty(string10 + ".screen.height").trim()).intValue(), Integer.valueOf(this.apiSettings.getProperty(string10 + ".screen.bitDepth").trim()).intValue(), (Integer.valueOf(this.apiSettings.getProperty(string10 + ".screen.color").trim()) == 1 ? Boolean.TRUE : Boolean.FALSE).booleanValue(), (Integer.valueOf(this.apiSettings.getProperty(string10 + ".screen.touch").trim()) == 1 ? Boolean.TRUE : Boolean.FALSE).booleanValue())));
        }
        return new CLDCPlatformDescriptor(string7, string, TYPE, string3, string8, string6, string4, string5, this.devices);
    }

    public String getRegistryProviderName() {
        return null;
    }

    private class PlatformFileFilter
    implements FileFilter {
        private PlatformFileFilter() {
        }

        public boolean accept(File file) {
            String string = MPowerPlayerPlatformConfigurator.this.apiSettings.getProperty(MPowerPlayerPlatformConfigurator.MAJOR_CHECK_FOLDER);
            return file.getName().equalsIgnoreCase(string) && file.isDirectory();
        }
    }

    private class JarFilenameFilter
    implements FilenameFilter {
        private JarFilenameFilter() {
        }

        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".jar");
        }
    }
}

