/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.dlight.util.DLightMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Range<T extends Number> {
    public static final String STRING_DELIMITER = "..";
    private final T start;
    private final T end;

    public Range(T t, T t2) {
        if (t != null && t2 != null && 0 < ((Comparable)t).compareTo(t2)) {
            throw new IllegalArgumentException(t + " > " + t2);
        }
        this.start = t;
        this.end = t2;
    }

    public T getStart() {
        return this.start;
    }

    public T getEnd() {
        return this.end;
    }

    public boolean contains(T t) {
        return !(this.start != null && ((Number)this.start).longValue() > ((Number)t).longValue() || this.end != null && ((Number)t).longValue() > ((Number)this.end).longValue());
    }

    public boolean intersects(Range<T> range) {
        return ((Number)range.end).longValue() >= ((Number)this.start).longValue() && ((Number)range.start).longValue() <= ((Number)this.end).longValue();
    }

    public void union(List<Range<T>> list) {
        int n = 0;
        boolean bl = false;
        Range range = this;
        T t = range.start;
        T t2 = range.end;
        int n2 = list.size();
        while (n < n2 && !bl) {
            Range<T> range2 = list.get(n);
            if (((Number)range2.start).longValue() <= ((Number)t).longValue() && ((Number)range2.end).longValue() >= ((Number)t2).longValue()) {
                return;
            }
            if (((Number)range2.start).longValue() > ((Number)t2).longValue()) {
                list.add(n, new Range<T>(t, t2));
                return;
            }
            if (((Number)range2.start).longValue() >= ((Number)t).longValue() && ((Number)range2.end).longValue() <= ((Number)t2).longValue()) {
                list.remove(n);
                --n2;
                continue;
            }
            if (((Number)range2.end).longValue() > ((Number)t2).longValue()) {
                list.set(n, new Range<T>(t, range2.end));
                return;
            }
            if (((Number)range2.end).longValue() < ((Number)t).longValue()) {
                ++n;
                continue;
            }
            if (((Number)range2.start).longValue() > ((Number)t2).longValue()) {
                bl = true;
                list.add(n, new Range<T>(t, t2));
                break;
            }
            int n3 = n + 1;
            while (n3 < n2 && ((Number)list.get((int)n3).end).longValue() <= ((Number)t2).longValue()) {
                list.remove(n3);
                --n2;
            }
            if (n3 < n2 && ((Number)list.get((int)n3).start).longValue() <= ((Number)range.end).longValue()) {
                t2 = list.get((int)n3).end;
                list.remove(n3);
                --n2;
            }
            if (n < n2) {
                list.set(n, new Range<T>(range2.start, t2));
            } else {
                list.add(new Range<T>(range2.start, t2));
            }
            bl = true;
        }
        if (!bl) {
            list.add(new Range<T>(t, t2));
        }
    }

    public List<Range<T>> subtract(List<Range<T>> list) {
        int n = 0;
        Range range = this;
        T t = range.start;
        T t2 = range.end;
        LinkedList<Range<T>> linkedList = new LinkedList<Range<T>>();
        boolean bl = false;
        while (n < list.size()) {
            Range<T> range2 = list.get(n);
            if (((Number)range2.start).longValue() <= ((Number)t).longValue() && ((Number)range2.end).longValue() >= ((Number)t2).longValue()) {
                bl = true;
                break;
            }
            if (((Number)range2.start).longValue() > ((Number)t2).longValue()) {
                bl = true;
                linkedList.add(new Range<T>(t, t2));
                break;
            }
            if (((Number)range2.start).longValue() > ((Number)t).longValue()) {
                linkedList.add(new Range<T>(t, range2.start));
                t = range2.start;
                continue;
            }
            if (((Number)range2.end).longValue() <= ((Number)t).longValue()) {
                ++n;
                continue;
            }
            if (((Number)range2.start).longValue() >= ((Number)t2).longValue()) {
                linkedList.add(new Range<T>(t, t2));
                bl = true;
                break;
            }
            if (((Number)range2.end).longValue() >= ((Number)t2).longValue()) {
                t2 = range2.start;
                linkedList.add(new Range<T>(t, t2));
                bl = true;
                break;
            }
            if (((Number)range2.end).longValue() > ((Number)t).longValue()) {
                t = range2.end;
                ++n;
                continue;
            }
            linkedList.add(new Range<T>(t, range2.start));
            t = range2.end;
            ++n;
        }
        if (!bl) {
            linkedList.addLast(new Range<T>(t, t2));
        }
        return linkedList;
    }

    public Range<T> extend(Range<T> range) {
        return new Range<Number>((Number)((Object)DLightMath.min((Comparable)this.start, (Comparable)range.getStart())), (Number)((Object)DLightMath.max((Comparable)this.end, (Comparable)range.getEnd())));
    }

    public String toString() {
        return String.valueOf(this.start) + STRING_DELIMITER + String.valueOf(this.end);
    }

    public String toString(String string, String string2, String string3, String string4, String string5) {
        if (this.start != null || this.end != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null) {
                stringBuilder.append(string);
            }
            if (this.start != null) {
                stringBuilder.append(String.format(string2, this.start));
            }
            if (this.start != null && this.end != null && string3 != null) {
                stringBuilder.append(string3);
            }
            if (this.end != null) {
                stringBuilder.append(String.format(string4, this.end));
            }
            if (string5 != null) {
                stringBuilder.append(string5);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public boolean equals(Object object) {
        if (!(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        if (!(this.start == range.start || this.start != null && this.start.equals(range.start))) {
            return false;
        }
        return this.end == range.end || this.end != null && this.end.equals(range.end);
    }

    public int hashCode() {
        int n = 5;
        n = 53 * n + (this.start != null ? this.start.hashCode() : 0);
        n = 53 * n + (this.end != null ? this.end.hashCode() : 0);
        return n;
    }
}

