/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconUtils {
    private static final String MSG_WRN_ICON_EMPTY = "MSG_NoIcon";
    private static final String MSG_WRN_ICON_WRONG_SIZE = "MSG_WrongIconSize";
    private static final String TITLE_ICON_DIALOG = "TITLE_IconDialog";
    private static final String LBL_ICON_INFO = "LBL_IconInfo";
    private static Reference<JFileChooser> iconChooser;

    public static Set<File> getPossibleIcons(String string) {
        String[] stringArray = new String[]{"16", "24", ""};
        HashSet<File> hashSet = new HashSet<File>();
        File file = new File(string);
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        String string3 = n != -1 ? string2.substring(0, n) : string2;
        String string4 = n != -1 ? string2.substring(n + 1) : null;
        boolean bl = string3.endsWith("24") || string3.endsWith("16");
        string3 = bl ? string3.substring(0, string3.length() - 2) : string3;
        for (int i = 0; i < stringArray.length; ++i) {
            File file2;
            String string5 = stringArray[i];
            String string6 = string3 + string5;
            if (string4 != null) {
                string6 = string6 + '.' + string4;
            }
            if (!(file2 = new File(file.getParentFile(), string6)).exists()) continue;
            hashSet.add(file2);
        }
        return hashSet;
    }

    public static boolean isValidIcon(File file, int n, int n2) {
        Dimension dimension = IconUtils.getIconDimension(file);
        return (double)n == dimension.getWidth() && (double)n2 == dimension.getHeight();
    }

    public static String getNoIconMessage(int n, int n2) {
        return NbBundle.getMessage(IconUtils.class, (String)MSG_WRN_ICON_EMPTY, (Object[])new Object[]{n, n2});
    }

    public static String getIconDimensionMessage(File file, int n, int n2) {
        Dimension dimension = new Dimension(IconUtils.getIconDimension(file));
        if (dimension.height == n2 && dimension.width == n) {
            return "";
        }
        return NbBundle.getMessage(IconUtils.class, (String)MSG_WRN_ICON_WRONG_SIZE, (Object[])new Object[]{dimension.width, dimension.height, n, n2});
    }

    public static Dimension getIconDimension(File file) {
        try {
            ImageIcon imageIcon = new ImageIcon(file.toURI().toURL());
            return new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify((Throwable)malformedURLException);
            return new Dimension(-1, -1);
        }
    }

    public static JFileChooser getIconFileChooser() {
        JFileChooser jFileChooser;
        if (iconChooser != null && (jFileChooser = iconChooser.get()) != null) {
            return jFileChooser;
        }
        jFileChooser = new IconFileChooser();
        iconChooser = new WeakReference<JFileChooser>(jFileChooser);
        return jFileChooser;
    }

    public static JFileChooser getIconFileChooser(String string) {
        File file;
        JFileChooser jFileChooser = IconUtils.getIconFileChooser();
        String string2 = string.trim();
        if (string2.length() > 0 && (file = new File(string2)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        return jFileChooser;
    }

    private static final class IconFilter
    extends FileFilter {
        private IconFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase(Locale.ENGLISH).endsWith("gif") || file.getName().toLowerCase(Locale.ENGLISH).endsWith("png");
        }

        public String getDescription() {
            return "*.gif, *.png";
        }
    }

    private static class IconFileChooser
    extends JFileChooser {
        private final JTextField iconInfo = new JTextField();

        private IconFileChooser() {
            JPanel jPanel = IconFileChooser.getAccesoryPanel(this.iconInfo);
            this.setDialogTitle(NbBundle.getMessage(IconUtils.class, (String)IconUtils.TITLE_ICON_DIALOG));
            this.setAccessory(jPanel);
            this.setAcceptAllFileFilterUsed(false);
            this.setFileSelectionMode(0);
            this.setMultiSelectionEnabled(false);
            this.addChoosableFileFilter(new IconFilter());
            this.setFileView(new FileView(){

                public Icon getIcon(File file) {
                    ImageIcon imageIcon;
                    if ((file.getName().endsWith(".gif") || file.getName().endsWith(".png")) && (imageIcon = new ImageIcon(file.getAbsolutePath())).getIconWidth() == 16 && imageIcon.getIconHeight() == 16) {
                        return imageIcon;
                    }
                    return null;
                }

                public String getName(File file) {
                    File file2 = IconFileChooser.this.getSelectedFile();
                    if (file2 != null && (file2.getName().endsWith(".gif") || file2.getName().endsWith(".png"))) {
                        ImageIcon imageIcon = new ImageIcon(file2.getAbsolutePath());
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(file2.getName()).append(" [");
                        stringBuffer.append(imageIcon.getIconWidth()).append('x').append(imageIcon.getIconHeight());
                        stringBuffer.append(']');
                        IconFileChooser.this.setApproveButtonToolTipText(stringBuffer.toString());
                        IconFileChooser.this.iconInfo.setText(stringBuffer.toString());
                    } else {
                        IconFileChooser.this.iconInfo.setText("");
                    }
                    return super.getName(file);
                }
            });
        }

        private static JPanel getAccesoryPanel(JTextField jTextField) {
            jTextField.setColumns(15);
            jTextField.setEditable(false);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JLabel jLabel = new JLabel();
            jPanel.setLayout(new FlowLayout(0, 6, 0));
            jPanel2.setLayout(new GridLayout(2, 1, 0, 6));
            jLabel.setLabelFor(jTextField);
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(IconUtils.class, (String)IconUtils.LBL_ICON_INFO));
            jPanel2.add(jLabel);
            jPanel2.add(jTextField);
            jPanel.add(jPanel2);
            return jPanel;
        }
    }
}

