/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.CustomComponentHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.ComponentDescriptorWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.ComponentFinalWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.ComponentProducerWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NewLibraryDescriptor;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewComponentDescriptor
implements WizardDescriptor.InstantiatingIterator {
    private static final String WIZARD_TITLE = "LBL_ComponentWizardTitle";
    private static final String LIB_STEPS_COUNT = "LBL_CompWizardStepsCount";
    public static final String COMPONENT_DESCR_STEP = "LBL_PrefixCompDescrStep";
    public static final String COMPONENT_PRODUCER_STEP = "LBL_ComponentProducerStep";
    public static final String PRESENTERS_STEP = "LBL_ComponentPresentersStep";
    public static final String FINAL_STEP = "LBL_ComponentFinalStep";
    public static final String COMPONENT_DESCRIPTOR_POSTFIX = "CD";
    public static final String COMPONENT_PRODUCER_POSTFIX = "Producer";
    public static final String COMPONENT_DECRIPTOR_DEFAULT_PARENT = "org.netbeans.modules.vmd.midp.components.displayables.DisplayableCD";
    public static final boolean COMPONENT_DECRIPTOR_DEFAULT_CAN_INSTANTIATE = true;
    public static final boolean COMPONENT_DECRIPTOR_DEFAULT_CAN_BE_SUPER = true;
    public static final String HELPER = "custCompHelper";
    public static final String CC_PREFIX = "prefix";
    public static final String CD_CLASS_NAME = "compDescrClassName";
    public static final String CD_TYPE_ID = "compDescrTypeId";
    public static final String CD_SUPER_DESCR_CLASS = "compDescrSuperClass";
    public static final String CD_VERSION = "compDescrVersion";
    public static final String CD_CAN_INSTANTIATE = "compDescrCanInstantiate";
    public static final String CD_CAN_BE_SUPER = "compDescrCanBeSuper";
    public static final String CP_CLASS_NAME = "compProdClassName";
    public static final String CP_PALETTE_DISP_NAME = "compProdPaletteDispName";
    public static final String CP_PALETTE_TIP = "compProdPaletteTip";
    public static final String CP_PALETTE_CATEGORY = "compProdPaletteCategory";
    public static final String CP_SMALL_ICON = "compProdSmallIcon";
    public static final String CP_LARGE_ICON = "compProdLargeIcon";
    public static final String CP_ADD_LIB = "compProdAddLib";
    public static final String CP_LIB_NAME = "compProdLibName";
    public static final String CP_VALID_ALWAYS = "compProdValidAlways";
    public static final String CP_VALID_PLATFORM = "compProdValidPlatform";
    public static final String CP_VALID_CUSTOM = "compProdValidCustom";
    private int myCurrentIndex;
    private WizardDescriptor.Panel[] myPanels;
    private WizardDescriptor myWizard;
    private WizardDescriptor myMainWizard;
    private CustomComponentHelper myCustCompHelper;

    public NewComponentDescriptor() {
    }

    NewComponentDescriptor(WizardDescriptor wizardDescriptor) {
        this.myMainWizard = wizardDescriptor;
        assert (this.myMainWizard != null);
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.myWizard = wizardDescriptor;
        this.myCurrentIndex = 0;
        this.myPanels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.myPanels.length; ++i) {
            Component component = this.myPanels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
        wizardDescriptor.setTitle(NbBundle.getMessage(NewLibraryDescriptor.class, (String)WIZARD_TITLE));
        this.initWizardData();
    }

    private void initWizardData() {
        if (this.myMainWizard != null) {
            this.myCustCompHelper = new CustomComponentHelper.InstantiationToWizardHelper(this.myMainWizard, this.myWizard);
        } else {
            Project project = Templates.getProject((WizardDescriptor)this.myWizard);
            assert (project != null);
            this.myCustCompHelper = new CustomComponentHelper.RealInstantiationHelper(project, this.myWizard);
        }
        assert (this.myCustCompHelper != null);
        this.myWizard.putProperty(HELPER, (Object)this.myCustCompHelper);
    }

    public Set<?> instantiate() throws IOException {
        assert (this.myCustCompHelper != null);
        return this.myCustCompHelper.instantiate();
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.myWizard.putProperty(HELPER, null);
        this.myWizard.putProperty(CC_PREFIX, null);
        this.myWizard.putProperty(CD_CLASS_NAME, null);
        this.myWizard.putProperty(CD_TYPE_ID, null);
        this.myWizard.putProperty(CD_SUPER_DESCR_CLASS, null);
        this.myWizard.putProperty(CD_VERSION, null);
        this.myWizard.putProperty(CD_CAN_INSTANTIATE, null);
        this.myWizard.putProperty(CD_CAN_BE_SUPER, null);
        this.myWizard.putProperty(CP_CLASS_NAME, null);
        this.myWizard.putProperty(CP_PALETTE_DISP_NAME, null);
        this.myWizard.putProperty(CP_PALETTE_TIP, null);
        this.myWizard.putProperty(CP_PALETTE_CATEGORY, null);
        this.myWizard.putProperty(CP_SMALL_ICON, null);
        this.myWizard.putProperty(CP_LARGE_ICON, null);
        this.myWizard.putProperty(CP_ADD_LIB, null);
        this.myWizard.putProperty(CP_LIB_NAME, null);
        this.myWizard.putProperty(CP_VALID_ALWAYS, null);
        this.myWizard.putProperty(CP_VALID_PLATFORM, null);
        this.myWizard.putProperty(CP_VALID_CUSTOM, null);
        this.myWizard = null;
        this.myPanels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.myPanels[this.myCurrentIndex];
    }

    public boolean hasNext() {
        return this.myCurrentIndex < this.myPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.myCurrentIndex > 0;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getBundle(NewComponentDescriptor.class).getString(LIB_STEPS_COUNT), this.myCurrentIndex + 1, this.myPanels.length);
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.myCurrentIndex;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.myCurrentIndex;
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new ComponentDescriptorWizardPanel(), new ComponentProducerWizardPanel(), new ComponentFinalWizardPanel()};
    }

    protected static String createDefaultCDClass(String string) {
        return string + COMPONENT_DESCRIPTOR_POSTFIX;
    }

    protected static String createDefaultProducerClass(String string) {
        return string + COMPONENT_PRODUCER_POSTFIX;
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(NewComponentDescriptor.class, (String)COMPONENT_DESCR_STEP), NbBundle.getMessage(NewComponentDescriptor.class, (String)COMPONENT_PRODUCER_STEP), NbBundle.getMessage(NewComponentDescriptor.class, (String)FINAL_STEP)};
    }
}

