/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;

public class CsmCompletionUtils {
    public static final String CPP_AUTO_COMPLETION_TRIGGERS = "cppAutoCompletionTriggers";
    public static final String PREPRPOC_AUTO_COMPLETION_TRIGGERS = "autoCompletionTriggersPreproc";
    public static final String CPP_AUTO_INSERT_INCLUDE_DIRECTIVES = "autoInsertIncludeDirectives";

    private CsmCompletionUtils() {
    }

    public static String getMimeType(Document document) {
        return (String)document.getProperty("mimeType");
    }

    public static String getMimeType(JTextComponent jTextComponent) {
        EditorKit editorKit;
        if (jTextComponent == null) {
            return "";
        }
        Document document = jTextComponent.getDocument();
        String string = CsmCompletionUtils.getMimeType(document);
        if (string == null && (editorKit = jTextComponent.getUI().getEditorKit(jTextComponent)) != null) {
            string = editorKit.getContentType();
        }
        return string;
    }

    public static boolean isCaseSensitive(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class);
        return preferences.getBoolean("completion-case-sensitive", false);
    }

    public static boolean isNaturalSort(String string) {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class);
        return preferences.getBoolean("completion-natural-sort", false);
    }

    public static boolean isAutoInsertIncludeDirectives() {
        String string = "text/x-c++";
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class);
        return preferences.getBoolean(CPP_AUTO_INSERT_INCLUDE_DIRECTIVES, true);
    }
}

