/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.completion.cplusplus.CsmFinderImpl;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.filesystems.FileObject;

public final class CsmFinderFactory {
    private static CsmFinderFactory DEFAULT;
    private Map<FileObject, Reference<CsmFinder>> cache = new HashMap<FileObject, Reference<CsmFinder>>();
    private WeakHashMap cpListening = new WeakHashMap();
    private WeakHashMap fakeClasses = new WeakHashMap();
    private static PropertyChangeListener cpListener;
    private SoftReference globalFinder;
    private final Object CACHE_LOCK = new Object();
    private boolean useFakeFinder = false;

    private CsmFinderFactory() {
    }

    public static synchronized CsmFinderFactory getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new CsmFinderFactory();
        }
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.cache = new HashMap<FileObject, Reference<CsmFinder>>();
            this.invalidateGlobalFinderCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CsmFinder getFinder(FileObject fileObject) {
        FileObject fileObject2 = null;
        FileObject fileObject3 = fileObject2 != null ? fileObject2 : fileObject;
        CsmFinder csmFinder = this.retrieveFromCache(fileObject3);
        if (csmFinder != null) {
            return csmFinder;
        }
        CsmFile csmFile = CsmUtilities.getCsmFile((FileObject)fileObject, (boolean)true);
        ArrayList<CsmFinder> arrayList = new ArrayList<CsmFinder>();
        if (csmFile != null) {
            csmFinder = new CsmFinderImpl(csmFile, this.getMimeType());
            return csmFinder;
        }
        arrayList.add(this.getGlobalFinder());
        csmFinder = this.getGlobalFinder();
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.cache.put(fileObject3, new SoftReference<CsmFinder>(csmFinder));
        }
        return csmFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CsmFinder getGlobalFinder() {
        CsmFinder csmFinder;
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            csmFinder = this.globalFinder != null ? (CsmFinder)this.globalFinder.get() : null;
        }
        if (csmFinder != null) {
            return csmFinder;
        }
        csmFinder = new CsmFinderImpl((FileObject)null, this.getMimeType());
        object = this.CACHE_LOCK;
        synchronized (object) {
            this.globalFinder = new SoftReference<CsmFinder>(csmFinder);
        }
        return csmFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateGlobalFinderCache() {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.globalFinder = null;
        }
    }

    private String getMimeType() {
        return "text/x-c++";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmFinder retrieveFromCache(FileObject fileObject) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            SoftReference softReference = (SoftReference)this.cache.get(fileObject);
            return softReference != null ? (CsmFinder)softReference.get() : null;
        }
    }
}

