/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CodeCompletionPanel
extends JPanel
implements DocumentListener {
    private final Preferences preferences;
    private JTextField autoCompletionTriggersField;
    private JLabel autoCompletionTriggersLabel;
    private JTextField autoCompletionTriggersPreprocField;
    private JLabel autoCompletionTriggersPreprocLabel;
    private JCheckBox autoInsertIncludeDirectives;
    private JSeparator jSeparator1;

    public CodeCompletionPanel(Preferences preferences) {
        this.preferences = preferences;
        this.initComponents();
        this.autoInsertIncludeDirectives.setSelected(preferences.getBoolean("autoInsertIncludeDirectives", true));
        this.autoCompletionTriggersField.setText(preferences.get("cppAutoCompletionTriggers", ".->::"));
        this.autoCompletionTriggersPreprocField.setText(preferences.get("autoCompletionTriggersPreproc", "\"<"));
        this.autoCompletionTriggersField.getDocument().addDocumentListener(this);
        this.autoCompletionTriggersPreprocField.getDocument().addDocumentListener(this);
    }

    public static PreferencesCustomizer.Factory getCustomizerFactory() {
        return new PreferencesCustomizer.Factory(){

            public PreferencesCustomizer create(Preferences preferences) {
                return new CodeCompletionPreferencesCusromizer(preferences);
            }
        };
    }

    private void initComponents() {
        this.autoCompletionTriggersLabel = new JLabel();
        this.autoCompletionTriggersField = new JTextField();
        this.autoInsertIncludeDirectives = new JCheckBox();
        this.autoCompletionTriggersPreprocLabel = new JLabel();
        this.autoCompletionTriggersPreprocField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.autoCompletionTriggersLabel.setLabelFor(this.autoCompletionTriggersField);
        Mnemonics.setLocalizedText((JLabel)this.autoCompletionTriggersLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTriggersLabel.text"));
        this.autoCompletionTriggersField.setAlignmentX(1.0f);
        this.autoInsertIncludeDirectives.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.autoInsertIncludeDirectives, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoInclude.text"));
        this.autoInsertIncludeDirectives.setBorder(null);
        this.autoInsertIncludeDirectives.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeCompletionPanel.this.autoInsertIncludeDirectivesActionPerformed(actionEvent);
            }
        });
        this.autoCompletionTriggersPreprocLabel.setLabelFor(this.autoCompletionTriggersPreprocField);
        Mnemonics.setLocalizedText((JLabel)this.autoCompletionTriggersPreprocLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTriggersPreprocLabel.text"));
        this.autoCompletionTriggersPreprocField.setAlignmentX(1.0f);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.autoCompletionTriggersLabel).add((Component)this.autoCompletionTriggersPreprocLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.autoCompletionTriggersPreprocField, -2, 86, -2).add((Component)this.autoCompletionTriggersField, -2, 86, -2)).add(33, 33, 33)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.autoInsertIncludeDirectives).addContainerGap(37, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator1, -1, 377, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.autoCompletionTriggersLabel).add((Component)this.autoCompletionTriggersField, -2, -1, -2)).addPreferredGap(0).add((Component)this.autoInsertIncludeDirectives).add(24, 24, 24).add((Component)this.jSeparator1, -2, -1, -2).add(23, 23, 23).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.autoCompletionTriggersPreprocLabel).add((Component)this.autoCompletionTriggersPreprocField, -2, -1, -2)).addContainerGap(168, Short.MAX_VALUE)));
    }

    private void autoInsertIncludeDirectivesActionPerformed(ActionEvent actionEvent) {
        this.preferences.putBoolean("autoInsertIncludeDirectives", this.autoInsertIncludeDirectives.isSelected());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    private void update(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.autoCompletionTriggersField.getDocument()) {
            this.preferences.put("cppAutoCompletionTriggers", this.autoCompletionTriggersField.getText());
        } else if (documentEvent.getDocument() == this.autoCompletionTriggersPreprocField.getDocument()) {
            this.preferences.put("autoCompletionTriggersPreproc", this.autoCompletionTriggersPreprocField.getText());
        }
    }

    private static class CodeCompletionPreferencesCusromizer
    implements PreferencesCustomizer {
        private Preferences preferences;

        private CodeCompletionPreferencesCusromizer(Preferences preferences) {
            this.preferences = preferences;
        }

        public String getId() {
            return "org.netbeans.modules.cnd.completion.options";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanelName");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("netbeans.optionsDialog.editor.codeCompletion.cpp");
        }

        public JComponent getComponent() {
            return new CodeCompletionPanel(this.preferences);
        }
    }
}

