/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.activesync;

import java.io.IOException;
import java.io.InputStream;
import org.netbeans.mobility.activesync.RemoteFile;

public class RemoteFileInputStream
extends InputStream {
    private RemoteFile file;
    private String fullPath;
    private int nFile;

    RemoteFileInputStream(RemoteFile remoteFile) {
        this.file = remoteFile;
        this.fullPath = remoteFile.getFullPath();
        this.nFile = this.nOpen(this.fullPath);
    }

    public int available() throws IOException {
        this.ensureOpen();
        return this.nAvailable(this.nFile);
    }

    public void close() throws IOException {
        this.ensureOpen();
        this.nClose(this.nFile);
        this.nFile = 0;
    }

    public void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        this.read(byArray);
        return byArray[0];
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        return this.nRead(this.nFile, byArray, n, n2);
    }

    public void reset() throws IOException {
        this.ensureOpen();
        this.nReset(this.nFile);
    }

    private void ensureOpen() throws IOException {
        if (this.nFile == 0) {
            throw new IOException("stream is closed");
        }
    }

    private native int nOpen(String var1);

    private native void nClose(int var1);

    private native int nAvailable(int var1);

    private native int nRead(int var1, byte[] var2, int var3, int var4);

    private native void nReset(int var1);
}

