/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.io.IOException;
import java.util.Arrays;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.loaders.DataObject;

public abstract class ResourceHolder {
    protected DataObject resource;
    protected final Class[] resourceClasses;

    public ResourceHolder(Class[] classArray) {
        if (classArray == null || classArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.resourceClasses = classArray;
    }

    public void setResource(DataObject dataObject) {
        if (dataObject == null) {
            this.resource = null;
            return;
        }
        Class<?> clazz = dataObject.getClass();
        if (!Arrays.asList(this.resourceClasses).contains(clazz)) {
            throw new IllegalArgumentException();
        }
        if (!dataObject.equals(this.resource)) {
            this.resource = dataObject;
        }
    }

    public DataObject getResource() {
        return this.resource;
    }

    public Class[] getResourceClasses() {
        return this.resourceClasses;
    }

    public abstract String[] getAllKeys();

    public abstract String getValueForKey(String var1);

    public abstract String getCommentForKey(String var1);

    public void addProperty(Object object, Object object2, String string) {
        boolean bl = I18nUtil.getOptions().isReplaceResourceValue();
        this.addProperty(object, object2, string, bl);
    }

    public abstract void addProperty(Object var1, Object var2, String var3, boolean var4);

    public final DataObject getTemplate(Class clazz) throws IOException {
        if (!Arrays.asList(this.resourceClasses).contains(clazz)) {
            throw new IllegalArgumentException();
        }
        return this.createTemplate(clazz);
    }

    protected abstract DataObject createTemplate(Class var1) throws IOException;

    public String toString() {
        return super.toString() + "[resource=" + String.valueOf(this.resource) + ", resourceClasses=" + Arrays.toString(this.resourceClasses) + ']';
    }
}

