/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.KenaiUtil;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;

public class KenaiRepositoryUtils {
    private static KenaiRepositoryUtils instance;
    private Map<String, Repository> map = new HashMap<String, Repository>();

    public static KenaiRepositoryUtils getInstance() {
        if (instance == null) {
            instance = new KenaiRepositoryUtils();
        }
        return instance;
    }

    public Repository getRepository(KenaiProject kenaiProject) {
        return this.getRepository(kenaiProject, true);
    }

    public Repository getRepository(KenaiProject kenaiProject, boolean bl) {
        BugtrackingConnector[] bugtrackingConnectorArray;
        Repository repository = this.map.get(kenaiProject.getName());
        if (repository != null) {
            return repository;
        }
        if (!bl) {
            return null;
        }
        for (BugtrackingConnector bugtrackingConnector : bugtrackingConnectorArray = BugtrackingManager.getInstance().getConnectors()) {
            KenaiSupport kenaiSupport = (KenaiSupport)bugtrackingConnector.getLookup().lookup(KenaiSupport.class);
            if (kenaiSupport == null || (repository = kenaiSupport.createRepository(kenaiProject)) == null) continue;
            this.map.put(kenaiProject.getName(), repository);
            return repository;
        }
        return null;
    }

    Repository getRepository(ProjectHandle projectHandle) {
        return this.getRepository(projectHandle, true);
    }

    Repository getRepository(ProjectHandle projectHandle, boolean bl) {
        KenaiProject kenaiProject = KenaiUtil.getKenaiProject(projectHandle);
        if (kenaiProject == null) {
            BugtrackingManager.LOG.warning("No issue tracking repository available for ProjectHandle [" + projectHandle.getId() + "," + projectHandle.getDisplayName() + "]");
            return null;
        }
        Repository repository = this.map.get(kenaiProject.getName());
        if (repository != null) {
            return repository;
        }
        if (!bl) {
            return null;
        }
        repository = this.getRepository(kenaiProject);
        if (repository == null) {
            BugtrackingManager.LOG.warning("No issue tracking repository available for project " + kenaiProject.getName());
            return null;
        }
        return repository;
    }
}

