/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.IssueAccessorImpl;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Issue {
    private static final int SHORT_DISP_NAME_LENGTH = 15;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final String EVENT_ISSUE_DATA_CHANGED = "issue.data_changed";
    private Repository repository;
    private static final RequestProcessor rp = new RequestProcessor("Bugtracking Issue");
    private Node[] selection;

    public Issue(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public abstract String getDisplayName();

    public String getShortenedDisplayName() {
        int n;
        String string = this.getDisplayName();
        int n2 = string.length();
        if (n2 <= (n = 15)) {
            return string;
        }
        String string2 = string.substring(0, n).trim();
        StringBuilder stringBuilder = new StringBuilder(n + 4);
        stringBuilder.append(string2);
        if (n2 > n + 1 && Character.isSpaceChar(string.charAt(n))) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("...");
        return stringBuilder.toString();
    }

    public abstract String getTooltip();

    public abstract boolean isNew();

    public abstract boolean refresh();

    public abstract void addComment(String var1, boolean var2);

    public abstract void attachPatch(File var1, String var2);

    public abstract BugtrackingController getController();

    public static void open(final Repository repository, final String string) {
        assert (string != null);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                final IssueTopComponent issueTopComponent = IssueTopComponent.find(string);
                final boolean bl = issueTopComponent.isOpened();
                final Issue[] issueArray = new Issue[]{issueTopComponent.getIssue()};
                if (issueArray[0] == null) {
                    issueTopComponent.initNoIssue(string);
                }
                if (!bl) {
                    issueTopComponent.open();
                }
                issueTopComponent.requestActive();
                rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ProgressHandle progressHandle = null;
                        try {
                            if (issueArray[0] != null) {
                                progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Issue.class, (String)"LBL_REFRESING_ISSUE", (Object[])new Object[]{string}));
                                progressHandle.start();
                                issueArray[0].refresh();
                            } else {
                                progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Issue.class, (String)"LBL_OPENING_ISSUE", (Object[])new Object[]{string}));
                                progressHandle.start();
                                issueArray[0] = repository.getIssue(string);
                                if (issueArray[0] == null) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            if (!bl) {
                                                issueTopComponent.close();
                                            }
                                        }
                                    });
                                    return;
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        issueTopComponent.setIssue(issueArray[0]);
                                    }
                                });
                                IssueCacheUtils.setSeen(issueArray[0], true);
                            }
                        }
                        finally {
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                        }
                    }
                });
            }
        });
    }

    public final void open() {
        this.open(false);
    }

    public final void open(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IssueTopComponent issueTopComponent = IssueTopComponent.find(Issue.this);
                issueTopComponent.open();
                issueTopComponent.requestActive();
                rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Issue.class, (String)"LBL_REFRESING_ISSUE", (Object[])new Object[]{Issue.this.getID()}));
                        try {
                            progressHandle.start();
                            if (bl && !Issue.this.refresh()) {
                                return;
                            }
                            IssueCacheUtils.setSeen(Issue.this, true);
                        }
                        finally {
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                        }
                    }
                });
            }
        });
    }

    public abstract IssueNode getNode();

    public abstract String getID();

    public abstract String getSummary();

    public abstract Map<String, String> getAttributes();

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    protected void fireDataChanged() {
        this.support.firePropertyChange(EVENT_ISSUE_DATA_CHANGED, null, null);
    }

    void setSelection(Node[] nodeArray) {
        this.selection = nodeArray;
    }

    protected Node[] getSelection() {
        return this.selection;
    }

    static {
        IssueAccessorImpl.create();
    }
}

