/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class LinkButton
extends JButton
implements MouseListener,
FocusListener {
    private static final Font BUTTON_FONT = LinkButton.getButtonFont();
    private static final Color LINK_IN_FOCUS_COLOR = new Color(16748032);
    private static final Color LINK_COLOR = new Color(1461115);
    private static final Color MOUSE_OVER_LINK_COLOR = new Color(16748032);
    private static final Color VISITED_LINK_COLOR = new Color(5607890);
    private static final Stroke LINK_IN_FOCUS_STROKE = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{0.0f, 2.0f}, 0.0f);
    private boolean underline = false;

    public LinkButton(String string, Icon icon) {
        super(string, icon);
        this.init();
    }

    public LinkButton(Action action) {
        super(action);
        this.init();
    }

    public LinkButton(String string) {
        super(string);
        this.init();
    }

    public LinkButton(Icon icon) {
        super(icon);
        this.init();
    }

    public LinkButton() {
        this.init();
    }

    private void init() {
        this.setForeground(LINK_COLOR);
        this.setFont(BUTTON_FONT);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.setFocusable(true);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.addFocusListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this.underline = true;
            this.setForeground(LINK_IN_FOCUS_COLOR);
            this.repaint();
            this.onMouseEntered(mouseEvent);
            this.setForeground(MOUSE_OVER_LINK_COLOR);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this.underline = false;
            this.setForeground(this.isVisited() ? VISITED_LINK_COLOR : LINK_COLOR);
            this.repaint();
            this.onMouseExited(mouseEvent);
        }
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = LinkButton.prepareGraphics(graphics);
        super.paintComponent(graphics2D);
        Dimension dimension = this.getSize();
        if (this.hasFocus() && this.isEnabled()) {
            graphics2D.setStroke(LINK_IN_FOCUS_STROKE);
            graphics2D.setColor(LINK_IN_FOCUS_COLOR);
            graphics2D.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    protected void onMouseExited(MouseEvent mouseEvent) {
    }

    protected void onMouseEntered(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.underline && this.isEnabled()) {
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = 0;
            if (null != this.getIcon()) {
                n = this.getIcon().getIconWidth() + this.getIconTextGap();
            }
            int n2 = n;
            int n3 = fontMetrics.getHeight();
            int n4 = fontMetrics.stringWidth(this.getText()) + n;
            if (this.getText().length() > 0) {
                graphics.drawLine(n2, n3, n4, n3);
            }
        }
    }

    protected boolean isVisited() {
        return false;
    }

    private static Graphics2D prepareGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map == null && Boolean.getBoolean("swing.aatext")) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (map != null) {
            graphics2D.addRenderingHints(map);
        }
        return graphics2D;
    }

    private static Font getButtonFont() {
        Font font = UIManager.getFont("Button.font");
        if (font != null) {
            return font;
        }
        return new Font(null, 0, 12);
    }
}

