/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import java.io.File;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationCustom;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.apache.maven.project.aspect.ProfileErrorReporterAspect;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class CustomActivator
implements ProfileActivator,
Contextualizable,
LogEnabled {
    private PlexusContainer container;
    private Logger logger;

    public boolean canDetermineActivation(Profile profile, ProfileActivationContext context) throws ProfileActivationException {
        ActivationCustom custom;
        Activation activation = profile.getActivation();
        if (activation != null && (custom = activation.getCustom()) != null) {
            ProfileActivator profileActivator;
            ProfileActivationContext profileActivationContext = context;
            ActivationCustom activationCustom = custom;
            CustomActivator customActivator = this;
            try {
                profileActivator = customActivator.loadProfileActivator(activationCustom, profileActivationContext);
            }
            catch (ProfileActivationException profileActivationException) {
                if (ProfileErrorReporterAspect.ajc$cflowStack$0.isValid() && ProfileErrorReporterAspect.ajc$cflowStack$1.isValid()) {
                    ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$3$b080968d(customActivator, (Model)ProfileErrorReporterAspect.ajc$cflowStack$0.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$0.get(1), (Profile)ProfileErrorReporterAspect.ajc$cflowStack$1.get(0), (ProfileActivationContext)ProfileErrorReporterAspect.ajc$cflowStack$1.get(1), profileActivationException);
                }
                throw profileActivationException;
            }
            ProfileActivator activator = profileActivator;
            if (activator != null) {
                boolean bl;
                ProfileActivationContext profileActivationContext2 = context;
                Profile profile2 = profile;
                ProfileActivator profileActivator2 = activator;
                try {
                    bl = profileActivator2.canDetermineActivation(profile2, profileActivationContext2);
                }
                catch (ProfileActivationException profileActivationException) {
                    if (ProfileErrorReporterAspect.ajc$cflowStack$0.isValid() && ProfileErrorReporterAspect.ajc$cflowStack$1.isValid()) {
                        ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$3$b080968d(profileActivator2, (Model)ProfileErrorReporterAspect.ajc$cflowStack$0.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$0.get(1), (Profile)ProfileErrorReporterAspect.ajc$cflowStack$1.get(0), (ProfileActivationContext)ProfileErrorReporterAspect.ajc$cflowStack$1.get(1), profileActivationException);
                    }
                    throw profileActivationException;
                }
                return bl;
            }
        }
        return false;
    }

    private ProfileActivator loadProfileActivator(ActivationCustom custom, ProfileActivationContext context) throws ProfileActivationException {
        ProfileActivator activator;
        block5: {
            String type;
            block4: {
                type = custom.getType();
                activator = null;
                try {
                    activator = (ProfileActivator)this.container.lookup(ProfileActivator.ROLE, type);
                }
                catch (ComponentLookupException e) {
                    if (context.isCustomActivatorFailureSuppressed()) break block4;
                    throw new ProfileActivationException("Cannot find custom ProfileActivator: " + type + ". \nPerhaps you're missing a build extension?", e);
                }
            }
            XmlPlexusConfiguration configuration = new XmlPlexusConfiguration((Xpp3Dom)custom.getConfiguration());
            BasicComponentConfigurator configurator = new BasicComponentConfigurator();
            try {
                configurator.configureComponent(activator, configuration, this.container.getContainerRealm());
            }
            catch (ComponentConfigurationException e) {
                if (context.isCustomActivatorFailureSuppressed()) break block5;
                throw new ProfileActivationException("Failed to configure custom ProfileActivator: " + type + ".", e);
            }
        }
        return activator;
    }

    public boolean isActive(Profile profile, ProfileActivationContext context) throws ProfileActivationException {
        boolean bl;
        ProfileActivator profileActivator;
        ActivationCustom custom = profile.getActivation().getCustom();
        ProfileActivationContext profileActivationContext = context;
        ActivationCustom activationCustom = custom;
        CustomActivator customActivator = this;
        try {
            profileActivator = customActivator.loadProfileActivator(activationCustom, profileActivationContext);
        }
        catch (ProfileActivationException profileActivationException) {
            if (ProfileErrorReporterAspect.ajc$cflowStack$0.isValid() && ProfileErrorReporterAspect.ajc$cflowStack$1.isValid()) {
                ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$3$b080968d(customActivator, (Model)ProfileErrorReporterAspect.ajc$cflowStack$0.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$0.get(1), (Profile)ProfileErrorReporterAspect.ajc$cflowStack$1.get(0), (ProfileActivationContext)ProfileErrorReporterAspect.ajc$cflowStack$1.get(1), profileActivationException);
            }
            throw profileActivationException;
        }
        ProfileActivator activator = profileActivator;
        ProfileActivationContext profileActivationContext2 = context;
        Profile profile2 = profile;
        ProfileActivator profileActivator2 = activator;
        try {
            bl = profileActivator2.isActive(profile2, profileActivationContext2);
        }
        catch (ProfileActivationException profileActivationException) {
            if (ProfileErrorReporterAspect.ajc$cflowStack$0.isValid() && ProfileErrorReporterAspect.ajc$cflowStack$1.isValid()) {
                ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$3$b080968d(profileActivator2, (Model)ProfileErrorReporterAspect.ajc$cflowStack$0.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$0.get(1), (Profile)ProfileErrorReporterAspect.ajc$cflowStack$1.get(0), (ProfileActivationContext)ProfileErrorReporterAspect.ajc$cflowStack$1.get(1), profileActivationException);
            }
            throw profileActivationException;
        }
        return bl;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(0, "CustomActivator-instantiated");
        }
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

