/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.realm.MavenRealmManager;

public class DefaultProfileActivationContext
implements ProfileActivationContext {
    private boolean isCustomActivatorFailureSuppressed;
    private final Properties executionProperties;
    List explicitlyActive;
    List explicitlyInactive;
    private final MavenRealmManager realmManager;
    private List activeByDefault;

    public DefaultProfileActivationContext(MavenRealmManager realmManager, Properties executionProperties, boolean isCustomActivatorFailureSuppressed) {
        this.realmManager = realmManager;
        this.executionProperties = executionProperties;
        this.isCustomActivatorFailureSuppressed = isCustomActivatorFailureSuppressed;
    }

    public DefaultProfileActivationContext(Properties executionProperties, boolean isCustomActivatorFailureSuppressed) {
        this.realmManager = null;
        this.executionProperties = executionProperties;
        this.isCustomActivatorFailureSuppressed = isCustomActivatorFailureSuppressed;
    }

    public Properties getExecutionProperties() {
        return this.executionProperties;
    }

    public boolean isCustomActivatorFailureSuppressed() {
        return this.isCustomActivatorFailureSuppressed;
    }

    public void setCustomActivatorFailureSuppressed(boolean suppressed) {
        this.isCustomActivatorFailureSuppressed = suppressed;
    }

    public List getExplicitlyActiveProfileIds() {
        if (this.explicitlyActive == null) {
            return Collections.EMPTY_LIST;
        }
        return this.explicitlyActive;
    }

    public void setExplicitlyActiveProfileIds(List active) {
        this.explicitlyActive = active;
    }

    public List getExplicitlyInactiveProfileIds() {
        if (this.explicitlyInactive == null) {
            return Collections.EMPTY_LIST;
        }
        return this.explicitlyInactive;
    }

    public void setExplicitlyInactiveProfileIds(List inactive) {
        this.explicitlyInactive = inactive;
    }

    public MavenRealmManager getRealmManager() {
        return this.realmManager;
    }

    public void setActive(String profileId) {
        if (this.explicitlyActive == null) {
            this.explicitlyActive = new ArrayList();
        }
        this.explicitlyActive.add(profileId);
    }

    public void setInactive(String profileId) {
        if (this.explicitlyInactive == null) {
            this.explicitlyInactive = new ArrayList();
        }
        this.explicitlyInactive.add(profileId);
    }

    public boolean isExplicitlyActive(String profileId) {
        return this.explicitlyActive != null && this.explicitlyActive.contains(profileId);
    }

    public boolean isExplicitlyInactive(String profileId) {
        return this.explicitlyInactive != null && this.explicitlyInactive.contains(profileId);
    }

    public List getActiveByDefaultProfileIds() {
        if (this.activeByDefault == null) {
            return Collections.EMPTY_LIST;
        }
        return this.activeByDefault;
    }

    public boolean isActiveByDefault(String profileId) {
        return this.activeByDefault != null && this.activeByDefault.contains(profileId);
    }

    public void setActiveByDefault(String profileId) {
        if (this.activeByDefault == null) {
            this.activeByDefault = new ArrayList();
        }
        this.activeByDefault.add(profileId);
    }

    public void setActiveByDefaultProfileIds(List activeByDefault) {
        this.activeByDefault = activeByDefault;
    }
}

