/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.TimeContainerRootSupport;

public class SMILSample
implements Runnable {
    protected DocumentNode doc;
    protected TimeContainerRootSupport root;
    protected Time currentTime = new Time(0L);
    protected Clock clock;

    public SMILSample(DocumentNode doc, Clock clock) {
        if (doc == null || doc.timeContainerRootSupport == null) {
            throw new NullPointerException();
        }
        if (clock == null) {
            throw new NullPointerException();
        }
        this.doc = doc;
        this.root = doc.timeContainerRootSupport;
        this.clock = clock;
    }

    public void run() {
        this.currentTime.value = this.clock.currentTimeMillis();
        this.doc.sample(this.currentTime);
        this.doc.applyAnimations();
        this.doc.applyMedia();
    }

    public static class DocumentWallClock
    implements Clock {
        TimeContainerRootSupport tcrs;
        long lastSample = Long.MAX_VALUE;
        boolean reset = false;

        public DocumentWallClock(DocumentNode doc) {
            this.tcrs = doc.timeContainerRootSupport;
        }

        public long currentTimeMillis() {
            if (!this.reset) {
                long ds = System.currentTimeMillis() - this.lastSample;
                this.lastSample += ds;
                return this.tcrs.lastSampleTime.value + ds;
            }
            this.lastSample = System.currentTimeMillis();
            this.reset = false;
            if (!this.tcrs.lastSampleTime.isResolved()) {
                return 0L;
            }
            return this.tcrs.lastSampleTime.value;
        }

        public void start() {
            this.reset = true;
        }
    }

    public static interface Clock {
        public long currentTimeMillis();
    }
}

