/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.copysupport;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.copysupport.FileOperationFactory;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalOperationFactory
extends FileOperationFactory {
    private static final Logger LOGGER = Logger.getLogger(LocalOperationFactory.class.getName());

    LocalOperationFactory(PhpProject phpProject) {
        super(phpProject);
    }

    @Override
    protected boolean isEnabled() {
        return this.isEnabled(true);
    }

    private boolean isEnabled(boolean bl) {
        boolean bl2 = ProjectPropertiesSupport.isCopySourcesEnabled(this.project);
        if (bl) {
            LOGGER.log(Level.FINE, "LOCAL copying enabled for project {0}: {1}", new Object[]{this.project.getName(), bl2});
        }
        return bl2;
    }

    private boolean isEnabledAndValidConfig() {
        boolean bl;
        File file;
        if (!this.isEnabled(false)) {
            LOGGER.log(Level.FINE, "LOCAL copying not enabled for project {0}", this.project.getName());
            return false;
        }
        if (this.isInvalid()) {
            LOGGER.log(Level.FINE, "LOCAL copying invalid for project {0}", this.project.getName());
            return false;
        }
        if (this.getSources() == null) {
            LOGGER.log(Level.WARNING, "LOCAL copying disabled for project {0}. Reason: source root is null", this.project.getName());
            return false;
        }
        File file2 = this.getTargetRoot();
        if (file2 == null) {
            LOGGER.log(Level.INFO, "LOCAL copying disabled for project {0}. Reason: target folder is null", this.project.getName());
            if (this.askUser(NbBundle.getMessage(LocalOperationFactory.class, (String)"MSG_NoTargetFolder", (Object)this.project.getName()))) {
                this.showCustomizer();
            }
            this.invalidate();
            return false;
        }
        for (file = file2; file != null && !file.exists(); file = file.getParentFile()) {
        }
        boolean bl2 = bl = file != null && Utils.isFolderWritable(file);
        if (!bl) {
            LOGGER.log(Level.INFO, "LOCAL copying disabled for project {0}. Reason: target folder {1} is not writable", new Object[]{this.project.getName(), file});
            if (this.askUser(NbBundle.getMessage(LocalOperationFactory.class, (String)"MSG_TargetFolderNotWritable", (Object)this.project.getName(), (Object)file))) {
                this.showCustomizer();
            }
            this.invalidate();
            return false;
        }
        return true;
    }

    @Override
    Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected Callable<Boolean> createInitHandlerInternal(FileObject fileObject) {
        LOGGER.log(Level.FINE, "Creating INIT handler for {0} (project {1})", new Object[]{LocalOperationFactory.getPath(fileObject), this.project.getName()});
        return this.createCopyFolderHandler(fileObject);
    }

    @Override
    protected Callable<Boolean> createCopyHandlerInternal(FileObject fileObject) {
        LOGGER.log(Level.FINE, "Creating COPY handler for {0} (project {1})", new Object[]{LocalOperationFactory.getPath(fileObject), this.project.getName()});
        return fileObject.isFolder() ? this.createCopyFolderHandler(fileObject) : this.createCopyFileHandler(fileObject);
    }

    private Callable<Boolean> createCopyFolderHandler(final FileObject fileObject) {
        assert (fileObject.isFolder());
        LOGGER.log(Level.FINE, "Creating COPY FOLDER handler for {0} (project {1})", new Object[]{LocalOperationFactory.getPath(fileObject), this.project.getName()});
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                LOGGER.log(Level.FINE, "Running COPY FOLDER handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(fileObject), LocalOperationFactory.this.project.getName()});
                File file = LocalOperationFactory.this.getTarget(fileObject);
                if (file == null) {
                    LOGGER.log(Level.FINE, "Ignored for {0} (no target)", FileOperationFactory.getPath(fileObject));
                    return null;
                }
                if (!file.exists()) {
                    FileUtil.createFolder((File)file);
                    if (!file.isDirectory()) {
                        LOGGER.log(Level.FINE, "Failed for {0}, cannot create directory {1}", new Object[]{FileOperationFactory.getPath(fileObject), file});
                        return false;
                    }
                    LOGGER.log(Level.FINE, "Directory {0} created", file);
                }
                Boolean bl = null;
                String[] stringArray = file.list();
                if (stringArray != null && file.list().length == 0) {
                    Enumeration enumeration = fileObject.getChildren(true);
                    while (enumeration.hasMoreElements()) {
                        FileObject fileObject2 = (FileObject)enumeration.nextElement();
                        if (!LocalOperationFactory.this.isSourceFileValid(fileObject2)) {
                            LOGGER.log(Level.FINE, "Ignored for {0} (not valid)", FileOperationFactory.getPath(fileObject2));
                            continue;
                        }
                        file = LocalOperationFactory.this.getTarget(fileObject2, false);
                        if (file == null) {
                            LOGGER.log(Level.FINE, "Ignored for {0} (no target)", FileOperationFactory.getPath(fileObject2));
                            continue;
                        }
                        if (!LocalOperationFactory.this.doCopy(fileObject2, file)) {
                            return false;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
        };
    }

    private Callable<Boolean> createCopyFileHandler(final FileObject fileObject) {
        assert (fileObject.isData());
        LOGGER.log(Level.FINE, "Creating COPY FILE handler for {0} (project {1})", new Object[]{LocalOperationFactory.getPath(fileObject), this.project.getName()});
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                LOGGER.log(Level.FINE, "Running COPY FILE handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(fileObject), LocalOperationFactory.this.project.getName()});
                File file = LocalOperationFactory.this.getTarget(fileObject);
                if (file == null) {
                    LOGGER.log(Level.FINE, "Ignored for {0} (no target)", FileOperationFactory.getPath(fileObject));
                    return null;
                }
                return LocalOperationFactory.this.doCopy(fileObject, file);
            }
        };
    }

    @Override
    protected Callable<Boolean> createRenameHandlerInternal(final FileObject fileObject, final String string) {
        LOGGER.log(Level.FINE, "Creating RENAME handler for {0} (project {1})", new Object[]{LocalOperationFactory.getPath(fileObject), this.project.getName()});
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Object object;
                Object object2;
                LOGGER.log(Level.FINE, "Running RENAME handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(fileObject), LocalOperationFactory.this.project.getName()});
                File file = LocalOperationFactory.this.getTarget(fileObject);
                if (file == null) {
                    LOGGER.log(Level.FINE, "Ignored for {0} (no target)", FileOperationFactory.getPath(fileObject));
                    return null;
                }
                if (fileObject.isFolder()) {
                    object2 = fileObject.getChildren(true);
                    while (object2.hasMoreElements()) {
                        object = (FileObject)object2.nextElement();
                        if (!LocalOperationFactory.this.isSourceFileValid((FileObject)object)) {
                            LOGGER.log(Level.FINE, "Ignored for {0} (not valid)", FileOperationFactory.getPath(object));
                            continue;
                        }
                        File file2 = LocalOperationFactory.this.getTarget(object, false);
                        if (file2 == null || LocalOperationFactory.this.doCopy(object, file2)) continue;
                        return false;
                    }
                } else if (!LocalOperationFactory.this.doCopy(fileObject, file)) {
                    return false;
                }
                if ((object2 = file.getParentFile()) != null) {
                    object = new File((File)object2, string);
                    return LocalOperationFactory.this.doDelete((File)object);
                }
                return true;
            }
        };
    }

    @Override
    protected Callable<Boolean> createDeleteHandlerInternal(final FileObject fileObject) {
        LOGGER.log(Level.FINE, "Creating DELETE handler for {0} (project {1})", new Object[]{LocalOperationFactory.getPath(fileObject), this.project.getName()});
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                LOGGER.log(Level.FINE, "Running DELETE handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(fileObject), LocalOperationFactory.this.project.getName()});
                File file = LocalOperationFactory.this.getTarget(fileObject);
                if (file == null) {
                    LOGGER.log(Level.FINE, "Ignored for {0} (no target)", FileOperationFactory.getPath(fileObject));
                    return null;
                }
                return LocalOperationFactory.this.doDelete(file);
            }
        };
    }

    private File getTargetRoot() {
        return ProjectPropertiesSupport.getCopySourcesTarget(this.project);
    }

    private Pair<FileObject, File> getConfigPair() {
        return Pair.of((Object)this.getSources(), (Object)this.getTargetRoot());
    }

    private File getTarget(FileObject fileObject) {
        return this.getTarget(fileObject, true);
    }

    private File getTarget(FileObject fileObject, boolean bl) {
        LOGGER.log(Level.FINE, "Getting target for {0} (project {1}, deep check: {2})", new Object[]{LocalOperationFactory.getPath(fileObject), this.project.getName(), bl});
        Pair<FileObject, File> pair = this.getConfigPair();
        if (bl) {
            if (!this.isEnabledAndValidConfig()) {
                LOGGER.fine("\t-> null (invalid config)");
                return null;
            }
            if (!LocalOperationFactory.isPairValid(pair)) {
                LOGGER.fine("\t-> null (invalid config pair)");
                return null;
            }
        }
        if (!this.isSourceFileValid(fileObject)) {
            LOGGER.fine("\t-> null (invalid source)");
            return null;
        }
        FileObject fileObject2 = (FileObject)pair.first;
        File file = (File)pair.second;
        assert (fileObject2 != null);
        assert (file != null);
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        assert (string != null) : String.format("Relative path be found because isSourceFileValid() was already called for %s", LocalOperationFactory.getPath(fileObject));
        LOGGER.fine("\t-> found");
        return FileUtil.normalizeFile((File)new File(file, string));
    }

    private boolean doCopy(FileObject fileObject, File file) throws IOException {
        LOGGER.log(Level.FINE, "Copying file {0} -> {1}", new Object[]{LocalOperationFactory.getPath(fileObject), file});
        File file2 = file.getParentFile();
        if (fileObject.isData()) {
            this.doDelete(file);
            FileObject fileObject2 = FileUtil.createFolder((File)file2);
            FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)fileObject.getName(), (String)fileObject.getExt());
            LOGGER.log(Level.FINE, "File {0} copied to {1}", new Object[]{LocalOperationFactory.getPath(fileObject), file});
        } else {
            String[] stringArray = file.list();
            if (stringArray == null || stringArray.length == 0) {
                this.doDelete(file);
            }
            FileUtil.createFolder((File)file);
            LOGGER.log(Level.FINE, "Folder {0} created", file);
        }
        return file.exists();
    }

    private boolean doDelete(File file) throws IOException {
        LOGGER.log(Level.FINE, "Deleting file {0}", file);
        if (!file.exists()) {
            LOGGER.log(Level.FINE, "File {0} does not exists, nothing to delete", file);
            return true;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        assert (fileObject != null) : "FileObject must be found for " + file;
        if (!fileObject.isValid()) {
            LOGGER.log(Level.FINE, "FileObject {0} is not valid, nothing to delete", LocalOperationFactory.getPath(fileObject));
        } else {
            fileObject.delete();
            LOGGER.log(Level.FINE, "File {0} deleted", LocalOperationFactory.getPath(fileObject));
        }
        return !file.exists();
    }

    private static boolean isPairValid(Pair<FileObject, File> pair) {
        return pair != null && pair.first != null && pair.second != null;
    }
}

