/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.copysupport;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.TransferInfo;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.copysupport.FileOperationFactory;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteOperationFactory
extends FileOperationFactory {
    private static final Logger LOGGER = Logger.getLogger(RemoteOperationFactory.class.getName());
    private RemoteClient remoteClient;

    RemoteOperationFactory(PhpProject phpProject) {
        super(phpProject);
    }

    @Override
    protected boolean isEnabled() {
        return this.isEnabled(true);
    }

    private boolean isEnabled(boolean bl) {
        boolean bl2 = this.isRemoteConfigSelected();
        boolean bl3 = false;
        if (bl2) {
            bl3 = this.isUploadOnSave();
        }
        if (bl) {
            LOGGER.log(Level.FINE, "REMOTE copying enabled for project {0}: {1}", new Object[]{this.project.getName(), bl2 && bl3});
            if (!bl2) {
                LOGGER.fine("\t-> remote config not selected");
            }
            if (!bl3) {
                LOGGER.fine("\t-> upload on save not selected");
            }
        }
        return bl2 && bl3;
    }

    @Override
    protected synchronized void resetInternal() {
        this.remoteClient = null;
    }

    @Override
    Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected Callable<Boolean> createInitHandlerInternal(FileObject fileObject) {
        LOGGER.log(Level.FINE, "No INIT handler needed for project {0}", this.project.getName());
        return null;
    }

    @Override
    protected Callable<Boolean> createCopyHandlerInternal(final FileObject fileObject) {
        LOGGER.log(Level.FINE, "Creating COPY handler for {0} (project {1})", new Object[]{RemoteOperationFactory.getPath(fileObject), this.project.getName()});
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                Boolean bl;
                LOGGER.log(Level.FINE, "Running COPY handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(fileObject), RemoteOperationFactory.this.project.getName()});
                if (!RemoteOperationFactory.this.isValid(fileObject)) {
                    return null;
                }
                RemoteClient remoteClient = RemoteOperationFactory.this.getRemoteClient();
                try {
                    bl = RemoteOperationFactory.this.doCopy(remoteClient, fileObject);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    remoteClient.disconnect();
                    throw throwable;
                }
                remoteClient.disconnect();
                return bl;
            }
        };
    }

    @Override
    protected Callable<Boolean> createRenameHandlerInternal(final FileObject fileObject, final String string) {
        LOGGER.log(Level.FINE, "Creating RENAME handler for {0} (project {1})", new Object[]{RemoteOperationFactory.getPath(fileObject), this.project.getName()});
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                Boolean bl;
                LOGGER.log(Level.FINE, "Running RENAME handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(fileObject), RemoteOperationFactory.this.project.getName()});
                if (!RemoteOperationFactory.this.isValid(fileObject)) {
                    return null;
                }
                RemoteClient remoteClient = RemoteOperationFactory.this.getRemoteClient();
                try {
                    bl = RemoteOperationFactory.this.doRename(remoteClient, fileObject, string);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    remoteClient.disconnect();
                    throw throwable;
                }
                remoteClient.disconnect();
                return bl;
            }
        };
    }

    @Override
    protected Callable<Boolean> createDeleteHandlerInternal(final FileObject fileObject) {
        LOGGER.log(Level.FINE, "Creating DELETE handler for {0} (project {1})", new Object[]{RemoteOperationFactory.getPath(fileObject), this.project.getName()});
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                Boolean bl;
                LOGGER.log(Level.FINE, "Running DELETE handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(fileObject), RemoteOperationFactory.this.project.getName()});
                if (!RemoteOperationFactory.this.isValid(fileObject)) {
                    return null;
                }
                RemoteClient remoteClient = RemoteOperationFactory.this.getRemoteClient();
                try {
                    bl = RemoteOperationFactory.this.doDelete(remoteClient, fileObject);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    remoteClient.disconnect();
                    throw throwable;
                }
                remoteClient.disconnect();
                return bl;
            }
        };
    }

    private boolean isValid(FileObject fileObject) {
        LOGGER.log(Level.FINE, "Validating source {0} for {1}", new Object[]{RemoteOperationFactory.getPath(fileObject), this.project.getName()});
        if (!this.isRemoteConfigValid()) {
            LOGGER.fine("\t-> invalid (invalid config)");
            return false;
        }
        if (!this.isSourceFileValid(fileObject)) {
            LOGGER.fine("\t-> invalid (invalid source)");
            return false;
        }
        return true;
    }

    protected boolean isRemoteConfigValid() {
        if (!this.isEnabled(false)) {
            LOGGER.log(Level.FINE, "REMOTE copying not enabled for project {0}", this.project.getName());
            return false;
        }
        if (this.isInvalid()) {
            LOGGER.log(Level.FINE, "REMOTE copying invalid for project {0}", this.project.getName());
            return false;
        }
        if (this.getSources() == null) {
            LOGGER.log(Level.WARNING, "REMOTE copying disabled for project {0}. Reason: source root is null", this.project.getName());
            return false;
        }
        if (this.getRemoteConfiguration() == null) {
            LOGGER.log(Level.INFO, "REMOTE copying disabled for project {0}. Reason: remote config not found", this.project.getName());
            if (this.askUser(NbBundle.getMessage(RemoteOperationFactory.class, (String)"MSG_RemoteConfigNotFound", (Object)this.project.getName()))) {
                this.showCustomizer();
            }
            this.invalidate();
            return false;
        }
        return true;
    }

    protected synchronized RemoteClient getRemoteClient() {
        if (this.remoteClient == null) {
            this.remoteClient = new RemoteClient(this.getRemoteConfiguration(), new RemoteClient.AdvancedProperties().setAdditionalInitialSubdirectory(ProjectPropertiesSupport.getRemoteDirectory(this.project)).setPreservePermissions(ProjectPropertiesSupport.areRemotePermissionsPreserved(this.project)).setUploadDirectly(ProjectPropertiesSupport.isRemoteUploadDirectly(this.project)).setPhpVisibilityQuery(PhpVisibilityQuery.forProject(this.project)));
        }
        return this.remoteClient;
    }

    protected boolean isUploadOnSave() {
        return PhpProjectProperties.UploadFiles.ON_SAVE.equals((Object)ProjectPropertiesSupport.getRemoteUpload(this.project));
    }

    protected boolean isRemoteConfigSelected() {
        return PhpProjectProperties.RunAsType.REMOTE.equals((Object)ProjectPropertiesSupport.getRunAs(this.project));
    }

    protected RemoteConfiguration getRemoteConfiguration() {
        String string = ProjectPropertiesSupport.getRemoteConnection(this.project);
        assert (StringUtils.hasText((String)string)) : "Remote configuration name must be selected for project " + this.project.getName();
        return RemoteConnections.get().remoteConfigurationForName(string);
    }

    Boolean doCopy(RemoteClient remoteClient, FileObject fileObject) throws RemoteException {
        LOGGER.log(Level.FINE, "Uploading file {0} for project {1}", new Object[]{RemoteOperationFactory.getPath(fileObject), this.project.getName()});
        FileObject fileObject2 = this.getSources();
        Set<TransferFile> set = remoteClient.prepareUpload(fileObject2, fileObject);
        if (set.size() > 0) {
            TransferInfo transferInfo = remoteClient.upload(fileObject2, set);
            if (!(transferInfo.hasAnyFailed() || transferInfo.hasAnyPartiallyFailed() || transferInfo.hasAnyIgnored())) {
                LOGGER.fine("\t-> success");
                return true;
            }
            LOGGER.fine("\t-> failure");
            LOGGER.log(Level.INFO, "Upload failed: {0}", transferInfo);
            return false;
        }
        LOGGER.fine("\t-> nothing to upload?!");
        return null;
    }

    Boolean doRename(RemoteClient remoteClient, FileObject fileObject, String string) throws RemoteException {
        FileObject fileObject2 = this.getSources();
        String string2 = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
        File file = FileUtil.toFile((FileObject)fileObject);
        TransferFile transferFile = TransferFile.fromFileObject(fileObject, string2);
        TransferFile transferFile2 = TransferFile.fromFile(new File(file.getParentFile(), string), string2);
        LOGGER.log(Level.FINE, "Renaming file {0} -> {1} for project {2}", new Object[]{transferFile2.getRelativePath(), transferFile.getRelativePath(), this.project.getName()});
        if (remoteClient.exists(transferFile2)) {
            if (remoteClient.rename(transferFile2, transferFile)) {
                LOGGER.fine("\t-> success");
                return true;
            }
            LOGGER.fine("\t-> failure");
            return false;
        }
        LOGGER.fine("\t-> does not exist -> uploading");
        return this.doCopy(remoteClient, fileObject);
    }

    Boolean doDelete(RemoteClient remoteClient, FileObject fileObject) throws RemoteException {
        LOGGER.log(Level.FINE, "Deleting file {0} for project {1}", new Object[]{RemoteOperationFactory.getPath(fileObject), this.project.getName()});
        Boolean bl = null;
        Set<TransferFile> set = remoteClient.prepareDelete(this.getSources(), fileObject);
        for (TransferFile transferFile : set) {
            LOGGER.log(Level.FINE, "Deleting remote file {0}", transferFile.getRelativePath());
            if (!remoteClient.exists(transferFile)) {
                LOGGER.fine("\t-> does not exist -> ignoring");
                continue;
            }
            TransferInfo transferInfo = remoteClient.delete(transferFile);
            if (transferInfo.hasAnyTransfered()) {
                LOGGER.fine("\t-> success");
                continue;
            }
            LOGGER.fine("\t-> failure");
            LOGGER.log(Level.INFO, "Remote delete failed: {0}", transferInfo);
            bl = false;
        }
        return bl;
    }
}

