/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpFrameworks;
import org.netbeans.modules.php.project.ui.wizards.PhpFrameworksPanelVisual;
import org.netbeans.modules.php.spi.phpmodule.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleExtender;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpFrameworksPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor>,
ChangeListener {
    static final String VALID = "PhpFrameworksPanel.valid";
    static final String EXTENDERS = "frameworks";
    private final String[] steps;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private PhpFrameworksPanelVisual frameworksPanel = null;
    private WizardDescriptor descriptor = null;

    public PhpFrameworksPanel(String[] stringArray) {
        this.steps = stringArray;
    }

    String[] getSteps() {
        return this.steps;
    }

    public Component getComponent() {
        if (this.frameworksPanel == null) {
            this.frameworksPanel = new PhpFrameworksPanelVisual(this, this.createExtenders());
        }
        return this.frameworksPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(PhpFrameworksPanel.class);
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.getComponent();
        this.descriptor = wizardDescriptor;
        this.frameworksPanel.addPhpFrameworksListener(this);
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        this.getComponent();
        this.frameworksPanel.removePhpFrameworksListener(this);
        this.descriptor.putProperty(EXTENDERS, this.frameworksPanel.getSelectedExtenders());
    }

    public boolean isValid() {
        this.getComponent();
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        String string = null;
        String string2 = null;
        PhpModuleExtender phpModuleExtender = this.frameworksPanel.getSelectedVisibleExtender();
        if (phpModuleExtender != null) {
            if (!phpModuleExtender.isValid()) {
                string = phpModuleExtender.getErrorMessage();
            }
            string2 = phpModuleExtender.getWarningMessage();
        }
        HashSet<PhpFrameworkProvider> hashSet = new HashSet<PhpFrameworkProvider>();
        for (Map.Entry<PhpFrameworkProvider, PhpModuleExtender> entry : this.frameworksPanel.getSelectedExtenders().entrySet()) {
            PhpModuleExtender phpModuleExtender2 = entry.getValue();
            if (phpModuleExtender2 == null || phpModuleExtender2.isValid()) continue;
            PhpFrameworkProvider phpFrameworkProvider = entry.getKey();
            if (string == null) {
                string = NbBundle.getMessage(PhpFrameworksPanel.class, (String)"MSG_InvalidFramework", (Object)phpFrameworkProvider.getName());
            }
            hashSet.add(phpFrameworkProvider);
        }
        this.frameworksPanel.markInvalidFrameworks(hashSet);
        if (string != null) {
            this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            this.descriptor.putProperty(VALID, (Object)false);
            return false;
        }
        if (string2 != null) {
            this.descriptor.putProperty("WizardPanel_warningMessage", (Object)string2);
        }
        this.descriptor.putProperty(VALID, (Object)true);
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public boolean isFinishPanel() {
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }

    final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    private Map<PhpFrameworkProvider, PhpModuleExtender> createExtenders() {
        LinkedHashMap<PhpFrameworkProvider, PhpModuleExtender> linkedHashMap = new LinkedHashMap<PhpFrameworkProvider, PhpModuleExtender>();
        for (PhpFrameworkProvider phpFrameworkProvider : PhpFrameworks.getFrameworks()) {
            linkedHashMap.put(phpFrameworkProvider, phpFrameworkProvider.createPhpModuleExtender(null));
        }
        return linkedHashMap;
    }
}

