/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhpProjectUtils {
    private static final Logger LOGGER = Logger.getLogger(PhpProjectUtils.class.getName());
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.php");

    private PhpProjectUtils() {
    }

    public static PhpProject getPhpProject(Node node) {
        return PhpProjectUtils.getPhpProject(CommandUtils.getFileObject(node));
    }

    public static PhpProject getPhpProject(FileObject fileObject) {
        assert (fileObject != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        return (PhpProject)project.getLookup().lookup(PhpProject.class);
    }

    public static void openFile(String string, int n) {
        DataObject dataObject;
        assert (string != null);
        FileObject fileObject = FileUtil.toFileObject((File)new File(string));
        if (fileObject == null) {
            LOGGER.info("FileObject not found for " + string);
            return;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            LOGGER.info("DataObject not found for " + string);
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            LOGGER.info("LineCookie not found for " + string);
            return;
        }
        Line.Set set = lineCookie.getLineSet();
        try {
            final Line line = set.getCurrent(n - 1);
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                }
            });
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            LOGGER.log(Level.FINE, null, indexOutOfBoundsException);
        }
    }

    public static SourceGroup[] getSourceGroups(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        return sources.getSourceGroups("PHPSOURCE");
    }

    public static FileObject[] getSourceObjects(Project project) {
        SourceGroup[] sourceGroupArray = PhpProjectUtils.getSourceGroups(project);
        FileObject[] fileObjectArray = new FileObject[sourceGroupArray.length];
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            fileObjectArray[i] = sourceGroupArray[i].getRootFolder();
        }
        return fileObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reformatFile(final File file) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        assert (fileObject != null) : "No fileobject for " + file;
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        assert (editorCookie != null) : "No editorcookie for " + fileObject;
        StyledDocument styledDocument = editorCookie.openDocument();
        assert (styledDocument instanceof BaseDocument);
        final BaseDocument baseDocument = (BaseDocument)styledDocument;
        final Reformat reformat = Reformat.get((Document)baseDocument);
        reformat.lock();
        try {
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        reformat.reformat(0, baseDocument.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        LOGGER.log(Level.INFO, "Cannot reformat file " + file, badLocationException);
                    }
                }
            });
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            reformat.unlock();
            throw throwable;
        }
        reformat.unlock();
        SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
        if (saveCookie != null) {
            saveCookie.save();
        }
    }

    public static boolean isVisible(PhpVisibilityQuery phpVisibilityQuery, FileObject fileObject) {
        assert (phpVisibilityQuery != null);
        assert (fileObject != null);
        for (FileObject fileObject2 = fileObject; fileObject2 != null; fileObject2 = fileObject2.getParent()) {
            if (phpVisibilityQuery.isVisible(fileObject2)) continue;
            return false;
        }
        return true;
    }

    public static void logUsage(Class<?> clazz, String string, List<? extends Object> list) {
        assert (string != null);
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle(clazz));
        logRecord.setResourceBundleName(clazz.getPackage().getName() + ".Bundle");
        if (list != null) {
            logRecord.setParameters(list.toArray(new Object[list.size()]));
        }
        USG_LOGGER.log(logRecord);
    }
}

