/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;
import junit.framework.Test;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.DialogWaiter;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.util.Dumper;
import org.netbeans.jemmy.util.PNGEncoder;
import org.netbeans.junit.AssertionFailedErrorException;
import org.netbeans.junit.NbModuleSuite;
import org.netbeans.junit.NbTestCase;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JellyTestCase
extends NbTestCase {
    public boolean captureScreen = Boolean.valueOf(System.getProperty("jemmy.screen.capture", "true"));
    public boolean dumpScreen = Boolean.getBoolean("jemmy.screen.xmldump");
    public boolean closeAllModal = Boolean.valueOf(System.getProperty("jelly.close.modal", "true"));
    public boolean waitNoEvent = Boolean.valueOf(System.getProperty("jelly.wait.no.event", "true"));
    private boolean isScreenCaptured = false;
    private boolean testStatus = true;
    private Vector openedProjects = null;
    private static final DistributingHierarchyListener distributingHierarchyListener = new DistributingHierarchyListener();

    public JellyTestCase(String string) {
        super(string);
    }

    protected void initEnvironment() {
        PrintStream printStream = this.getLog("jemmy.log");
        JemmyProperties.setCurrentOutput((TestOut)new TestOut(System.in, printStream, printStream));
        String string = System.getProperty("jelly.timeouts_resource");
        String string2 = System.getProperty("jelly.timeouts_file");
        try {
            JemmyProperties.getCurrentTimeouts().load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/netbeans/jellytools/timeouts"));
            if (string != null && !"".equals(string)) {
                JemmyProperties.getCurrentTimeouts().load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string));
            } else if (string2 != null && !"".equals(string2)) {
                JemmyProperties.getCurrentTimeouts().load(string2);
            }
        }
        catch (Exception exception) {
            throw new JemmyException("Initialization of timeouts failed.", (Throwable)exception);
        }
    }

    public void runBare() throws Throwable {
        this.initEnvironment();
        Toolkit.getDefaultToolkit().addAWTEventListener(distributingHierarchyListener, 32768L);
        if (this.waitNoEvent) {
            new EventTool().waitNoEvent(1000L);
        }
        try {
            super.runBare();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            try {
                this.failNotify(throwable);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.captureScreen();
            if (this.closeAllModal) {
                try {
                    JellyTestCase.closeAllModal();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (throwable instanceof JemmyException) {
                throw new AssertionFailedErrorException(throwable.getMessage(), throwable);
            }
            throw throwable;
        }
        finally {
            Toolkit.getDefaultToolkit().removeAWTEventListener(distributingHierarchyListener);
        }
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.captureScreen();
            throw throwable;
        }
    }

    private void captureScreen() {
        if (!this.isScreenCaptured) {
            Object object;
            if (this.captureScreen) {
                try {
                    object = this.getWorkDir().getAbsolutePath() + File.separator + "screen.png";
                    PNGEncoder.captureScreen((String)object, (byte)2);
                    this.noteCaptureFile((String)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace(this.getLog());
                }
            }
            object = this.getLog();
            ((PrintStream)object).println("thread dump just after screen capture:");
            ((PrintStream)object).println(JellyTestCase.threadDump());
            if (this.dumpScreen) {
                try {
                    String string = this.getWorkDir().getAbsolutePath() + File.separator + "screen.xml";
                    Dumper.dumpAll((String)string);
                    this.noteCaptureFile(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace(this.getLog());
                }
            }
            this.isScreenCaptured = true;
        }
    }

    private void noteCaptureFile(String string) {
        String string2 = System.getenv("HUDSON_URL");
        if (string2 == null) {
            return;
        }
        String string3 = System.getenv("WORKSPACE");
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        if (!string.startsWith(string3)) {
            return;
        }
        String string4 = string.substring(string3.length()).replace(File.separatorChar, '/');
        System.err.println("Capturing to:");
        System.err.println(string2 + "job/" + System.getenv("JOB_NAME") + "/" + System.getenv("BUILD_NUMBER") + "/artifact/" + string4);
    }

    protected void failNotify(Throwable throwable) {
    }

    public static void closeAllModal() {
        JDialog jDialog;
        ComponentChooser componentChooser = new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component instanceof JDialog && component.isShowing() && ((JDialog)component).isModal();
            }

            public String getDescription() {
                return "Modal dialog";
            }
        };
        while ((jDialog = (JDialog)DialogWaiter.getDialog((ComponentChooser)componentChooser)) != null) {
            JellyTestCase.closeDialogs(JellyTestCase.findBottomDialog(jDialog, componentChooser), componentChooser);
        }
    }

    private static JDialog findBottomDialog(JDialog jDialog, ComponentChooser componentChooser) {
        Window window = jDialog.getOwner();
        if (componentChooser.checkComponent((Component)window)) {
            return JellyTestCase.findBottomDialog((JDialog)window, componentChooser);
        }
        return jDialog;
    }

    private static void closeDialogs(JDialog jDialog, ComponentChooser componentChooser) {
        Window[] windowArray = jDialog.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (!componentChooser.checkComponent((Component)windowArray[i])) continue;
            JellyTestCase.closeDialogs((JDialog)windowArray[i], componentChooser);
        }
        new JDialogOperator(jDialog).close();
    }

    public void fail(Throwable throwable) {
        throwable.printStackTrace(this.getLog());
        throw new AssertionFailedErrorException(throwable);
    }

    protected void startTest() {
        if (!this.testStatus) {
            JellyTestCase.fail((String)"Depending on previous test, but it failed");
        }
        this.testStatus = false;
    }

    protected void endTest() {
        this.testStatus = true;
    }

    protected void clearTestStatus() {
        this.testStatus = true;
    }

    public void waitScanFinished() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            Class<?> clazz = Class.forName("org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater", true, classLoader);
            final Object object = clazz.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
            final Method method = clazz.getMethod("isScanInProgress", new Class[0]);
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object2) {
                    Boolean bl;
                    try {
                        bl = (Boolean)method.invoke(object, new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new JemmyException("Error during waiting for the end of scanning: ", (Throwable)exception);
                    }
                    return bl != false ? null : Boolean.TRUE;
                }

                public String getDescription() {
                    return "Waiting for scanning to finish.";
                }
            });
            Timeouts timeouts = waiter.getTimeouts();
            timeouts.setTimeout("Waiter.WaitingTime", 600000L);
            waiter.waitAction(null);
        }
        catch (Exception exception) {
            throw new JemmyException("Waiting for end of scanning failed.", (Throwable)exception);
        }
    }

    public void openProjects(String ... stringArray) throws IOException {
        try {
            int method5;
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.netbeans.api.project.ui.OpenProjects");
            Class<?> clazz2 = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.netbeans.api.project.ProjectManager");
            Method method = clazz.getMethod("getDefault", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("getOpenProjects", new Class[0]);
            if (this.openedProjects == null) {
                this.openedProjects = new Vector();
            }
            Vector<Object> vector = new Vector<Object>();
            String[] object5 = stringArray;
            int object6 = object5.length;
            for (method5 = 0; method5 < object6; ++method5) {
                String string = object5[method5];
                Method method3 = clazz2.getMethod("getDefault", new Class[0]);
                Object object2 = method3.invoke(null, new Object[0]);
                Method method4 = clazz2.getMethod("findProject", FileObject.class);
                Object object3 = method4.invoke(object2, FileUtil.toFileObject((File)new File(string)));
                Object object4 = method2.invoke(object, new Object[0]);
                boolean bl = false;
                for (int i = 0; i < Array.getLength(object4); ++i) {
                    if (!object3.equals(Array.get(object4, i))) continue;
                    bl = true;
                }
                if (bl) continue;
                vector.add(object3);
            }
            Class<?> clazz3 = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.netbeans.api.project.Project");
            Object object7 = Array.newInstance(clazz3, vector.size());
            for (method5 = 0; method5 < vector.size(); ++method5) {
                Array.set(object7, method5, vector.get(method5));
            }
            Method method6 = clazz.getMethod("open", object7.getClass(), Boolean.TYPE);
            method6.invoke(object, object7, false);
            this.openedProjects.addAll(vector);
            this.waitScanFinished();
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
    }

    public void openDataProjects(String ... stringArray) throws IOException {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.getDataDir().getAbsolutePath() + File.separator + stringArray[i];
        }
        this.openProjects(stringArray2);
    }

    public void closeOpenedProjects() {
        this.closeOpenedProjects(this.openedProjects.toArray());
        this.openedProjects.clear();
    }

    public void closeOpenedProjects(Object ... objectArray) {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.netbeans.api.project.ui.OpenProjects");
            Method method = clazz.getMethod("getDefault", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Class<?> clazz2 = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.netbeans.api.project.Project");
            Object object2 = Array.newInstance(clazz2, objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                Array.set(object2, i, objectArray[i]);
            }
            Method method2 = clazz.getMethod("close", object2.getClass());
            method2.invoke(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
    }

    protected static Test createModuleTest(String string, String string2, Class clazz, String ... stringArray) {
        return NbModuleSuite.create((Class)clazz, (String)string2, (String)string, (String[])stringArray);
    }

    protected static Test createModuleTest(Class clazz, String ... stringArray) {
        return JellyTestCase.createModuleTest(".*", ".*", clazz, stringArray);
    }

    private static void appendThread(StringBuffer stringBuffer, String string, Thread thread, Map<Thread, StackTraceElement[]> map) {
        stringBuffer.append(string).append("Thread ").append(thread.getName()).append('\n');
        for (StackTraceElement stackTraceElement : map.get(thread)) {
            stringBuffer.append("\tat ").append(stackTraceElement.getClassName()).append('.').append(stackTraceElement.getMethodName()).append('(').append(stackTraceElement.getFileName()).append(':').append(stackTraceElement.getLineNumber()).append(")\n");
        }
    }

    private static void appendGroup(StringBuffer stringBuffer, String string, ThreadGroup threadGroup, Map<Thread, StackTraceElement[]> map) {
        stringBuffer.append(string).append("Group ").append(threadGroup.getName()).append('\n');
        string = string.concat("  ");
        int n = threadGroup.activeGroupCount();
        ThreadGroup[] threadGroupArray = new ThreadGroup[n];
        threadGroup.enumerate(threadGroupArray, false);
        for (ThreadGroup threadGroup2 : threadGroupArray) {
            if (threadGroup2 == null) continue;
            JellyTestCase.appendGroup(stringBuffer, string, threadGroup2, map);
        }
        int n2 = threadGroup.activeCount();
        Thread[] threadArray = new Thread[n2];
        threadGroup.enumerate(threadArray, false);
        for (Thread thread : threadArray) {
            if (thread == null) continue;
            JellyTestCase.appendThread(stringBuffer, string, thread, map);
        }
    }

    private static String threadDump() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        StringBuffer stringBuffer = new StringBuffer();
        JellyTestCase.appendGroup(stringBuffer, "", threadGroup, map);
        return stringBuffer.toString();
    }

    private static class DistributingHierarchyListener
    implements AWTEventListener {
        public void eventDispatched(AWTEvent aWTEvent) {
            HierarchyEvent hierarchyEvent = null;
            if (aWTEvent instanceof HierarchyEvent) {
                hierarchyEvent = (HierarchyEvent)aWTEvent;
            }
            if (hierarchyEvent != null && (4L & hierarchyEvent.getChangeFlags()) != 0L) {
                DistributingHierarchyListener.distributeShowingEvent(hierarchyEvent.getComponent(), hierarchyEvent);
            }
        }

        private static void distributeShowingEvent(Component component, HierarchyEvent hierarchyEvent) {
            HierarchyListener[] hierarchyListenerArray = (HierarchyListener[])component.getListeners(HierarchyListener.class);
            if (hierarchyListenerArray != null) {
                for (int i = 0; i < hierarchyListenerArray.length; ++i) {
                    hierarchyListenerArray[i].hierarchyChanged(hierarchyEvent);
                }
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    DistributingHierarchyListener.distributeShowingEvent(container.getComponent(i), hierarchyEvent);
                }
            }
        }
    }
}

