/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.RepositoryComboSupport;
import org.netbeans.modules.bugtracking.vcs.FormatPanel;
import org.netbeans.modules.bugtracking.vcs.HookPanel;
import org.netbeans.modules.bugtracking.vcs.HookUtils;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.netbeans.modules.subversion.hooks.spi.SvnHook;
import org.netbeans.modules.subversion.hooks.spi.SvnHookContext;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnHookImpl
extends SvnHook {
    private static final String[] SUPPORT_ISSUE_INFO_VARIABLES = new String[]{"id", "summary"};
    private static final String[] SUPPORT_REVISION_VARIABLES = new String[]{"revision", "author", "date", "message"};
    private HookPanel panel;
    private final String name = NbBundle.getMessage(SvnHookImpl.class, (String)"LBL_VCSHook");
    private static Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.vcshooks.SvnHook");
    private static final SimpleDateFormat CC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public SvnHookContext beforeCommit(SvnHookContext svnHookContext) throws IOException {
        Repository repository = this.getSelectedRepository();
        if (svnHookContext.getFiles().length == 0) {
            if (repository != null) {
                BugtrackingOwnerSupport.getInstance().setLooseAssociation(BugtrackingOwnerSupport.ContextType.MAIN_OR_SINGLE_PROJECT, repository);
            }
            LOG.warning("calling svn beforeCommit for zero files");
            return null;
        }
        if (repository != null) {
            BugtrackingOwnerSupport.getInstance().setFirmAssociations(svnHookContext.getFiles(), repository);
        }
        File file = svnHookContext.getFiles()[0];
        LOG.log(Level.FINE, "svn beforeCommit start for " + file);
        String string = svnHookContext.getMessage();
        ArrayList arrayList = null;
        if (this.isLinkSelected()) {
            VCSHooksConfig.Format format = VCSHooksConfig.getInstance().getSvnIssueInfoTemplate();
            String string2 = format.getFormat();
            string2 = HookUtils.prepareFormatString(string2, SUPPORT_ISSUE_INFO_VARIABLES);
            Issue issue = this.getIssue();
            if (issue == null) {
                LOG.log(Level.FINE, " no issue set for " + file);
                return null;
            }
            String string3 = new MessageFormat(string2).format(new Object[]{issue.getID(), issue.getSummary()}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " svn commit hook issue info '" + string3 + "'");
            string = format.isAbove() ? string3 + "\n" + string : string + "\n" + string3;
            arrayList = new ArrayList();
        }
        return new SvnHookContext(svnHookContext.getFiles(), string, arrayList);
    }

    public void afterCommit(SvnHookContext svnHookContext) {
        VCSHooksConfig.getInstance().setSvnResolve(this.isResolveSelected());
        VCSHooksConfig.getInstance().setSvnLink(this.isLinkSelected());
        if (svnHookContext.getFiles().length == 0) {
            LOG.warning("calling svn afterCommit for zero files");
            return;
        }
        File file = svnHookContext.getFiles()[0];
        LOG.log(Level.FINE, "svn afterCommit start for " + file);
        if (!this.isLinkSelected() && !this.isResolveSelected()) {
            LOG.log(Level.FINER, " nothing to do in svn afterCommit for " + file);
            return;
        }
        Issue issue = this.getIssue();
        if (issue == null) {
            LOG.log(Level.FINE, " no issue set for " + file);
            return;
        }
        String string = null;
        if (this.isLinkSelected()) {
            List list = svnHookContext.getLogEntries();
            assert (list.size() > 0);
            SvnHookContext.LogEntry logEntry = (SvnHookContext.LogEntry)list.get(0);
            String string2 = logEntry.getAuthor();
            String string3 = this.getRevisions(list);
            Date date = logEntry.getDate();
            String string4 = logEntry.getMessage();
            String string5 = VCSHooksConfig.getInstance().getSvnRevisionTemplate().getFormat();
            string5 = HookUtils.prepareFormatString(string5, SUPPORT_REVISION_VARIABLES);
            string = new MessageFormat(string5).format(new Object[]{string3, string2, date != null ? CC_DATE_FORMAT.format(date) : "", string4}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " svn commit hook message '" + string + "'");
            issue.addComment(string, this.isResolveSelected());
        }
        issue.open();
        LOG.log(Level.FINE, "svn commit hook end for " + file);
        VCSHooksConfig.logHookUsage("SVN", this.getSelectedRepository());
    }

    public JPanel createComponent(SvnHookContext svnHookContext) {
        File file;
        LOG.finer("SvnHookImpl.createComponent()");
        if (svnHookContext.getFiles().length == 0) {
            file = null;
            LOG.warning("creating svn hook component for zero files");
        } else {
            file = svnHookContext.getFiles()[0];
        }
        this.panel = new HookPanel();
        this.panel.linkCheckBox.setSelected(VCSHooksConfig.getInstance().getSvnLink());
        this.panel.resolveCheckBox.setSelected(VCSHooksConfig.getInstance().getSvnResolve());
        this.panel.commitRadioButton.setSelected(false);
        if (file != null) {
            RepositoryComboSupport.setup((JComponent)((Object)this.panel), (JComboBox)this.panel.repositoryComboBox, (File)file);
        } else {
            RepositoryComboSupport.setup((JComponent)((Object)this.panel), (JComboBox)this.panel.repositoryComboBox, (boolean)false);
        }
        this.panel.commitRadioButton.setVisible(false);
        this.panel.pushRadioButton.setVisible(false);
        this.panel.changeFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SvnHookImpl.this.onShowFormat();
            }
        });
        return this.panel;
    }

    public String getDisplayName() {
        return this.name;
    }

    private String getRevisions(List<SvnHookContext.LogEntry> list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<SvnHookContext.LogEntry> iterator = list.iterator();
        while (iterator.hasNext()) {
            SvnHookContext.LogEntry logEntry = iterator.next();
            stringBuffer.append(logEntry.getRevision());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private void onShowFormat() {
        FormatPanel formatPanel = new FormatPanel(VCSHooksConfig.getInstance().getSvnRevisionTemplate(), VCSHooksConfig.getDefaultSvnRevisionTemplate(), SUPPORT_REVISION_VARIABLES, VCSHooksConfig.getInstance().getSvnIssueInfoTemplate(), VCSHooksConfig.getDefaultIssueInfoTemplate(), SUPPORT_ISSUE_INFO_VARIABLES);
        if (BugtrackingUtil.show((JPanel)formatPanel, (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_FormatTitle"), (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_OK"))) {
            VCSHooksConfig.getInstance().setSvnRevisionTemplate(formatPanel.getIssueFormat());
            VCSHooksConfig.getInstance().setSvnIssueInfoTemplate(formatPanel.getCommitFormat());
        }
    }

    private boolean isLinkSelected() {
        return this.panel != null && this.panel.linkCheckBox.isSelected();
    }

    private boolean isResolveSelected() {
        return this.panel != null && this.panel.resolveCheckBox.isSelected();
    }

    private Repository getSelectedRepository() {
        return this.panel != null ? this.panel.getSelectedRepository() : null;
    }

    private Issue getIssue() {
        return this.panel != null ? this.panel.getIssue() : null;
    }
}

