/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultSettings {
    private static final Logger logger = Logger.getLogger(Util.class.getName());
    private static final String WSSIP = "wssip";
    private static final String XWS_SECURITY_CLIENT = "xws-security-client";
    private static final String XWS_SECURITY_SERVER = "xws-security-server";
    private static final String SERVER_KEYSTORE_BUNDLED = "/org/netbeans/modules/websvc/wsitconf/resources/server-keystore.jks";
    private static final String SERVER_TRUSTSTORE_BUNDLED = "/org/netbeans/modules/websvc/wsitconf/resources/server-truststore.jks";
    private static final String CLIENT_KEYSTORE_BUNDLED = "/org/netbeans/modules/websvc/wsitconf/resources/client-keystore.jks";
    private static final String CLIENT_TRUSTSTORE_BUNDLED = "/org/netbeans/modules/websvc/wsitconf/resources/client-truststore.jks";
    private static final String PASSWORD = "changeit";
    private static final String STORE_FOLDER_NAME = "certs";
    private static final String BUILD_SCRIPT = "/build.xml";
    private static final String BACKUP_EXT = ".bak";
    private static final String IMPORT_WSIT_DEPLOY_XML = "<import file=\"nbproject/wsit-deploy.xml\"/>";
    private static final String IMPORT_TAG = "<import";
    private static final String WSIT_DEPLOY_XML_PATH = "nbproject/wsit-deploy.xml";
    private static final String WSIT_DEPLOY_XSL = "org/netbeans/modules/websvc/wsitconf/resources/wsit-deploy.xsl";

    public static final void fillDefaultsToServer(String string) {
        boolean bl = ServerUtils.isGlassfish(string);
        String string2 = ServerUtils.getStoreLocation(string, false, false);
        String string3 = ServerUtils.getStoreLocation(string, true, false);
        String string4 = ServerUtils.getStoreLocation(string, false, true);
        String string5 = ServerUtils.getStoreLocation(string, true, true);
        if (!bl) {
            FileObject fileObject = ServerUtils.getTomcatLocation(string);
            try {
                Object object;
                Object object22;
                FileObject fileObject2;
                FileObject fileObject3 = FileUtil.createFolder((FileObject)fileObject, (String)STORE_FOLDER_NAME);
                DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)fileObject3);
                FileObject fileObject4 = FileUtil.getConfigFile((String)"Templates/WebServices/client-keystore.jks");
                FileObject fileObject5 = FileUtil.getConfigFile((String)"Templates/WebServices/client-truststore.jks");
                FileObject fileObject6 = FileUtil.getConfigFile((String)"Templates/WebServices/server-keystore.jks");
                FileObject fileObject7 = FileUtil.getConfigFile((String)"Templates/WebServices/server-truststore.jks");
                for (Object object22 : fileObject2 = new FileObject[]{fileObject4, fileObject5, fileObject6, fileObject7}) {
                    if (object22 == null || (object = DataObject.find((FileObject)object22)) == null || fileObject3.getFileObject(object22.getName(), object22.getExt()) != null) continue;
                    object.createFromTemplate(dataFolder, object22.getNameExt());
                }
                FileObject fileObject8 = fileObject.getFileObject("conf/tomcat-users.xml");
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                object22 = documentBuilder.parse(FileUtil.toFile((FileObject)fileObject8));
                object = object22.getElementsByTagName("tomcat-users");
                if (object != null && object.getLength() > 0) {
                    Object object3;
                    Object object4;
                    Object object5;
                    Node node = object.item(0);
                    NodeList nodeList = object22.getElementsByTagName("user");
                    boolean bl2 = false;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        object5 = nodeList.item(i);
                        if (!(object5 instanceof Element) || !"wsitUser".equals(object4 = (object3 = (Element)object5).getAttribute("name"))) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        if (fileObject8.getParent().getFileObject("tomcat-users.backup", "xml") == null) {
                            FileUtil.copyFile((FileObject)fileObject8, (FileObject)fileObject8.getParent(), (String)"tomcat-users.backup");
                        }
                        Element element = object22.createElement("user");
                        element.setAttribute("name", "wsitUser");
                        element.setAttribute("password", PASSWORD);
                        element.setAttribute("roles", "tomcat");
                        node.appendChild(element);
                        object5 = TransformerFactory.newInstance().newTransformer();
                        ((Transformer)object5).setOutputProperty("indent", "yes");
                        object3 = new StreamResult(FileUtil.toFile((FileObject)fileObject8));
                        object4 = new DOMSource((Node)object22);
                        ((Transformer)object5).transform((Source)object4, (Result)object3);
                    }
                }
            }
            catch (Exception exception) {
                logger.log(Level.INFO, null, exception);
            }
            return;
        }
        String string6 = DefaultSettings.getDefaultPassword(string);
        try {
            DefaultSettings.copyKey(SERVER_KEYSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, string2, XWS_SECURITY_SERVER, string6, false);
            DefaultSettings.copyKey(SERVER_KEYSTORE_BUNDLED, WSSIP, PASSWORD, PASSWORD, string2, WSSIP, string6, false);
            DefaultSettings.copyKey(SERVER_TRUSTSTORE_BUNDLED, "certificate-authority", PASSWORD, PASSWORD, string3, "xwss-certificate-authority", string6, true);
            DefaultSettings.copyKey(SERVER_TRUSTSTORE_BUNDLED, XWS_SECURITY_CLIENT, PASSWORD, PASSWORD, string3, XWS_SECURITY_CLIENT, string6, true);
            DefaultSettings.copyKey(SERVER_KEYSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, string3, XWS_SECURITY_SERVER, string6, true);
            DefaultSettings.copyKey(CLIENT_KEYSTORE_BUNDLED, XWS_SECURITY_CLIENT, PASSWORD, PASSWORD, string4, XWS_SECURITY_CLIENT, string6, false);
            DefaultSettings.copyKey(CLIENT_TRUSTSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, string5, XWS_SECURITY_SERVER, string6, true);
            DefaultSettings.copyKey(CLIENT_TRUSTSTORE_BUNDLED, WSSIP, PASSWORD, PASSWORD, string5, WSSIP, string6, true);
        }
        catch (Exception exception) {
            logger.log(Level.INFO, null, exception);
        }
    }

    public static final void fillDefaults(Project project, boolean bl, boolean bl2) {
        boolean bl3 = ServerUtils.isTomcat(project);
        boolean bl4 = ServerUtils.isGlassfish(project);
        if (bl3) {
            if (project != null) {
                FileObject fileObject = ServerUtils.getTomcatLocation(project);
                try {
                    Object object;
                    FileObject fileObject2;
                    FileObject fileObject3 = FileUtil.createFolder((FileObject)fileObject, (String)STORE_FOLDER_NAME);
                    DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)fileObject3);
                    FileObject fileObject4 = FileUtil.getConfigFile((String)"Templates/WebServices/client-keystore.jks");
                    FileObject fileObject5 = FileUtil.getConfigFile((String)"Templates/WebServices/client-truststore.jks");
                    FileObject fileObject6 = FileUtil.getConfigFile((String)"Templates/WebServices/server-keystore.jks");
                    FileObject fileObject7 = FileUtil.getConfigFile((String)"Templates/WebServices/server-truststore.jks");
                    for (Object object2 : fileObject2 = new FileObject[]{fileObject4, fileObject5, fileObject6, fileObject7}) {
                        if (object2 == null || (object = DataObject.find((FileObject)object2)) == null || fileObject3.getFileObject(object2.getName(), object2.getExt()) != null) continue;
                        object.createFromTemplate(dataFolder, object2.getNameExt());
                    }
                    if (!bl) {
                        Object object2;
                        FileObject fileObject8 = fileObject.getFileObject("conf/tomcat-users.xml");
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        object2 = documentBuilder.parse(FileUtil.toFile((FileObject)fileObject8));
                        object = object2.getElementsByTagName("tomcat-users");
                        if (object != null && object.getLength() > 0) {
                            Object object3;
                            Object object4;
                            Object object5;
                            Node node = object.item(0);
                            NodeList nodeList = object2.getElementsByTagName("user");
                            boolean bl5 = false;
                            for (int i = 0; i < nodeList.getLength(); ++i) {
                                object5 = nodeList.item(i);
                                if (!(object5 instanceof Element) || !"wsitUser".equals(object4 = (object3 = (Element)object5).getAttribute("name"))) continue;
                                bl5 = true;
                                break;
                            }
                            if (!bl5) {
                                if (fileObject8.getParent().getFileObject("tomcat-users.backup", "xml") == null) {
                                    FileUtil.copyFile((FileObject)fileObject8, (FileObject)fileObject8.getParent(), (String)"tomcat-users.backup");
                                }
                                Element element = object2.createElement("user");
                                element.setAttribute("name", "wsitUser");
                                element.setAttribute("password", PASSWORD);
                                element.setAttribute("roles", "tomcat");
                                node.appendChild(element);
                                object5 = TransformerFactory.newInstance().newTransformer();
                                ((Transformer)object5).setOutputProperty("indent", "yes");
                                object3 = new StreamResult(FileUtil.toFile((FileObject)fileObject8));
                                object4 = new DOMSource((Node)object2);
                                ((Transformer)object5).transform((Source)object4, (Result)object3);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.INFO, null, exception);
                }
            }
            return;
        }
        String string = DefaultSettings.getDefaultPassword(project);
        if (bl4) {
            try {
                if (!bl && bl2) {
                    DefaultSettings.refreshBuildScript(project);
                }
                String string2 = ServerUtils.getStoreLocation(project, false, false);
                String string3 = ServerUtils.getStoreLocation(project, true, false);
                String string4 = ServerUtils.getStoreLocation(project, false, true);
                String string5 = ServerUtils.getStoreLocation(project, true, true);
                DefaultSettings.copyKey(SERVER_KEYSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, string2, XWS_SECURITY_SERVER, string, false);
                DefaultSettings.copyKey(SERVER_KEYSTORE_BUNDLED, WSSIP, PASSWORD, PASSWORD, string2, WSSIP, string, false);
                DefaultSettings.copyKey(SERVER_TRUSTSTORE_BUNDLED, "certificate-authority", PASSWORD, PASSWORD, string3, "xwss-certificate-authority", string, true);
                DefaultSettings.copyKey(SERVER_TRUSTSTORE_BUNDLED, XWS_SECURITY_CLIENT, PASSWORD, PASSWORD, string3, XWS_SECURITY_CLIENT, string, true);
                DefaultSettings.copyKey(SERVER_KEYSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, string3, XWS_SECURITY_SERVER, string, true);
                DefaultSettings.copyKey(CLIENT_KEYSTORE_BUNDLED, XWS_SECURITY_CLIENT, PASSWORD, PASSWORD, string4, XWS_SECURITY_CLIENT, string, false);
                DefaultSettings.copyKey(CLIENT_TRUSTSTORE_BUNDLED, XWS_SECURITY_SERVER, PASSWORD, PASSWORD, string5, XWS_SECURITY_SERVER, string, true);
                DefaultSettings.copyKey(CLIENT_TRUSTSTORE_BUNDLED, WSSIP, PASSWORD, PASSWORD, string5, WSSIP, string, true);
            }
            catch (Exception exception) {
                logger.log(Level.INFO, null, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyKey(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        KeyStore keyStore2 = KeyStore.getInstance("JKS");
        keyStore.load(Util.class.getResourceAsStream(string), string3.toCharArray());
        FileInputStream fileInputStream = new FileInputStream(string5);
        try {
            keyStore2.load(fileInputStream, string7.toCharArray());
            Key key = keyStore.getKey(string2, string4.toCharArray());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string5);
            try {
                if (key == null || bl) {
                    keyStore2.setCertificateEntry(string6, keyStore.getCertificate(string2));
                } else {
                    Certificate certificate = keyStore.getCertificate(string2);
                    Certificate[] certificateArray = new Certificate[]{certificate};
                    keyStore2.setKeyEntry(string6, key, string7.toCharArray(), certificateArray);
                }
            }
            finally {
                if (fileOutputStream != null) {
                    keyStore2.store(fileOutputStream, string7.toCharArray());
                    ((OutputStream)fileOutputStream).close();
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshBuildScript(Project project) {
        File file;
        String string = FileUtil.toFile((FileObject)project.getProjectDirectory()).getPath() + BUILD_SCRIPT;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        String string2 = null;
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf(IMPORT_WSIT_DEPLOY_XML) == -1) continue;
                bl = true;
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.INFO, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            logger.log(Level.INFO, null, iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.log(Level.INFO, null, iOException);
                }
            }
        }
        if (!bl) {
            try {
                file = new File(string);
                file.renameTo(new File(string + BACKUP_EXT));
                bufferedReader = new BufferedReader(new FileReader(string + BACKUP_EXT));
                bufferedWriter = new BufferedWriter(new FileWriter(string));
                bl = false;
                int n = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!bl && (n = string2.indexOf(IMPORT_TAG)) != -1) {
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        stringBuffer = stringBuffer.replace(n, string2.length(), IMPORT_WSIT_DEPLOY_XML);
                        bufferedWriter.write(stringBuffer.toString());
                        bufferedWriter.newLine();
                        bl = true;
                    }
                    bufferedWriter.write(string2);
                    bufferedWriter.newLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.log(Level.INFO, null, fileNotFoundException);
            }
            catch (IOException iOException) {
                logger.log(Level.INFO, null, iOException);
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    logger.log(Level.INFO, null, iOException);
                }
            }
        }
        file = new GeneratedFilesHelper(project.getProjectDirectory());
        try {
            file.refreshBuildScript(WSIT_DEPLOY_XML_PATH, Util.class.getClassLoader().getResource(WSIT_DEPLOY_XSL), false);
        }
        catch (IOException iOException) {
            logger.log(Level.INFO, null, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unfillDefaults(Project project) {
        String string = FileUtil.toFile((FileObject)project.getProjectDirectory()).getPath() + BUILD_SCRIPT;
        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/wsit.createuser");
        if (fileObject != null && fileObject.isValid() && !fileObject.isVirtual()) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        String string2 = null;
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf(IMPORT_WSIT_DEPLOY_XML) == -1) continue;
                bl = true;
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.INFO, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            logger.log(Level.INFO, null, iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.log(Level.INFO, null, iOException);
                }
            }
        }
        if (bl) {
            try {
                File file = new File(string);
                file.renameTo(new File(string + BACKUP_EXT));
                bufferedReader = new BufferedReader(new FileReader(string + BACKUP_EXT));
                bufferedWriter = new BufferedWriter(new FileWriter(string));
                bl = false;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.indexOf(IMPORT_WSIT_DEPLOY_XML) != -1) continue;
                    bufferedWriter.write(string2);
                    bufferedWriter.newLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.log(Level.INFO, null, fileNotFoundException);
            }
            catch (IOException iOException) {
                logger.log(Level.INFO, null, iOException);
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    logger.log(Level.INFO, null, iOException);
                }
            }
        }
    }

    public static String getDefaultPassword(Project project) {
        String string;
        String string2 = PASSWORD;
        if (ServerUtils.isGlassfish(project) && !DefaultSettings.passwordOK(string = ServerUtils.getStoreLocation(project, false, false), string2) && !DefaultSettings.passwordOK(string, string2 = Util.getPassword(project))) {
            string2 = "";
        }
        return string2;
    }

    public static String getDefaultPassword(String string) {
        String string2;
        String string3 = PASSWORD;
        if (ServerUtils.isGlassfish(string) && !DefaultSettings.passwordOK(string2 = ServerUtils.getStoreLocation(string, false, false), string3) && !DefaultSettings.passwordOK(string2, string3 = "adminadmin")) {
            string3 = "";
        }
        return string3;
    }

    private static boolean passwordOK(String string, String string2) {
        try {
            Util.getAliases(string, string2.toCharArray(), "JKS");
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

