/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deprecations
extends RubyAstRule {
    static Set<NodeType> kinds = new HashSet<NodeType>();
    private static Map<String, Deprecation> deprecatedMethods = new HashMap<String, Deprecation>();
    private static Map<String, Deprecation> deprecatedRequires = new HashMap<String, Deprecation>();

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        return kinds;
    }

    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        String string;
        boolean bl;
        Node node = rubyRuleContext.node;
        ParserResult parserResult = rubyRuleContext.parserResult;
        String string2 = ((INameNode)node).getName();
        Deprecation deprecation = null;
        if ("require".equals(string2)) {
            bl = true;
            string = Deprecations.getStringArg(node);
            if (string != null) {
                deprecation = deprecatedRequires.get(string);
            }
        } else if (deprecatedMethods.containsKey(string2)) {
            bl = false;
            deprecation = deprecatedMethods.get(string2);
        } else {
            return;
        }
        if (deprecation != null) {
            string = AstUtilities.getNameRange((Node)node);
            if ((string = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)string)) != OffsetRange.NONE) {
                String string3 = bl ? "DeprecatedRequire" : "DeprecatedMethodUse";
                String string4 = NbBundle.getMessage(Deprecations.class, (String)(deprecation.descriptionKey != null ? deprecation.descriptionKey : string3), (Object)deprecation.oldName, (Object)deprecation.newName);
                ArrayList<DeprecationCallFix> arrayList = new ArrayList<DeprecationCallFix>();
                if (!bl) {
                    arrayList.add(new DeprecationCallFix(rubyRuleContext, node, deprecation, false));
                }
                if (deprecation.helpUrl != null) {
                    arrayList.add(new DeprecationCallFix(rubyRuleContext, node, deprecation, true));
                }
                Hint hint = new Hint((Rule)this, string4, RubyUtils.getFileObject((Parser.Result)parserResult), (OffsetRange)string, arrayList, 100);
                list.add(hint);
            }
        }
    }

    private static String getStringArg(Node node) {
        String string;
        Node node2;
        ListNode listNode;
        Node node3;
        if (node.getNodeType() == NodeType.FCALLNODE && (node3 = ((FCallNode)node).getArgsNode()) instanceof ListNode && (listNode = (ListNode)node3).size() > 0 && (node2 = listNode.get(0)) instanceof StrNode && (string = ((StrNode)node2).getValue()) != null && string.length() > 0) {
            return string.toString();
        }
        return null;
    }

    public void cancel() {
    }

    public String getId() {
        return "Deprecations";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(Deprecations.class, (String)"Deprecation");
    }

    public String getDescription() {
        return NbBundle.getMessage(Deprecations.class, (String)"DeprecationDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    static {
        kinds.add(NodeType.FCALLNODE);
        kinds.add(NodeType.VCALLNODE);
        kinds.add(NodeType.CALLNODE);
        Deprecation deprecation = new Deprecation("require_gem", "gem", "HELP_require_gem", "http://www.ruby-forum.com/topic/136010");
        deprecatedMethods.put(deprecation.oldName, deprecation);
        Deprecation deprecation2 = new Deprecation("assert_raises", "assert_raise", "HELP_assert_raises", "http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-talk/155815");
        deprecatedMethods.put(deprecation2.oldName, deprecation2);
        Deprecation deprecation3 = new Deprecation("getopts", "optparse", null, null);
        deprecatedRequires.put(deprecation3.oldName, deprecation3);
        deprecation3 = new Deprecation("cgi-lib", "cgi", null, null);
        deprecatedRequires.put(deprecation3.oldName, deprecation3);
        deprecation3 = new Deprecation("importenv", "(no replacement)", null, null);
        deprecatedRequires.put(deprecation3.oldName, deprecation3);
        deprecation3 = new Deprecation("parsearg", "optparse", null, null);
        deprecatedRequires.put(deprecation3.oldName, deprecation3);
        deprecation3 = new Deprecation("ftools", "fileutils", "HELP_ftools", null);
        deprecatedRequires.put(deprecation3.oldName, deprecation3);
    }

    private static class DeprecationCallFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final Node node;
        private final Deprecation deprecation;
        private final boolean help;

        public DeprecationCallFix(RubyRuleContext rubyRuleContext, Node node, Deprecation deprecation, boolean bl) {
            this.context = rubyRuleContext;
            this.node = node;
            this.deprecation = deprecation;
            this.help = bl;
        }

        public String getDescription() {
            if (this.help) {
                return NbBundle.getMessage(Deprecations.class, (String)"ShowDeprecationHelp");
            }
            return NbBundle.getMessage(Deprecations.class, (String)"DeprecationFix", (Object)this.deprecation.oldName, (Object)this.deprecation.newName);
        }

        public void implement() throws Exception {
            if (this.help) {
                URL uRL = new URL(this.deprecation.helpUrl);
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            } else {
                EditList editList = this.getEditList();
                if (editList != null) {
                    editList.apply();
                }
            }
        }

        public EditList getEditList() throws Exception {
            BaseDocument baseDocument = this.context.doc;
            OffsetRange offsetRange = AstUtilities.getCallRange((Node)this.node);
            EditList editList = new EditList(baseDocument);
            if (offsetRange != OffsetRange.NONE) {
                if ("require_gem".equals(this.deprecation.oldName)) {
                    String string = Deprecations.getStringArg(this.node);
                    int n = Utilities.getRowEnd((BaseDocument)baseDocument, (int)offsetRange.getStart());
                    editList.replace(offsetRange.getStart(), offsetRange.getLength(), this.deprecation.newName, false, 0);
                    if (string != null) {
                        editList.replace(n, 0, "\nrequire \"" + string + "\"", false, 1);
                    }
                    editList.setFormatAll(true);
                } else {
                    editList.replace(offsetRange.getStart(), offsetRange.getLength(), this.deprecation.newName, false, 0);
                }
            }
            return editList;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return !this.help;
        }
    }

    private static class Deprecation {
        private String oldName;
        private String newName;
        private String descriptionKey;
        private String helpUrl;

        public Deprecation(String string, String string2, String string3, String string4) {
            this.oldName = string;
            this.newName = string2;
            this.descriptionKey = string3;
            this.helpUrl = string4;
        }
    }
}

