/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsDeprecations
extends RubyAstRule {
    static Set<String> deprecatedFields = new HashSet<String>();
    static Map<String, String> deprecatedMethods = new HashMap<String, String>();

    public boolean appliesTo(RuleContext ruleContext) {
        ParserResult parserResult = ruleContext.parserResult;
        Project project = FileOwnerQuery.getOwner((FileObject)RubyUtils.getFileObject((Parser.Result)parserResult));
        return project != null && project.getClass().getName().indexOf("RailsProject") != -1;
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.ROOTNODE);
    }

    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        Node node = rubyRuleContext.node;
        ParserResult parserResult = rubyRuleContext.parserResult;
        AstPath astPath = rubyRuleContext.path;
        if (node == null) {
            return;
        }
        assert (astPath.leaf() == node);
        this.scan(parserResult, node, list);
    }

    public void cancel() {
    }

    public String getId() {
        return "Rails_Deprecations";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RailsDeprecations.class, (String)"RailsDeprecation");
    }

    public String getDescription() {
        return NbBundle.getMessage(RailsDeprecations.class, (String)"RailsDeprecationDesc");
    }

    private void scan(ParserResult parserResult, Node node, List<Hint> list) {
        Object object;
        Object object2;
        if (node.getNodeType() == NodeType.INSTVARNODE || node.getNodeType() == NodeType.INSTASGNNODE) {
            object2 = ((INameNode)node).getName();
            if (deprecatedFields.contains(object2) && !RubyUtils.getFileObject((Parser.Result)parserResult).getName().endsWith("_test") && this.inActionController(parserResult, node)) {
                object = NbBundle.getMessage(RailsDeprecations.class, (String)"DeprecatedRailsField", (Object)object2, (Object)((String)object2).substring(1));
                this.addFix(parserResult, node, list, (String)object);
            }
        } else if (AstUtilities.isCall((Node)node) && deprecatedMethods.containsKey(object2 = ((INameNode)node).getName())) {
            if ("render_template".equals(object2) && RubyUtils.getFileObject((Parser.Result)parserResult).getName().endsWith("_spec")) {
                return;
            }
            if (((String)object2).startsWith("find_") && node.getNodeType() == NodeType.CALLNODE && (object = ((CallNode)node).getReceiverNode()).getNodeType() != NodeType.CONSTNODE && object.getNodeType() != NodeType.COLON2NODE) {
                return;
            }
            object = NbBundle.getMessage(RailsDeprecations.class, (String)"DeprecatedRailsMethodUse", (Object)object2, (Object)deprecatedMethods.get(object2));
            this.addFix(parserResult, node, list, (String)object);
        }
        object2 = node.childNodes();
        object = object2.iterator();
        while (object.hasNext()) {
            Node node2 = (Node)object.next();
            if (node2.isInvisible()) continue;
            this.scan(parserResult, node2, list);
        }
    }

    private boolean inActionController(ParserResult parserResult, Node node) {
        FileObject fileObject = RubyUtils.getFileObject((Parser.Result)parserResult);
        if (!fileObject.getPath().contains("/app/controllers")) {
            return false;
        }
        Node node2 = AstUtilities.getRoot((Parser.Result)parserResult);
        if (node2 == null) {
            return false;
        }
        AstPath astPath = new AstPath(node2, node);
        IScopingNode iScopingNode = AstUtilities.findClassOrModule((AstPath)astPath);
        if (iScopingNode == null) {
            return false;
        }
        String string = AstUtilities.getClassOrModuleName((IScopingNode)iScopingNode);
        RubyIndex rubyIndex = this.getIndex(parserResult);
        IndexedClass indexedClass = rubyIndex.getSuperclass(string);
        while (indexedClass != null) {
            String string2 = indexedClass.getName();
            if (string2.equals("ActionController::Base")) {
                return true;
            }
            indexedClass = rubyIndex.getSuperclass(string2);
        }
        return false;
    }

    private void addFix(ParserResult parserResult, Node node, List<Hint> list, String string) {
        OffsetRange offsetRange = AstUtilities.getNameRange((Node)node);
        if ((offsetRange = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)offsetRange)) != OffsetRange.NONE) {
            Hint hint = new Hint((Rule)this, string, RubyUtils.getFileObject((Parser.Result)parserResult), offsetRange, Collections.emptyList(), 100);
            list.add(hint);
        }
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    static {
        deprecatedFields.add("@params");
        deprecatedFields.add("@session");
        deprecatedFields.add("@flash");
        deprecatedFields.add("@request");
        deprecatedFields.add("@cookies");
        deprecatedFields.add("@headers");
        deprecatedFields.add("@response");
        deprecatedMethods.put("find_first", "find :first");
        deprecatedMethods.put("find_all", "find :all");
        deprecatedMethods.put("push_with_attributes", "has_many :through");
        deprecatedMethods.put("redirect_to_path", "redirect_to");
        deprecatedMethods.put("redirect_to_url", "redirect_to");
        deprecatedMethods.put("start_form_tag", "form_tag with a block");
        deprecatedMethods.put("end_form_tag", "form_tag with a block");
        deprecatedMethods.put("update_element_function", "RJS");
        deprecatedMethods.put("link_to_image", "link_to(image_tag(..), url)");
        deprecatedMethods.put("link_image_to", "link_to(image_tag(..), url)");
        deprecatedMethods.put("human_size", "number_to_human_size");
        deprecatedMethods.put("post_format", "respond_to or request.format");
        deprecatedMethods.put("formatted_post?", "respond_to or request.format");
        deprecatedMethods.put("xml_post?", "respond_to or request.format");
        deprecatedMethods.put("yaml_post?", "respond_to or request.format");
        deprecatedMethods.put("render_text", "render :text => ...");
        deprecatedMethods.put("render_template", "render :template => ...");
    }
}

