/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.codecoverage.CoverageBar;
import org.netbeans.modules.gsf.codecoverage.CoverageManagerImpl;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CoverageReportTopComponent
extends TopComponent {
    private CoverageTableModel model;
    private Project project;
    private static final String PREFERRED_ID = "CoverageReportTopComponent";
    private JButton allTestsButton;
    private JButton clearResultsButton;
    private JButton doneButton;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable table;
    private CoverageBar totalCoverage;

    CoverageReportTopComponent(Project project, List<FileCoverageSummary> list) {
        Method method;
        this.model = new CoverageTableModel(list);
        this.project = project;
        this.initComponents();
        this.table.setShowVerticalLines(false);
        this.table.setShowHorizontalLines(false);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(6, 4));
        this.table.setRowHeight(this.table.getRowHeight() + 4);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setMaxWidth(1000);
        tableColumnModel.getColumn(1).setMaxWidth(300);
        tableColumnModel.getColumn(2).setMaxWidth(150);
        tableColumnModel.getColumn(3).setMaxWidth(150);
        String string = ProjectUtils.getInformation((Project)project).getDisplayName();
        this.setName(NbBundle.getMessage(CoverageReportTopComponent.class, (String)"CTL_CoverageReportTopComponent", (Object)string));
        this.setToolTipText(NbBundle.getMessage(CoverageReportTopComponent.class, (String)"HINT_CoverageReportTopComponent"));
        try {
            method = JTable.class.getMethod("setFillsViewportHeight", new Class[0]);
            if (method != null) {
                method.invoke(null, new Object[0]);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.table.setDefaultRenderer(Float.class, new CoverageRenderer());
        this.table.setDefaultRenderer(String.class, new FileRenderer());
        try {
            method = JTable.class.getMethod("setAutoCreateRowSorter", Boolean.TYPE);
            if (method != null) {
                method.invoke((Object)this.table, Boolean.TRUE);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.totalCoverage.setCoveragePercentage(this.model.getTotalCoverage());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new EmptyPaintingTable();
        this.clearResultsButton = new JButton();
        this.jLabel1 = new JLabel();
        this.totalCoverage = new CoverageBar();
        this.allTestsButton = new JButton();
        this.doneButton = new JButton();
        this.table.setModel(this.model);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CoverageReportTopComponent.this.clicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        Mnemonics.setLocalizedText((AbstractButton)this.clearResultsButton, (String)NbBundle.getMessage(CoverageReportTopComponent.class, (String)"CoverageReportTopComponent.clearResultsButton.text"));
        this.clearResultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoverageReportTopComponent.this.clearResultsButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CoverageReportTopComponent.class, (String)"CoverageReportTopComponent.jLabel1.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this.totalCoverage);
        this.totalCoverage.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 146, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 18, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.allTestsButton, (String)NbBundle.getMessage(CoverageReportTopComponent.class, (String)"CoverageReportTopComponent.allTestsButton.text"));
        this.allTestsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoverageReportTopComponent.this.runAllTests(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.doneButton, (String)NbBundle.getMessage(CoverageReportTopComponent.class, (String)"CoverageReportTopComponent.doneButton.text"));
        this.doneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoverageReportTopComponent.this.done(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 546, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.clearResultsButton).addPreferredGap(0).add((Component)this.allTestsButton).addPreferredGap(0, 216, Short.MAX_VALUE).add((Component)this.doneButton)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.totalCoverage, -2, -1, -2))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.totalCoverage, -2, -1, -2)).add(18, 18, 18).add((Component)this.jScrollPane1, -1, 262, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.clearResultsButton).add((Component)this.allTestsButton).add((Component)this.doneButton)).addContainerGap()));
    }

    private void clearResultsButtonActionPerformed(ActionEvent actionEvent) {
        CoverageManagerImpl.getInstance().clear(this.project);
    }

    private void clicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.getSelectedRow()) != -1) {
            Object object;
            try {
                object = JTable.class.getMethod("convertRowIndexToModel", Integer.TYPE);
                if (object != null) {
                    n = (Integer)((Method)object).invoke((Object)this.table, n);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            object = (FileCoverageSummary)this.model.getValueAt(n, -1);
            CoverageManagerImpl.getInstance().showFile(this.project, (FileCoverageSummary)object);
        }
    }

    private void runAllTests(ActionEvent actionEvent) {
        Lookup lookup = this.project.getLookup();
        ActionProvider actionProvider = (ActionProvider)this.project.getLookup().lookup(ActionProvider.class);
        CoverageProvider coverageProvider = CoverageManagerImpl.getProvider(this.project);
        String string = "test";
        if (coverageProvider != null && coverageProvider.getTestAllAction() != null) {
            string = coverageProvider.getTestAllAction();
        }
        if (actionProvider != null && actionProvider.isActionEnabled("test", lookup)) {
            actionProvider.invokeAction(string, lookup);
        }
    }

    private void done(ActionEvent actionEvent) {
        CoverageManagerImpl.getInstance().setEnabled(this.project, false);
        this.close();
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
        CoverageManagerImpl.getInstance().closedReport(this.project);
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    void updateData(List<FileCoverageSummary> list) {
        this.model = new CoverageTableModel(list);
        this.table.setModel(this.model);
        this.totalCoverage.setCoveragePercentage(this.model.getTotalCoverage());
    }

    private static class EmptyPaintingTable
    extends JTable {
        private EmptyPaintingTable() {
        }

        public boolean getScrollableTracksViewportHeight() {
            return this.getParent() instanceof JViewport && this.getPreferredSize().height < this.getParent().getHeight();
        }
    }

    private class CoverageRenderer
    extends CoverageBar
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return new DefaultTableCellRenderer().getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            FileCoverageSummary fileCoverageSummary = (FileCoverageSummary)jTable.getValueAt(n, -1);
            boolean bl3 = fileCoverageSummary == ((CoverageTableModel)jTable.getModel()).total;
            this.setEmphasize(bl3);
            this.setSelected(bl);
            float f = ((Float)object).floatValue();
            this.setCoveragePercentage(f);
            return this;
        }
    }

    private static class FileRenderer
    extends JLabel
    implements TableCellRenderer {
        private FileRenderer() {
        }

        public boolean isOpaque() {
            return true;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            if (object == null) {
                return new DefaultTableCellRenderer().getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (bl) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(jTable.getForeground());
                super.setBackground(jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            if (bl2) {
                object2 = null;
                if (bl) {
                    object2 = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (object2 == null) {
                    object2 = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.setBorder((Border)object2);
            } else {
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
            object2 = (FileCoverageSummary)jTable.getValueAt(n, -1);
            FileObject fileObject = ((FileCoverageSummary)object2).getFile();
            this.setText(((FileCoverageSummary)object2).getDisplayName());
            if (fileObject != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    Node node = dataObject.getNodeDelegate();
                    Image image = node.getIcon(2);
                    this.setIcon(new ImageIcon(image));
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CoverageTableModel
    implements TableModel {
        List<FileCoverageSummary> results;
        FileCoverageSummary total;
        float totalCoverage = 0.0f;

        public CoverageTableModel(List<FileCoverageSummary> list) {
            if (list == null || list.size() == 0) {
                list = new ArrayList<FileCoverageSummary>();
            } else {
                Collections.sort(list);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (FileCoverageSummary fileCoverageSummary : list) {
                n += fileCoverageSummary.getLineCount();
                n2 += fileCoverageSummary.getExecutedLineCount();
                n3 += fileCoverageSummary.getInferredCount();
                n4 += fileCoverageSummary.getPartialCount();
            }
            if (list.size() == 0) {
                list.add(new FileCoverageSummary(null, NbBundle.getMessage(CoverageReportTopComponent.class, (String)"NoData"), 0, 0, 0, 0));
            } else {
                this.total = new FileCoverageSummary(null, "<html><b>" + NbBundle.getMessage(CoverageReportTopComponent.class, (String)"Total") + "</b></html>", n, n2, n3, n4);
                this.totalCoverage = this.total.getCoveragePercentage();
                list.add(this.total);
            }
            this.results = list;
        }

        float getTotalCoverage() {
            return this.totalCoverage;
        }

        @Override
        public int getRowCount() {
            return this.results.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return NbBundle.getMessage(CoverageReportTopComponent.class, (String)"Filename");
                }
                case 2: {
                    return NbBundle.getMessage(CoverageReportTopComponent.class, (String)"TotalStatements");
                }
                case 3: {
                    return NbBundle.getMessage(CoverageReportTopComponent.class, (String)"NotExecutedStatements");
                }
            }
            return NbBundle.getMessage(CoverageReportTopComponent.class, (String)"Coverage");
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 1: {
                    return Float.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            FileCoverageSummary fileCoverageSummary = this.results.get(n);
            switch (n2) {
                case -1: {
                    return fileCoverageSummary;
                }
                case 0: {
                    return fileCoverageSummary.getDisplayName();
                }
                case 1: {
                    return Float.valueOf(fileCoverageSummary.getCoveragePercentage());
                }
                case 2: {
                    return fileCoverageSummary.getLineCount();
                }
                case 3: {
                    return fileCoverageSummary.getLineCount() - fileCoverageSummary.getExecutedLineCount();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }
    }
}

