/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.FindersHelper;
import org.netbeans.modules.ruby.Inflector;
import org.netbeans.modules.ruby.RailsMigrationTypeMapper;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DatabasePropertiesIndexer {
    private final RubyIndex index;
    private final String prefix;
    private final QuerySupport.Kind kind;
    private final String classFqn;
    private final Set<IndexedMethod> methods;

    public DatabasePropertiesIndexer(RubyIndex rubyIndex, String string, QuerySupport.Kind kind, String string2, Set<IndexedMethod> set) {
        this.index = rubyIndex;
        this.prefix = string;
        this.kind = kind;
        this.classFqn = string2;
        this.methods = set;
    }

    static void indexDatabaseProperties(RubyIndex rubyIndex, String string, QuerySupport.Kind kind, String string2, Set<IndexedMethod> set) {
        DatabasePropertiesIndexer databasePropertiesIndexer = new DatabasePropertiesIndexer(rubyIndex, string, kind, string2, set);
        databasePropertiesIndexer.addDatabaseProperties();
    }

    private void addDatabaseProperties() {
        Object object;
        Object object2;
        String string = null;
        Collection<? extends IndexResult> collection = this.index.query("fqn", this.classFqn, QuerySupport.Kind.EXACT, new String[0]);
        Collection<? extends IndexResult> collection2 = collection.iterator();
        while (collection2.hasNext() && (string = (object2 = collection2.next()).getValue("explicit-dbtable")) == null) {
        }
        if (string == null) {
            collection2 = Inflector.getDefault();
            string = ((Inflector)((Object)collection2)).tableize(((Inflector)((Object)collection2)).demodulize(this.classFqn));
        }
        collection2 = this.index.query("dbtable", string, QuerySupport.Kind.EXACT, new String[0]);
        object2 = new ArrayList();
        TableDefinition tableDefinition = null;
        for (IndexResult object3 : collection2) {
            assert (object3 != null);
            object = object3.getValue("dbversion");
            assert (string.equals(object3.getValue("dbtable")));
            TableDefinition tableDefinition2 = new TableDefinition(string, (String)object, object3.getFile());
            object2.add(tableDefinition2);
            String[] stringArray = object3.getValues("dbcolumn");
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    tableDefinition2.addColumn(string2);
                }
            }
            if (!"schema".equals(object)) continue;
            tableDefinition = tableDefinition2;
            break;
        }
        if (object2.size() > 0) {
            HashMap hashMap = new HashMap();
            HashMap<String, FileObject> hashMap2 = new HashMap<String, FileObject>();
            object = new HashSet();
            if (tableDefinition != null) {
                this.addColumnsFromSchema(tableDefinition, hashMap, hashMap2, (Set<String>)object);
            } else {
                this.addColumnsFromMigrations((List<TableDefinition>)object2, hashMap, hashMap2, (Set<String>)object);
            }
            this.createMethodsForColumns(string, hashMap, hashMap2, (Set<String>)object);
            this.createDynamicFinders(string, hashMap, hashMap2, (Set<String>)object);
        }
    }

    private void addColumnsFromMigrations(List<TableDefinition> list, Map<String, String> map, Map<String, FileObject> map2, Set<String> set) {
        Collections.sort(list);
        for (TableDefinition tableDefinition : list) {
            List<String> list2 = tableDefinition.getColumns();
            if (list2 == null) continue;
            for (String string : list2) {
                int n = string.indexOf(59);
                if (n != -1) {
                    String string2 = string.substring(0, n);
                    if (n < string.length() - 1 && string.charAt(n + 1) == '-') {
                        set.remove(string2);
                        continue;
                    }
                    set.add(string2);
                    map2.put(string, tableDefinition.getFileUrl());
                    map.put(string2, string);
                    continue;
                }
                set.add(string);
                map.put(string, string);
                map2.put(string, tableDefinition.getFileUrl());
            }
        }
    }

    private void addColumnsFromSchema(TableDefinition tableDefinition, Map<String, String> map, Map<String, FileObject> map2, Set<String> set) {
        List<String> list = tableDefinition.getColumns();
        if (list != null) {
            for (String string : list) {
                int n = string.indexOf(59);
                if (n != -1) {
                    String string2 = string.substring(0, n);
                    if (n < string.length() - 1 && string.charAt(n + 1) == '-') {
                        set.remove(string);
                        continue;
                    }
                    set.add(string2);
                    map2.put(string, tableDefinition.getFileUrl());
                    map.put(string2, string);
                    continue;
                }
                set.add(string);
                map.put(string, string);
                map2.put(string, tableDefinition.getFileUrl());
            }
        }
    }

    private void createMethodsForColumns(String string, Map<String, String> map, Map<String, FileObject> map2, Set<String> set) {
        for (String string2 : set) {
            if (!string2.startsWith(this.prefix)) continue;
            if (this.kind == QuerySupport.Kind.EXACT) {
                if (string2.length() > this.prefix.length()) {
                    continue;
                }
            } else assert (this.kind == QuerySupport.Kind.PREFIX || this.kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
            String string3 = map.get(string2);
            String string4 = string;
            int n = string3.indexOf(59);
            if (n != -1) {
                string4 = string3.substring(n + 1);
            }
            FileObject fileObject = map2.get(string2);
            String string5 = string2;
            String string6 = string + "#" + string2;
            String string7 = string4;
            String string8 = null;
            String string9 = "";
            int n2 = 0;
            IndexedMethod indexedMethod = IndexedMethod.create(this.index, string5, string6, string7, fileObject, string8, string9, n2, this.index.getContext());
            indexedMethod.setMethodType(IndexedMethod.MethodType.DBCOLUMN);
            indexedMethod.setType(RailsMigrationTypeMapper.getMappedType(string4));
            indexedMethod.setSmart(true);
            this.methods.add(indexedMethod);
        }
    }

    private void createDynamicFinders(String string, Map<String, String> map, Map<String, FileObject> map2, Set<String> set) {
        if (this.kind == QuerySupport.Kind.EXACT) {
            return;
        }
        ArrayList<FindersHelper.FinderMethod> arrayList = new ArrayList<FindersHelper.FinderMethod>(FindersHelper.getFinderSignatures(this.prefix, set));
        for (FindersHelper.FinderMethod finderMethod : arrayList) {
            String string2 = finderMethod.getName();
            String string3 = finderMethod.getSignature();
            if (!string2.startsWith(this.prefix) || this.prefix.length() > string2.length()) continue;
            String string4 = finderMethod.getColumn();
            FileObject fileObject = map2.get(string4);
            String string5 = this.classFqn;
            String string6 = null;
            int n = 16;
            String string7 = IndexedElement.flagToString(n) + ";;;" + "options(:first|:all),args(=>conditions|order|group|limit|offset|joins|readonly:bool|include|select|from|readonly:bool|lock:bool)";
            String string8 = string + "#" + string3;
            IndexedMethod indexedMethod = IndexedMethod.create(this.index, string3, string8, string5, fileObject, string6, string7, n, this.index.getContext());
            indexedMethod.setMethodType(IndexedMethod.MethodType.DYNAMIC_FINDER);
            indexedMethod.setInherited(false);
            indexedMethod.setSmart(true);
            this.methods.add(indexedMethod);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableDefinition
    implements Comparable<TableDefinition> {
        private String version;
        private String table;
        private FileObject fileUrl;
        private List<String> cols;

        TableDefinition(String string, String string2, FileObject fileObject) {
            this.table = string;
            this.version = string2;
            this.fileUrl = fileObject;
        }

        @Override
        public int compareTo(TableDefinition tableDefinition) {
            if (this.version.length() != tableDefinition.version.length()) {
                return this.version.length() - tableDefinition.version.length();
            }
            return this.version.compareTo(tableDefinition.version);
        }

        FileObject getFileUrl() {
            return this.fileUrl;
        }

        void addColumn(String string) {
            if (this.cols == null) {
                this.cols = new ArrayList<String>();
            }
            this.cols.add(string);
        }

        List<String> getColumns() {
            return this.cols;
        }
    }
}

