/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.FindersHelper;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeInferencer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.options.TypeInferenceSettings;

final class RubyMethodTypeInferencer {
    private static final String[] COMPARISON_OPERATORS = new String[]{"==", "===", "!="};
    private static final String[] RECEIVER_METHODS = new String[]{"new", "clone", "dup", "freeze", "+", "-"};
    private static final Map<String, RubyType> METHOD_TYPES = new HashMap<String, RubyType>(16);
    private final Node callNodeToInfer;
    private final ContextKnowledge knowledge;
    private final boolean fast;

    private RubyMethodTypeInferencer(Node node, ContextKnowledge contextKnowledge, boolean bl) {
        assert (AstUtilities.isCall(node)) : "Must be a call node";
        this.callNodeToInfer = node;
        this.knowledge = contextKnowledge;
        this.fast = bl;
    }

    static RubyType inferTypeFor(Node node, ContextKnowledge contextKnowledge, boolean bl) {
        return new RubyMethodTypeInferencer(node, contextKnowledge, bl).inferType();
    }

    static RubyType fastCheckType(String string) {
        if (string.endsWith("?") || RubyMethodTypeInferencer.isTrueFalseCall(string)) {
            return RubyType.BOOLEAN;
        }
        return METHOD_TYPES.get(string);
    }

    private static boolean isTrueFalseCall(String string) {
        for (String string2 : COMPARISON_OPERATORS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    static boolean returnsReceiver(String string) {
        for (String string2 : RECEIVER_METHODS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    RubyIndex getIndex() {
        return this.knowledge == null ? null : this.knowledge.getIndex();
    }

    private RubyType inferType() {
        Object object;
        Object object2;
        Object object3;
        String string = AstUtilities.getName(this.callNodeToInfer);
        Node node = null;
        RubyType rubyType = null;
        switch (this.callNodeToInfer.getNodeType()) {
            case CALLNODE: {
                node = ((CallNode)this.callNodeToInfer).getReceiverNode();
                break;
            }
            case FCALLNODE: 
            case VCALLNODE: {
                object3 = this.knowledge.getRoot();
                object2 = new AstPath((Node)object3, this.callNodeToInfer);
                object = AstUtilities.findClassOrModule((AstPath)object2);
                if (object == null) break;
                rubyType = RubyType.create(AstUtilities.getClassOrModuleName((IScopingNode)object));
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal node passed: " + this.callNodeToInfer);
            }
        }
        object3 = RubyMethodTypeInferencer.fastCheckType(string);
        if (object3 != null) {
            return object3;
        }
        if (rubyType == null && node != null) {
            rubyType = this.getReceiverType(node);
        }
        if (rubyType == null) {
            return RubyType.createUnknown();
        }
        if (RubyMethodTypeInferencer.returnsReceiver(string)) {
            return rubyType;
        }
        if (FindersHelper.isFinderMethod(string) && rubyType.isSingleton() && this.getIndex() != null && (object2 = this.getIndex().getSuperclass(rubyType.first())) != null && "ActiveRecord::Base".equals(((IndexedElement)object2).getFqn())) {
            return FindersHelper.pickFinderType(this.callNodeToInfer, string, rubyType);
        }
        if (this.fast && !TypeInferenceSettings.getDefault().getMethodTypeInference()) {
            return RubyType.createUnknown();
        }
        object2 = new RubyType();
        object = this.getIndex();
        if (object == null) {
            return object2;
        }
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
        for (String object4 : rubyType.getRealTypes()) {
            hashSet.addAll(((RubyIndex)object).getMethods(string, object4, QuerySupport.Kind.EXACT));
        }
        if (hashSet.isEmpty()) {
            hashSet.addAll(((RubyIndex)object).getInheritedMethods(rubyType, string, QuerySupport.Kind.EXACT));
        }
        for (IndexedMethod indexedMethod : hashSet) {
            RubyType rubyType2 = indexedMethod.getType();
            ((RubyType)object2).append(rubyType2);
        }
        ((RubyIndex)object).logMostTimeConsuming();
        return object2;
    }

    private RubyType getReceiverType(Node node) {
        RubyType rubyType = RubyTypeInferencer.create(this.knowledge, this.fast).inferType(node);
        if (!rubyType.isKnown()) {
            String string = null;
            if (node instanceof Colon2Node) {
                string = AstUtilities.getFqn((Colon2Node)node);
            } else if (node instanceof INameNode) {
                string = AstUtilities.getName(node);
            }
            if (string != null && RubyUtils.isValidConstantFQN(string)) {
                rubyType = RubyType.create(string);
            }
        }
        return rubyType;
    }

    static {
        METHOD_TYPES.put("<=>", new RubyType(RubyType.FIXNUM, RubyType.NIL_CLASS));
        METHOD_TYPES.put("<", new RubyType(RubyType.BOOLEAN, RubyType.NIL_CLASS));
        METHOD_TYPES.put(">", new RubyType(RubyType.BOOLEAN, RubyType.NIL_CLASS));
        METHOD_TYPES.put("<=", new RubyType(RubyType.BOOLEAN, RubyType.NIL_CLASS));
        METHOD_TYPES.put("=>", new RubyType(RubyType.BOOLEAN, RubyType.NIL_CLASS));
        METHOD_TYPES.put("to_s", RubyType.STRING);
        METHOD_TYPES.put("to_str", RubyType.STRING);
        METHOD_TYPES.put("to_string", RubyType.STRING);
        METHOD_TYPES.put("to_sym", RubyType.SYMBOL);
        METHOD_TYPES.put("to_symbol", RubyType.SYMBOL);
        METHOD_TYPES.put("to_a", RubyType.ARRAY);
        METHOD_TYPES.put("to_ary", RubyType.ARRAY);
        METHOD_TYPES.put("to_array", RubyType.ARRAY);
        METHOD_TYPES.put("to_i", RubyType.INTEGER);
        METHOD_TYPES.put("to_int", RubyType.INTEGER);
        METHOD_TYPES.put("to_f", RubyType.FLOAT);
        METHOD_TYPES.put("to_float", RubyType.FLOAT);
    }
}

