/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.lexer;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsCommentLexer
implements Lexer<JsCommentTokenId> {
    public static final String AT_RETURN = "@return";
    private static final int EOF = -1;
    private LexerInput input;
    private TokenFactory<JsCommentTokenId> tokenFactory;

    public JsCommentLexer(LexerRestartInfo<JsCommentTokenId> lexerRestartInfo) {
        this.input = lexerRestartInfo.input();
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        assert (lexerRestartInfo.state() == null);
    }

    public Object state() {
        return null;
    }

    public Token<JsCommentTokenId> nextToken() {
        int n = this.input.read();
        if (n == -1) {
            return null;
        }
        if (Character.isJavaIdentifierStart(n)) {
            while (Character.isJavaIdentifierPart(this.input.read())) {
            }
            this.input.backup(1);
            return this.token(JsCommentTokenId.IDENT);
        }
        if ("@<.#{}".indexOf(n) == -1) {
            n = this.input.read();
            while (!Character.isJavaIdentifierStart(n) && "@<.#{}".indexOf(n) == -1 && n != -1) {
                n = this.input.read();
            }
            if (n != -1) {
                this.input.backup(1);
            }
            return this.token(JsCommentTokenId.OTHER_TEXT);
        }
        switch (n) {
            case 64: {
                while (Character.isLetter(n = this.input.read())) {
                }
                this.input.backup(1);
                return this.tokenFactory.createToken((TokenId)JsCommentTokenId.COMMENT_TAG, this.input.readLength());
            }
            case 60: {
                while ((n = this.input.read()) != 62 && n != -1) {
                }
                return this.token(JsCommentTokenId.HTML_TAG);
            }
            case 123: {
                return this.token(JsCommentTokenId.LCURL);
            }
            case 125: {
                return this.token(JsCommentTokenId.RCURL);
            }
            case 46: {
                return this.token(JsCommentTokenId.DOT);
            }
            case 35: {
                return this.token(JsCommentTokenId.HASH);
            }
        }
        assert (false);
        return null;
    }

    private Token<JsCommentTokenId> token(JsCommentTokenId jsCommentTokenId) {
        return this.tokenFactory.createToken((TokenId)jsCommentTokenId);
    }

    public void release() {
    }

    public static Map<String, String> findFunctionTypes(TokenSequence<? extends JsCommentTokenId> tokenSequence) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (tokenId != JsCommentTokenId.COMMENT_TAG) continue;
            CharSequence charSequence = token.text();
            if (TokenUtilities.textEquals((CharSequence)"@param", (CharSequence)charSequence) || TokenUtilities.textEquals((CharSequence)"@argument", (CharSequence)charSequence)) {
                String string;
                int n = tokenSequence.index();
                String string2 = JsCommentLexer.nextType(tokenSequence);
                if (string2 == null) {
                    tokenSequence.moveIndex(n);
                    tokenSequence.moveNext();
                }
                if ((string = JsCommentLexer.nextIdent(tokenSequence)) != null) {
                    hashMap.put(string, string2);
                    continue;
                }
                tokenSequence.moveIndex(n);
                tokenSequence.moveNext();
                continue;
            }
            if (TokenUtilities.textEquals((CharSequence)"@type", (CharSequence)charSequence)) {
                String string = JsCommentLexer.nextIdentGroup(tokenSequence);
                if (string == null) continue;
                hashMap.put(AT_RETURN, string);
                continue;
            }
            if (TokenUtilities.textEquals((CharSequence)AT_RETURN, (CharSequence)charSequence) || TokenUtilities.textEquals((CharSequence)"@returns", (CharSequence)charSequence)) {
                String string = JsCommentLexer.nextType(tokenSequence);
                if (string == null) continue;
                hashMap.put(AT_RETURN, string);
                continue;
            }
            if (TokenUtilities.textEquals((CharSequence)"@namespace", (CharSequence)charSequence) || TokenUtilities.textEquals((CharSequence)"@extends", (CharSequence)charSequence) || TokenUtilities.textEquals((CharSequence)"@method", (CharSequence)charSequence) || TokenUtilities.textEquals((CharSequence)"@property", (CharSequence)charSequence) || TokenUtilities.textEquals((CharSequence)"@class", (CharSequence)charSequence)) {
                String string = JsCommentLexer.nextIdentGroup(tokenSequence);
                if (string == null) continue;
                hashMap.put(((Object)charSequence).toString(), string);
                continue;
            }
            if (!TokenUtilities.textEquals((CharSequence)"@private", (CharSequence)charSequence) && !TokenUtilities.textEquals((CharSequence)"@constructor", (CharSequence)charSequence) && !TokenUtilities.textEquals((CharSequence)"@ignore", (CharSequence)charSequence) && !TokenUtilities.textEquals((CharSequence)"@deprecated", (CharSequence)charSequence)) continue;
            hashMap.put(((Object)charSequence).toString(), "");
        }
        return hashMap;
    }

    public static String nextType(TokenSequence<? extends JsCommentTokenId> tokenSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        Token<? extends JsCommentTokenId> token = JsCommentLexer.nextNonIgnored(tokenSequence);
        if (token != null && token.id() == JsCommentTokenId.LCURL) {
            boolean bl = true;
            while (tokenSequence.moveNext() && tokenSequence.token().id() != JsCommentTokenId.RCURL) {
                TokenId tokenId = tokenSequence.token().id();
                if (tokenId == JsCommentTokenId.IDENT || tokenId == JsCommentTokenId.DOT) {
                    if (bl && stringBuilder.length() > 0) {
                        stringBuilder.append('|');
                    }
                    bl = false;
                    stringBuilder.append(tokenSequence.token().text());
                    continue;
                }
                if (tokenId == JsCommentTokenId.OTHER_TEXT && TokenUtilities.startsWith((CharSequence)tokenSequence.token().text(), (CharSequence)"[]")) {
                    JsCommentLexer.rewriteAsArray(stringBuilder);
                    bl = true;
                    continue;
                }
                if (tokenId == JsCommentTokenId.HTML_TAG && TokenUtilities.startsWith((CharSequence)tokenSequence.token().text(), (CharSequence)"<") && stringBuilder.length() >= 5 && stringBuilder.charAt(stringBuilder.length() - 1) == 'y' && stringBuilder.toString().endsWith("Array")) {
                    stringBuilder.append(tokenSequence.token().text());
                    bl = true;
                    continue;
                }
                bl = true;
            }
            if (tokenSequence.token() != null && tokenSequence.token().id() == JsCommentTokenId.RCURL) {
                return stringBuilder.toString();
            }
        }
        return null;
    }

    public static String nextIdent(TokenSequence<? extends JsCommentTokenId> tokenSequence) {
        Token<? extends JsCommentTokenId> token = JsCommentLexer.nextNonIgnored(tokenSequence);
        if (token != null && token.id() == JsCommentTokenId.IDENT) {
            return ((Object)token.text()).toString();
        }
        return null;
    }

    public static String nextIdentGroup(TokenSequence<? extends JsCommentTokenId> tokenSequence) {
        Token<? extends JsCommentTokenId> token = JsCommentLexer.nextNonIgnored(tokenSequence);
        if (token != null && token.id() == JsCommentTokenId.IDENT) {
            if (tokenSequence.moveNext()) {
                TokenId tokenId = tokenSequence.token().id();
                if (tokenId == JsCommentTokenId.DOT) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(token.text());
                    boolean bl = true;
                    while (tokenSequence.token().id() == JsCommentTokenId.DOT || tokenSequence.token().id() == JsCommentTokenId.IDENT) {
                        stringBuilder.append(tokenSequence.token().text());
                        if (tokenSequence.moveNext()) continue;
                        bl = false;
                        break;
                    }
                    if (bl && TokenUtilities.startsWith((CharSequence)tokenSequence.token().text(), (CharSequence)"[]")) {
                        JsCommentLexer.rewriteAsArray(stringBuilder);
                    } else if (bl) {
                        tokenSequence.movePrevious();
                    }
                    return stringBuilder.toString();
                }
                if (tokenId == JsCommentTokenId.HTML_TAG && TokenUtilities.startsWith((CharSequence)tokenSequence.token().text(), (CharSequence)"<") && TokenUtilities.endsWith((CharSequence)token.text(), (CharSequence)"Array")) {
                    return "Array" + ((Object)tokenSequence.token().text()).toString();
                }
                if (tokenId == JsCommentTokenId.OTHER_TEXT && TokenUtilities.startsWith((CharSequence)tokenSequence.token().text(), (CharSequence)"[]")) {
                    return "Array<" + ((Object)token.text()).toString() + ">";
                }
                tokenSequence.movePrevious();
            }
            return ((Object)token.text()).toString();
        }
        return null;
    }

    public static String getCompat(TokenSequence<? extends JsCommentTokenId> tokenSequence) {
        Token token;
        StringBuilder stringBuilder = new StringBuilder();
        JsCommentLexer.nextIdent(tokenSequence);
        while ((token = tokenSequence.token()).id() == JsCommentTokenId.IDENT) {
            stringBuilder.append(token.text());
            if (!tokenSequence.moveNext() || (token = tokenSequence.token()).id() != JsCommentTokenId.OTHER_TEXT || token.length() != 1 || token.text().charAt(0) != '|') break;
            stringBuilder.append('|');
            if (tokenSequence.moveNext()) continue;
        }
        return stringBuilder.toString();
    }

    private static void rewriteAsArray(StringBuilder stringBuilder) {
        char c;
        int n;
        for (n = stringBuilder.length() - 1; n >= 0 && (c = stringBuilder.charAt(n)) != '|'; --n) {
        }
        if (++n == stringBuilder.length()) {
            return;
        }
        String string = stringBuilder.substring(n);
        stringBuilder.setLength(n);
        stringBuilder.append("Array<");
        stringBuilder.append(string);
        stringBuilder.append(">");
    }

    private static Token<? extends JsCommentTokenId> nextNonIgnored(TokenSequence<? extends JsCommentTokenId> tokenSequence) {
        while (tokenSequence.moveNext() && (tokenSequence.token().id() == JsCommentTokenId.OTHER_TEXT || tokenSequence.token().id() == JsCommentTokenId.RCURL)) {
        }
        return tokenSequence.token();
    }
}

