/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.mobility.antext.preprocessor.PPToken;
import org.netbeans.mobility.antext.preprocessor.PreprocessorScanner;
import org.netbeans.modules.mobility.editor.PPDirectiveCompletionItem;
import org.netbeans.modules.mobility.editor.PPVariableCompletionItem;
import org.netbeans.modules.mobility.editor.Utilities;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.util.NbBundle;

public final class PPCompletionProvider
implements CompletionProvider {
    private int myQueryType;
    public static final int DIRECTIVE_COMPLETION_QUERY = 998;
    public static final int VARIABLE_COMPLETION_QUERY = 999;
    private static final String DEBUG = "debug";
    private static final String ELSE = "else";
    private static final String ENDIF = "endif";
    private static final String ENDDEBUG = "enddebug";
    private static final String PREFIX = "//#";
    private static final String DESCDIR = "DESC_DIRECTIVE_CC_";
    public static final String[] DEBUG_LEVELS = new String[]{"debug", "info", "warn", "error", "fatal"};
    private static final String[] operatorTokens = new String[]{"==", "<=", ">=", "!=", "&&", "||"};
    private static final char[] operatorChars = new char[]{'^', ',', '@', '('};
    private static final String[] directives = new String[]{"if", "ifdef", "ifndef", "elifdef", "elifndef", "elif", "else", "endif", "debug", "mdebug", "enddebug", "define", "undefine", "condition"};

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        Project project;
        ProjectConfigurationsHelper projectConfigurationsHelper;
        String string2;
        int n = 0;
        if (string != null && string.endsWith("#")) {
            n |= 1;
            this.myQueryType = 998;
        }
        if (string != null && string.endsWith(" ")) {
            n |= 1;
            this.myQueryType = 999;
        }
        if (!PPCompletionProvider.canBeValidPPLine(string2 = PPCompletionProvider.getLine(jTextComponent))) {
            n = 0;
        }
        ProjectConfigurationsHelper projectConfigurationsHelper2 = projectConfigurationsHelper = (project = J2MEProjectUtils.getProjectForDocument((Document)jTextComponent.getDocument())) == null ? null : (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        if (projectConfigurationsHelper == null || !projectConfigurationsHelper.isPreprocessorOn()) {
            n = 0;
        }
        return n;
    }

    public static String getLine(JTextComponent jTextComponent) {
        return PPCompletionProvider.getLine(jTextComponent, jTextComponent.getCaret().getDot());
    }

    public static String getLine(JTextComponent jTextComponent, int n) {
        BaseDocument baseDocument = org.netbeans.editor.Utilities.getDocument((JTextComponent)jTextComponent);
        try {
            int n2 = org.netbeans.editor.Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n3 = org.netbeans.editor.Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
            return String.valueOf(baseDocument.getChars(n2, n3 - n2));
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public static boolean canBeValidPPLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        boolean bl = false;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.startsWith(PREFIX)) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public static boolean isLegalOperatorToken(String string) {
        for (int i = 0; i < operatorTokens.length; ++i) {
            if (!operatorTokens[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLegalOperatorChar(char c) {
        for (int i = 0; i < operatorChars.length; ++i) {
            if (operatorChars[i] != c) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidDirective(String string) {
        for (int i = 0; i < directives.length; ++i) {
            if (!string.equals(directives[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean canBeValidDirective(String string) {
        for (int i = 0; i < directives.length; ++i) {
            if (!directives[i].startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean canBeValidVariable(String string) {
        PreprocessorScanner preprocessorScanner = new PreprocessorScanner((Reader)new StringReader(string));
        preprocessorScanner.yybegin(1);
        PPToken pPToken = null;
        try {
            pPToken = preprocessorScanner.nextToken();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        return pPToken != null && pPToken.getType() == 279;
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        ProjectConfigurationsHelper projectConfigurationsHelper;
        Project project = J2MEProjectUtils.getProjectForDocument((Document)jTextComponent.getDocument());
        ProjectConfigurationsHelper projectConfigurationsHelper2 = projectConfigurationsHelper = project == null ? null : (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        if (projectConfigurationsHelper != null && projectConfigurationsHelper.isPreprocessorOn()) {
            block6: {
                try {
                    int n2 = jTextComponent.getCaret().getDot();
                    String string = PPCompletionProvider.getLine(jTextComponent, n2);
                    if (PPCompletionProvider.canBeValidPPLine(string)) {
                        int n3 = org.netbeans.editor.Utilities.getPreviousWord((JTextComponent)jTextComponent, (int)n2);
                        String string2 = jTextComponent.getDocument().getText(n3, n2 - n3);
                        this.myQueryType = PPCompletionProvider.canBeValidDirective(string2) ? (jTextComponent.getDocument().getText(n3 - 3, 3).equals(PREFIX) ? 998 : 999) : (PREFIX.equals(string2) ? 998 : 999);
                        break block6;
                    }
                    return null;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (n == 1 && this.myQueryType == 998) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new DirectiveQuery(), jTextComponent);
            }
            if (n == 1 && this.myQueryType == 999) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new VariableQuery(), jTextComponent);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DirectiveQuery
    extends AsyncCompletionQuery {
        private static final String[] directives = new String[]{"if", "ifdef", "ifndef", "elifdef", "elifndef", "elif", "endif", "else", "debug", "mdebug", "enddebug", "define", "undefine", "condition"};
        private ArrayList<PPDirectiveCompletionItem> directiveItems;
        private String filterPrefix;
        private JTextComponent component;
        private int ancor;

        DirectiveQuery() {
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            try {
                int n2 = org.netbeans.editor.Utilities.getPreviousWord((JTextComponent)this.component, (int)n);
                if (this.canFilter(this.component)) {
                    this.ancor = n2;
                    completionResultSet.setTitle(NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_TITLE_DIRE_CC"));
                    completionResultSet.setAnchorOffset(n2);
                    completionResultSet.addAllItems(this.getFilteredData(this.directiveItems, this.filterPrefix));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            completionResultSet.finish();
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            this.filterPrefix = null;
            try {
                int n = org.netbeans.editor.Utilities.getPreviousWord((JTextComponent)jTextComponent, (int)jTextComponent.getCaret().getDot());
                this.filterPrefix = jTextComponent.getDocument().getText(n, jTextComponent.getCaret().getDot() - n);
                if (PPCompletionProvider.PREFIX.equals(this.filterPrefix)) {
                    this.filterPrefix = "";
                } else if (!PPCompletionProvider.canBeValidDirective(this.filterPrefix) || "".equals(this.filterPrefix)) {
                    this.filterPrefix = null;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            if (this.filterPrefix != null) {
                completionResultSet.setTitle("Available directives");
                completionResultSet.setAnchorOffset(this.ancor);
                completionResultSet.addAllItems(this.getFilteredData(this.directiveItems, this.filterPrefix));
                completionResultSet.finish();
            }
        }

        private Collection<PPDirectiveCompletionItem> getFilteredData(Collection<PPDirectiveCompletionItem> collection, String string) {
            ArrayList<PPDirectiveCompletionItem> arrayList = new ArrayList<PPDirectiveCompletionItem>();
            for (PPDirectiveCompletionItem pPDirectiveCompletionItem : collection) {
                String string2 = ((Object)pPDirectiveCompletionItem.getSortText()).toString();
                if (!string2.startsWith(string)) continue;
                arrayList.add(pPDirectiveCompletionItem);
            }
            return arrayList;
        }

        private PPBlockInfo getBlock(JTextComponent jTextComponent) {
            try {
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n = org.netbeans.editor.Utilities.getLineOffset((BaseDocument)baseDocument, (int)jTextComponent.getCaret().getDot());
                ArrayList arrayList = (ArrayList)baseDocument.getProperty((Object)"preprocessor.line.list");
                if (arrayList != null) {
                    PPLine pPLine = null;
                    if (n >= 0 && n < arrayList.size() && (pPLine = (PPLine)arrayList.get(n)) != null) {
                        return pPLine.getBlock();
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }

        private boolean provideEndIf(JTextComponent jTextComponent) {
            PPBlockInfo pPBlockInfo = this.getBlock(jTextComponent);
            return this.isIf(pPBlockInfo) || this.isElse(pPBlockInfo) || this.isElif(pPBlockInfo);
        }

        private boolean provideElse(JTextComponent jTextComponent) {
            PPBlockInfo pPBlockInfo = this.getBlock(jTextComponent);
            return this.isIf(pPBlockInfo) || this.isElif(pPBlockInfo);
        }

        private boolean isIf(PPBlockInfo pPBlockInfo) {
            return pPBlockInfo != null && (pPBlockInfo.getType() == 0 || pPBlockInfo.getType() == 2 || pPBlockInfo.getType() == 3);
        }

        private boolean isElse(PPBlockInfo pPBlockInfo) {
            return pPBlockInfo != null && pPBlockInfo.getType() == 4;
        }

        private boolean isElif(PPBlockInfo pPBlockInfo) {
            return pPBlockInfo != null && (pPBlockInfo.getType() == 5 || pPBlockInfo.getType() == 6 || pPBlockInfo.getType() == 7);
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
            this.directiveItems = new ArrayList();
            for (int i = 0; i < directives.length; ++i) {
                if (directives[i].startsWith("if") || directives[i].equals(PPCompletionProvider.DEBUG) || directives[i].equals("mdebug") || directives[i].equals(PPCompletionProvider.ENDDEBUG) || directives[i].equals("define") || directives[i].equals("undefine") || directives[i].equals("condition")) {
                    this.directiveItems.add(new PPDirectiveCompletionItem(directives[i], NbBundle.getMessage(PPCompletionProvider.class, (String)(PPCompletionProvider.DESCDIR + (i + 1)))));
                    continue;
                }
                if (this.provideEndIf(jTextComponent) && directives[i].equals(PPCompletionProvider.ENDIF)) {
                    this.directiveItems.add(new PPDirectiveCompletionItem(directives[i], NbBundle.getMessage(PPCompletionProvider.class, (String)(PPCompletionProvider.DESCDIR + (i + 1)))));
                }
                if (this.provideElse(jTextComponent) && (directives[i].equals("elif") || directives[i].equals("elifdef") || directives[i].equals("elifndef"))) {
                    this.directiveItems.add(new PPDirectiveCompletionItem(directives[i], NbBundle.getMessage(PPCompletionProvider.class, (String)(PPCompletionProvider.DESCDIR + (i + 1)))));
                }
                if (!this.provideElse(jTextComponent) || !directives[i].equals(PPCompletionProvider.ELSE)) continue;
                this.directiveItems.add(new PPDirectiveCompletionItem(directives[i], NbBundle.getMessage(PPCompletionProvider.class, (String)(PPCompletionProvider.DESCDIR + (i + 1)))));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class VariableQuery
    extends AsyncCompletionQuery {
        private ArrayList<PPVariableCompletionItem> debugItems;
        private ArrayList<PPVariableCompletionItem> variableItems;
        private Set<String> variableSet;
        private JTextComponent component;
        private ProjectConfigurationsHelper pch;
        private String filterPrefix;
        private int ancor;

        VariableQuery() {
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
            this.variableItems = new ArrayList();
            this.debugItems = new ArrayList();
            this.variableSet = new TreeSet<String>();
            this.pch = J2MEProjectUtils.getCfgHelperForDoc((Document)jTextComponent.getDocument());
            ProjectConfiguration[] projectConfigurationArray = this.pch.getConfigurations().toArray(new ProjectConfiguration[0]);
            for (int i = 0; i < projectConfigurationArray.length; ++i) {
                this.variableItems.add(new PPVariableCompletionItem(projectConfigurationArray[i].getDisplayName(), NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_CONFIG_CC")));
                Map object = this.pch.getAbilitiesFor(projectConfigurationArray[i]);
                for (String string : object.keySet()) {
                    this.variableSet.add(string);
                }
            }
            for (String string : this.variableSet) {
                this.variableItems.add(new PPVariableCompletionItem(string, this.getVarInfo(string)));
            }
            for (int i = 0; i < DEBUG_LEVELS.length; ++i) {
                this.debugItems.add(new PPVariableCompletionItem(DEBUG_LEVELS[i], NbBundle.getMessage(PPCompletionProvider.class, (String)("DESC_DEBUG_CC_" + (i + 1)))));
            }
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            try {
                int n2 = org.netbeans.editor.Utilities.getPreviousWord((JTextComponent)this.component, (int)n);
                PPToken pPToken = new PreprocessorScanner((Reader)new StringReader(Utilities.getLine(this.component))).nextToken();
                if (this.canFilter(this.component)) {
                    this.ancor = n2;
                    completionResultSet.setTitle(NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_TITLE_VAR_CC"));
                    completionResultSet.setAnchorOffset(n2);
                    if (pPToken.getType() == 272 || pPToken.getType() == 273) {
                        completionResultSet.addAllItems(this.getFilteredData(this.debugItems, this.filterPrefix));
                    } else {
                        completionResultSet.addAllItems(this.getFilteredData(this.variableItems, this.filterPrefix));
                    }
                } else {
                    Completion.get().hideCompletion();
                }
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            completionResultSet.finish();
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            this.filterPrefix = null;
            try {
                int n = org.netbeans.editor.Utilities.getPreviousWord((JTextComponent)jTextComponent, (int)jTextComponent.getCaret().getDot());
                String string = jTextComponent.getDocument().getText(n, jTextComponent.getCaret().getDot() - n);
                this.filterPrefix = string.trim();
                if (!"".equals(this.filterPrefix) && (this.filterPrefix.length() == 1 ? PPCompletionProvider.isLegalOperatorChar(this.filterPrefix.charAt(this.filterPrefix.length() - 1)) : PPCompletionProvider.isLegalOperatorToken(this.filterPrefix.substring(this.filterPrefix.length() - 2)))) {
                    this.filterPrefix = "";
                } else if (string.length() > this.filterPrefix.length()) {
                    this.filterPrefix = PPCompletionProvider.isValidDirective(this.filterPrefix) ? (this.filterPrefix.equals(PPCompletionProvider.ENDIF) || this.filterPrefix.equals(PPCompletionProvider.ENDDEBUG) || this.filterPrefix.equals(PPCompletionProvider.ELSE) ? null : "") : null;
                } else if (PPCompletionProvider.isValidDirective(this.filterPrefix)) {
                    this.filterPrefix = null;
                } else if (!PPCompletionProvider.canBeValidVariable(this.filterPrefix)) {
                    this.filterPrefix = null;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            if (this.filterPrefix != null) {
                completionResultSet.setTitle(NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_TITLE_VAR_CC"));
                completionResultSet.setAnchorOffset(this.ancor);
                completionResultSet.addAllItems(this.getFilteredData(this.variableItems, this.filterPrefix));
                completionResultSet.finish();
            }
        }

        private Collection<PPVariableCompletionItem> getFilteredData(Collection<PPVariableCompletionItem> collection, String string) {
            ArrayList<PPVariableCompletionItem> arrayList = new ArrayList<PPVariableCompletionItem>();
            for (PPVariableCompletionItem pPVariableCompletionItem : collection) {
                String string2 = ((Object)pPVariableCompletionItem.getSortText()).toString();
                if (!string2.startsWith(string)) continue;
                arrayList.add(pPVariableCompletionItem);
            }
            return arrayList;
        }

        private String getVarInfo(Object object) {
            Map map = this.pch.getAbilitiesFor(this.pch.getActiveConfiguration());
            if (!map.containsKey(object)) {
                return NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_UNDEFINED_CC");
            }
            if (map.get(object) == null) {
                return NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_DEFINED_CC");
            }
            String string = (String)map.get(object);
            if (string.length() > 30) {
                string = string.substring(0, 29) + "...";
            }
            return NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_DEFINED_CC") + " <b>(" + string + ")</b>";
        }
    }
}

