/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.netbeans.modules.welcome.WelcomeOptions;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.ui.ContentBorder;
import org.openide.util.ImageUtilities;

class TabbedPane
extends JPanel
implements Constants {
    private JComponent leftTab;
    private JComponent rightTab;
    private JComponent tabHeader;
    private JPanel tabContent;
    private boolean leftTabAdded = false;
    private boolean rightTabAdded = false;

    public TabbedPane(String string, JComponent jComponent, String string2, JComponent jComponent2) {
        super(new BorderLayout());
        boolean bl;
        this.setOpaque(false);
        this.leftTab = jComponent;
        this.rightTab = jComponent2;
        jComponent.putClientProperty("print.printable", Boolean.TRUE);
        jComponent.putClientProperty("print.name", string);
        jComponent2.putClientProperty("print.printable", Boolean.TRUE);
        jComponent2.putClientProperty("print.name", string2);
        final TabButton tabButton = new TabButton(string);
        final TabButton tabButton2 = new TabButton(string2);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = actionEvent.getSource() == tabButton;
                tabButton.setSelected(bl);
                tabButton2.setSelected(!bl);
                TabbedPane.this.switchTab(bl);
                WelcomeOptions.getDefault().setLastActiveTab(bl ? 0 : 1);
            }
        };
        tabButton.addActionListener(actionListener);
        tabButton2.addActionListener(actionListener);
        this.tabHeader = new TabHeader(tabButton, tabButton2);
        this.add((Component)this.tabHeader, "North");
        this.tabContent = new JPanel(new GridBagLayout());
        this.tabContent.setOpaque(false);
        this.tabContent.setBorder(new ContentBorder());
        this.add((Component)this.tabContent, "Center");
        int n = WelcomeOptions.getDefault().getLastActiveTab();
        boolean bl2 = bl = n <= 0;
        if (WelcomeOptions.getDefault().isSecondStart() && n < 0) {
            bl = false;
            WelcomeOptions.getDefault().setLastActiveTab(1);
        }
        tabButton.setSelected(bl);
        tabButton2.setSelected(!bl);
        this.switchTab(bl);
    }

    private void switchTab(boolean bl) {
        JComponent jComponent;
        if (bl && !this.leftTabAdded) {
            this.tabContent.add((Component)this.leftTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.leftTabAdded = true;
        } else if (!bl && !this.rightTabAdded) {
            this.tabContent.add((Component)this.rightTab, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.rightTabAdded = true;
        }
        JComponent jComponent2 = bl ? this.leftTab : this.rightTab;
        JComponent jComponent3 = jComponent = bl ? this.rightTab : this.leftTab;
        if (null != jComponent) {
            jComponent.setVisible(false);
        }
        jComponent2.setVisible(true);
        jComponent2.requestFocusInWindow();
    }

    public Dimension getPreferredSize() {
        Container container;
        Dimension dimension = super.getPreferredSize();
        if (null != this.getParent() && null != this.getParent().getParent() && (container = this.getParent().getParent()).getWidth() > 0) {
            if (dimension.width > container.getWidth()) {
                dimension.width = Math.max(container.getWidth(), 600 + (int)((double)(FONT_SIZE - 11) / 11.0 * 600.0));
            } else if (dimension.width < container.getWidth()) {
                dimension.width = container.getWidth();
            }
        }
        dimension.width = Math.min(dimension.width, 1000);
        return dimension;
    }

    private static class TabHeader
    extends JPanel {
        private Image topLeftCornerSel;
        private Image topLeftCornerUnsel;
        private Image topRightCornerSel;
        private Image topRightCornerUnsel;
        private Image topGradientSel;
        private Image topGradientUnsel;
        private Image topMiddleLeftSel;
        private Image topMiddleRightSel;
        private Image middleShadowRightSel;
        private Image middleShadowLeftSel;
        private Image leftShadow;
        private Image rightShadow;
        private Image bottomShadowUnsel;
        private final TabButton leftButton;
        private final TabButton rightButton;

        public TabHeader(TabButton tabButton, TabButton tabButton2) {
            super(new GridLayout(1, 0));
            this.setOpaque(false);
            this.leftButton = tabButton;
            this.rightButton = tabButton2;
            Border border = BorderFactory.createEmptyBorder(8, 19, 2, 24);
            tabButton.setBorder(border);
            tabButton2.setBorder(border);
            this.add(tabButton);
            this.add(tabButton2);
            this.topLeftCornerSel = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_top_left_corner_sel.png");
            this.topLeftCornerUnsel = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_top_left_corner_unsel.png");
            this.topRightCornerSel = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_top_right_corner_sel.png");
            this.topRightCornerUnsel = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_top_right_corner_unsel.png");
            this.topGradientUnsel = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_top_gradient_unsel.png");
            this.topGradientSel = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_top_gradient_sel.png");
            this.leftShadow = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/left_shadow.png");
            this.rightShadow = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/right_shadow.png");
            this.bottomShadowUnsel = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_bottom_shadow_unsel.png");
            this.topMiddleRightSel = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_top_middle_right_sel.png");
            this.topMiddleLeftSel = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_top_middle_left_sel.png");
            this.middleShadowRightSel = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_middle_shadow_right_sel.png");
            this.middleShadowLeftSel = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_middle_shadow_left_sel.png");
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            boolean bl = this.leftButton.isSelected;
            int n = this.getHeight();
            int n2 = this.getWidth();
            Color color = bl ? Color.white : new Color(193, 193, 193);
            Image image = bl ? this.topGradientSel : this.topGradientUnsel;
            graphics2D.setColor(color);
            int n3 = n2 / 2 - 4;
            if (bl) {
                n3 -= 4;
            }
            graphics2D.fillRect(4, 21, n3, n - 21);
            int n4 = n2 / 2 - 19;
            if (bl) {
                n4 -= 22;
            }
            graphics2D.drawImage(image, 19, 0, n4, 21, this);
            graphics2D.drawImage(bl ? this.topLeftCornerSel : this.topLeftCornerUnsel, 0, 0, this);
            graphics2D.drawImage(this.leftShadow, 0, 21, 4, n - 21, this);
            if (bl) {
                graphics2D.drawImage(this.topMiddleLeftSel, n2 / 2 - 22, 0, this);
                graphics2D.drawImage(this.middleShadowLeftSel, n2 / 2 - 4, 24, 4, n - 24, this);
            } else {
                graphics2D.drawImage(this.topMiddleRightSel, n2 / 2, 0, this);
                graphics2D.drawImage(this.middleShadowRightSel, n2 / 2, 24, 4, n - 24, this);
            }
            graphics2D.drawImage(bl ? this.topRightCornerUnsel : this.topRightCornerSel, n2 - 20, 0, this);
            int n5 = bl ? 21 : 24;
            graphics2D.drawImage(this.rightShadow, n2 - 6, n5, 6, n - n5, this);
            color = !bl ? Color.white : new Color(193, 193, 193);
            image = !bl ? this.topGradientSel : this.topGradientUnsel;
            graphics2D.setColor(color);
            int n6 = n2 / 2;
            if (!bl) {
                n6 += 4;
            }
            graphics2D.fillRect(n6, 21, n2 - n6 - 6, n - 21);
            int n7 = n2 / 2;
            if (!bl) {
                n7 += 22;
            }
            graphics2D.drawImage(image, n7, 0, n2 - n7 - 20, 21, this);
            if (bl) {
                graphics2D.drawImage(this.bottomShadowUnsel, n2 / 2, n - 4, n2 / 2 - 6, 5, this);
            } else {
                graphics2D.drawImage(this.bottomShadowUnsel, 4, n - 4, n2 / 2, 5, this);
            }
        }

        protected void paintBorder(Graphics graphics) {
        }
    }

    private static class TabButton
    extends JLabel {
        private boolean isSelected = false;
        private ActionListener actionListener;

        public TabButton(String string) {
            super(string);
            this.setOpaque(false);
            this.setFont(Constants.TAB_FONT);
            this.setForeground(Utils.getColor(this.isSelected ? "TabSelForegroundColor" : "TabUnselForegroundColor"));
            this.setHorizontalAlignment(0);
            this.setFocusable(true);
            this.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                }

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
                        TabButton.this.setSelected(!TabButton.this.isSelected);
                        if (null != TabButton.this.actionListener) {
                            TabButton.this.actionListener.actionPerformed(new ActionEvent(TabButton.this, 0, "clicked"));
                        }
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                }
            });
            this.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    TabButton.this.setSelected(!TabButton.this.isSelected);
                    if (null != TabButton.this.actionListener) {
                        TabButton.this.actionListener.actionPerformed(new ActionEvent(TabButton.this, 0, "clicked"));
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    if (!TabButton.this.isSelected) {
                        TabButton.this.setCursor(Cursor.getPredefinedCursor(12));
                        TabButton.this.setForeground(Utils.getColor("MouseOverTabColor"));
                    } else {
                        TabButton.this.setCursor(Cursor.getDefaultCursor());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    TabButton.this.setCursor(Cursor.getDefaultCursor());
                    TabButton.this.setForeground(Utils.getColor(TabButton.this.isSelected ? "TabSelForegroundColor" : "TabUnselForegroundColor"));
                }
            });
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    TabButton.this.setForeground(Utils.getColor("MouseOverLinkColor"));
                }

                public void focusLost(FocusEvent focusEvent) {
                    TabButton.this.setForeground(Utils.getColor(TabButton.this.isSelected ? "TabSelForegroundColor" : "TabUnselForegroundColor"));
                }
            });
        }

        public void addActionListener(ActionListener actionListener) {
            assert (null == this.actionListener);
            this.actionListener = actionListener;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
            this.setForeground(Utils.getColor(this.isFocusOwner() ? "MouseOverLinkColor" : (this.isSelected ? "TabSelForegroundColor" : "TabUnselForegroundColor")));
            this.setFocusable(!bl);
            if (null != this.getParent()) {
                this.getParent().repaint();
            }
        }
    }
}

