/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.ui.ValidationUI;

public class ComponentDecorator {
    public ValidationUI createDecorator(JComponent c) {
        return new ToolTippedIconLabel(c);
    }

    public static final ComponentDecorator noOpComponentDecorator() {
        return new ComponentDecorator(){

            public ValidationUI createDecorator(JComponent c) {
                return new ValidationUI(){

                    public void clearProblem() {
                    }

                    public void setProblem(Problem problem) {
                    }
                };
            }
        };
    }

    private static class ToolTippedIconLabel
    extends JLabel
    implements ValidationUI {
        private static Icon fatalIconTransp = null;
        private static Icon warningIconTransp = null;
        private static Icon infoIconTransp = null;
        private final JToolTip tt = new JToolTip();
        private final JLabel ttLabel = new JLabel();
        private final JComponent decoratedComponent;
        private final ValidationUI colorizingBorder;
        private Problem currentProblem = Problem.NO_PROBLEM;
        private MouseEvent lastMouseEvent = null;
        private boolean hasAddedToPane = false;

        public ToolTippedIconLabel(JComponent component) {
            this.decoratedComponent = component;
            this.colorizingBorder = new ColorizingBorder(component);
            this.setToolTipText("");
            this.setOpaque(false);
            this.tt.setLayout(new BorderLayout());
            this.tt.add(this.ttLabel);
            this.tt.setVisible(true);
            this.ttLabel.setBackground(Color.WHITE);
            this.ttLabel.setOpaque(true);
            this.decoratedComponent.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent evt) {
                    ToolTippedIconLabel.this.tryDoUI();
                    ToolTippedIconLabel.this.setVisible(!ToolTippedIconLabel.this.currentProblem.equals(Problem.NO_PROBLEM));
                }

                public void componentHidden(ComponentEvent evt) {
                    ToolTippedIconLabel.this.tryDoUI();
                    ToolTippedIconLabel.this.setVisible(false);
                }

                public void componentMoved(ComponentEvent evt) {
                    ToolTippedIconLabel.this.tryDoUI();
                }

                public void componentResized(ComponentEvent evt) {
                    ToolTippedIconLabel.this.tryDoUI();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    ToolTippedIconLabel.this.lastMouseEvent = e;
                }

                public void mouseExited(MouseEvent e) {
                    ToolTippedIconLabel.this.lastMouseEvent = null;
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent e) {
                    ToolTippedIconLabel.this.lastMouseEvent = e;
                }
            });
        }

        public JToolTip createToolTip() {
            assert (SwingUtilities.isEventDispatchThread()) : "Not on EventDispatchThread";
            assert (this.tt != null);
            return this.tt;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (!visible) {
                this.colorizingBorder.clearProblem();
            } else {
                this.colorizingBorder.setProblem(this.currentProblem);
            }
        }

        public void clearProblem() {
            this.problemUpdate(Problem.NO_PROBLEM);
            this.colorizingBorder.clearProblem();
        }

        public void setProblem(Problem problem) {
            this.problemUpdate(problem);
            this.colorizingBorder.setProblem(problem);
        }

        private void problemUpdate(Problem problem) {
            assert (SwingUtilities.isEventDispatchThread()) : "Not on EventDispatchThread";
            if (problem == null) {
                throw new IllegalArgumentException("Null problem");
            }
            if (problem.equals(this.currentProblem)) {
                return;
            }
            this.currentProblem = problem;
            if (this.currentProblem == Problem.NO_PROBLEM) {
                if (this.isVisible()) {
                    this.setVisible(false);
                }
                if (this.tt.isShowing()) {
                    MouseEvent theEvent = this.lastMouseEvent;
                    this.dispatchEvent(new MouseEvent(this, 505, System.currentTimeMillis(), 0, 0, 0, 0, false));
                    this.lastMouseEvent = theEvent;
                }
                return;
            }
            this.setIcon(new ImageIcon(problem.severity().badge()));
            this.setSize(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
            this.ttLabel.setIcon(problem.severity().icon());
            this.ttLabel.setText(problem.getMessage());
            this.ttLabel.setForeground(problem.severity().color());
            this.tt.setPreferredSize(new Dimension(this.ttLabel.getPreferredSize().width + this.ttLabel.getIcon().getIconWidth(), Math.max(this.ttLabel.getIcon().getIconHeight() + 4, this.ttLabel.getPreferredSize().height + 4)));
            this.tt.setBorder(BorderFactory.createLineBorder(problem.severity().color()));
            this.setVisible(true);
            this.tryDoUI();
            if (this.lastMouseEvent != null) {
                MouseEvent theEvent = this.lastMouseEvent;
                this.dispatchEvent(new MouseEvent(this, 505, System.currentTimeMillis() - 100L, theEvent.getModifiers(), theEvent.getX(), theEvent.getY(), 0, false));
                assert (this.lastMouseEvent == null);
                this.dispatchEvent(new MouseEvent(this, 504, System.currentTimeMillis() - 50L, theEvent.getModifiers(), theEvent.getX(), theEvent.getY(), 0, false));
                this.dispatchEvent(new MouseEvent(this, 503, System.currentTimeMillis(), theEvent.getModifiers(), theEvent.getX(), theEvent.getY(), 0, false));
                assert (this.lastMouseEvent != null);
            }
        }

        private void tryDoUI() {
            assert (SwingUtilities.isEventDispatchThread()) : "Not on EventDispatchThread";
            if (!this.decoratedComponent.isShowing()) {
                return;
            }
            assert (JLayeredPane.getLayeredPaneAbove(this.decoratedComponent) != null) : "JLayeredPane.getLayeredPaneAbove(decoratedComponent) unexpectedly returned null";
            if (!this.hasAddedToPane) {
                JLayeredPane.getLayeredPaneAbove(this.decoratedComponent).add((Component)this, new Integer(JLayeredPane.getLayer(this.decoratedComponent) + 1));
                this.hasAddedToPane = true;
            }
            if (0 == this.getWidth()) {
                return;
            }
            Point p = this.decoratedComponent.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(p, this.getParent());
            p.translate(this.decoratedComponent.getWidth() - this.getWidth() + 2, -2);
            this.setLocation(p);
        }

        private static Icon getIconTransp(Severity severity) {
            if (severity.equals((Object)Severity.FATAL) && fatalIconTransp != null) {
                return fatalIconTransp;
            }
            if (severity.equals((Object)Severity.WARNING) && warningIconTransp != null) {
                return warningIconTransp;
            }
            if (severity.equals((Object)Severity.INFO) && infoIconTransp != null) {
                return infoIconTransp;
            }
            Icon icon = severity.icon();
            if (icon instanceof ImageIcon) {
                final ImageIcon imageIcon = (ImageIcon)icon;
                Image i = imageIcon.getImage();
                BufferedImage dest = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D g2 = dest.createGraphics();
                g2.drawImage(i, 0, 0, null);
                g2.dispose();
                RGBImageFilter filter = new RGBImageFilter(){

                    public int filterRGB(int x, int y, int rgb) {
                        if (x < (int)((double)imageIcon.getIconWidth() * 0.45) && y > 2) {
                            return 0x80FFFFFF & rgb;
                        }
                        return rgb;
                    }
                };
                Image transparentImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(i.getSource(), filter));
                icon = new ImageIcon(transparentImage);
            }
            if (severity.equals((Object)Severity.FATAL)) {
                fatalIconTransp = icon;
                return fatalIconTransp;
            }
            if (severity.equals((Object)Severity.WARNING)) {
                warningIconTransp = icon;
                return warningIconTransp;
            }
            assert (severity.equals((Object)Severity.INFO));
            infoIconTransp = icon;
            return infoIconTransp;
        }
    }

    private static class ColorizingBorder
    implements Border,
    ValidationUI {
        private final JComponent c;
        private final Border real;
        private Severity severity;

        public ColorizingBorder(JComponent c) {
            this.c = c;
            this.real = c.getBorder() != null ? c.getBorder() : BorderFactory.createEmptyBorder();
            c.setBorder(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.real.paintBorder(c, g, x, y, width, height);
            if (this.severity == null) {
                return;
            }
            g.setColor(this.severity.color());
            Graphics2D gg = (Graphics2D)g;
            Composite composite = gg.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.05f);
            try {
                gg.setComposite(alpha);
                gg.fillRect(x, y, width, height);
            }
            finally {
                gg.setComposite(composite);
            }
        }

        public Insets getBorderInsets(Component c) {
            return this.real.getBorderInsets(c);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void clearProblem() {
            if (this.severity != null) {
                this.severity = null;
            }
        }

        public void setProblem(Problem problem) {
            if (problem.severity() != this.severity) {
                this.severity = problem.severity();
            }
        }
    }
}

