/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.project.SourceGroup;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public class BrowseFolders
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private SourceGroup[] folders;
    private Class target;
    BeanTreeView btv;
    private static JScrollPane SAMPLE_SCROLL_PANE = new JScrollPane();
    private JPanel folderPanel;
    private JLabel jLabel1;

    public BrowseFolders(SourceGroup[] sourceGroupArray, Class clazz, String string) {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)(clazz == DataFolder.class ? "LBL_BrowseFolders" : "LBL_BrowseFiles")));
        this.folders = sourceGroupArray;
        this.target = clazz;
        this.manager = new ExplorerManager();
        AbstractNode abstractNode = new AbstractNode((Children)new SourceGroupsChildren(sourceGroupArray));
        this.manager.setRootContext((Node)abstractNode);
        this.btv = new BeanTreeView();
        this.btv.setRootVisible(false);
        this.btv.setSelectionMode(1);
        this.btv.setBorder(SAMPLE_SCROLL_PANE.getBorder());
        this.expandSelection(string);
        this.folderPanel.add((Component)this.btv, "Center");
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void expandSelection(String string) {
        int n;
        Node node = this.manager.getRootContext();
        Children children = node.getChildren();
        if (children == Children.LEAF) {
            return;
        }
        Node[] nodeArray = children.getNodes(true);
        Node node2 = null;
        if (string != null && string.length() > 0) {
            for (n = 0; n < nodeArray.length; ++n) {
                try {
                    node2 = NodeOp.findPath((Node)nodeArray[n], (Enumeration)NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(string, "/"), String.class, (boolean)false));
                    break;
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                    continue;
                }
            }
        }
        if (node2 == null) {
            this.btv.expandNode(node);
            for (n = 0; n < nodeArray.length; ++n) {
                this.btv.expandNode(nodeArray[n]);
                if (n != 0) continue;
                node2 = nodeArray[n];
            }
        }
        if (node2 != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{node2});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.folderPanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BrowseFolders.class, (String)"LBL_SelectFolder"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.folderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.folderPanel, gridBagConstraints);
    }

    public static FileObject showDialog(SourceGroup[] sourceGroupArray, Class clazz, String string) {
        BrowseFolders browseFolders = new BrowseFolders(sourceGroupArray, clazz, string);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)browseFolders, NbBundle.getMessage(BrowseFolders.class, (String)(clazz == DataFolder.class ? "LBL_BrowseFolders" : "LBL_BrowseFiles")), true, 2, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            return browseFolders.getSelectectFileObject();
        }
        return null;
    }

    public FileObject getSelectectFileObject() {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray == null || nodeArray.length < 1) {
            return null;
        }
        return (FileObject)nodeArray[0].getLookup().lookup(FileObject.class);
    }

    private class FileObjectComparator
    implements Comparator {
        private FileObjectComparator() {
        }

        public int compare(Object object, Object object2) {
            FileObject fileObject = (FileObject)object;
            FileObject fileObject2 = (FileObject)object2;
            return fileObject.getName().compareTo(fileObject2.getName());
        }
    }

    private final class SourceGroupsChildren
    extends Children.Keys {
        private SourceGroup[] groups;
        private SourceGroup group;
        private FileObject fo;

        public SourceGroupsChildren(SourceGroup[] sourceGroupArray) {
            this.groups = sourceGroupArray;
        }

        public SourceGroupsChildren(FileObject fileObject, SourceGroup sourceGroup) {
            this.fo = fileObject;
            this.group = sourceGroup;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            FileObject fileObject = null;
            SourceGroup sourceGroup = null;
            boolean bl = false;
            if (object instanceof SourceGroup) {
                fileObject = ((SourceGroup)object).getRootFolder();
                sourceGroup = (SourceGroup)object;
            } else if (object instanceof Key) {
                fileObject = ((Key)object).folder;
                sourceGroup = ((Key)object).group;
                if (!fileObject.isFolder()) {
                    bl = true;
                }
            }
            try {
                FilterNode filterNode;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                FilterNode filterNode2 = filterNode = bl ? new FilterNode(dataObject.getNodeDelegate(), Children.LEAF) : new FilterNode(dataObject.getNodeDelegate(), (Children)new SourceGroupsChildren(fileObject, sourceGroup));
                if (object instanceof SourceGroup) {
                    filterNode.setDisplayName(sourceGroup.getDisplayName());
                }
                return new Node[]{filterNode};
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
        }

        private Collection getKeys() {
            if (this.groups != null) {
                return Arrays.asList(this.groups);
            }
            FileObject[] fileObjectArray = this.fo.getChildren();
            Arrays.sort(fileObjectArray, new FileObjectComparator());
            ArrayList<Key> arrayList = new ArrayList<Key>(fileObjectArray.length);
            if (BrowseFolders.this.target == DataFolder.class) {
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    if (!fileObjectArray[i].isFolder() || !this.group.contains(fileObjectArray[i])) continue;
                    arrayList.add(new Key(fileObjectArray[i], this.group));
                }
            } else {
                int n;
                for (n = 0; n < fileObjectArray.length; ++n) {
                    if (!this.group.contains(fileObjectArray[n]) || !fileObjectArray[n].isFolder()) continue;
                    arrayList.add(new Key(fileObjectArray[n], this.group));
                }
                for (n = 0; n < fileObjectArray.length; ++n) {
                    if (!this.group.contains(fileObjectArray[n]) || fileObjectArray[n].isFolder()) continue;
                    arrayList.add(new Key(fileObjectArray[n], this.group));
                }
            }
            return arrayList;
        }

        private class Key {
            private FileObject folder;
            private SourceGroup group;

            private Key(FileObject fileObject, SourceGroup sourceGroup) {
                this.folder = fileObject;
                this.group = sourceGroup;
            }
        }
    }
}

