/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import hidden.org.codehaus.plexus.util.IOUtil;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessQueryImpl
implements AccessibilityQueryImplementation {
    private NbMavenProject mavenProject;
    private Project project;
    private WeakReference<List<Pattern>> ref;
    private static final String MANIFEST_PATH = "src/main/nbm/manifest.mf";
    private static final String ATTR_PUBLIC_PACKAGE = "OpenIDE-Module-Public-Packages";

    public AccessQueryImpl(Project project) {
        this.project = project;
        this.mavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
    }

    public Boolean isPubliclyAccessible(FileObject fileObject) {
        String string;
        FileObject fileObject2 = FileUtilities.convertStringToFileObject((String)this.mavenProject.getMavenProject().getBuild().getSourceDirectory());
        if (fileObject2 != null && (string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject)) != null) {
            String string2 = string.replace('/', '.');
            List<Pattern> list = this.getPublicPackagesPatterns();
            if (list.size() > 0) {
                return this.check(list, string2);
            }
        }
        return null;
    }

    private boolean check(List<Pattern> list, String string) {
        Pattern pattern;
        boolean bl = false;
        Iterator<Pattern> iterator = list.iterator();
        while (iterator.hasNext() && !(bl = (pattern = iterator.next()).matcher(string).matches())) {
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Pattern> getPublicPackagesPatterns() {
        List<Object> list;
        if (this.ref != null && (list = (List)this.ref.get()) != null) {
            return list;
        }
        list = new ArrayList();
        String[] stringArray = PluginPropertyUtils.getPluginPropertyList((Project)this.project, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"publicPackages", (String)"publicPackage", (String)"manifest");
        if (stringArray != null) {
            list = AccessQueryImpl.preparePublicPackagesPatterns(stringArray);
        } else {
            FileObject fileObject = this.project.getProjectDirectory().getFileObject(MANIFEST_PATH);
            if (fileObject != null) {
                InputStream inputStream = null;
                try {
                    inputStream = fileObject.getInputStream();
                    Manifest manifest = new Manifest();
                    manifest.read(inputStream);
                    String string = manifest.getMainAttributes().getValue(ATTR_PUBLIC_PACKAGE);
                    list = AccessQueryImpl.preparePublicPackagesPatterns(string);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
                finally {
                    IOUtil.close((InputStream)inputStream);
                }
            }
        }
        this.ref = new WeakReference(list);
        return list;
    }

    static List<Pattern> preparePublicPackagesPatterns(String[] stringArray) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        for (String string : stringArray) {
            string = string.trim();
            boolean bl = false;
            if (string.endsWith(".**")) {
                string = string.substring(0, string.length() - ".**".length());
                bl = true;
            }
            string = string.replace(".", "\\.");
            if (bl) {
                string = string + ".*";
            }
            arrayList.add(Pattern.compile(string));
        }
        return arrayList;
    }

    static List<Pattern> preparePublicPackagesPatterns(String string) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                string2 = string2.trim();
                boolean bl = false;
                if (string2.endsWith(".*")) {
                    string2 = string2.substring(0, string2.length() - ".*".length());
                    bl = false;
                } else if (string2.endsWith(".**")) {
                    string2 = string2.substring(0, string2.length() - ".**".length());
                    bl = true;
                }
                string2 = string2.replace(".", "\\.");
                if (bl) {
                    string2 = string2 + ".*";
                }
                arrayList.add(Pattern.compile(string2));
            }
        }
        return arrayList;
    }
}

