/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import hidden.org.codehaus.plexus.util.DirectoryScanner;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.core.startup.TestModuleDeployer;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.openide.filesystems.FileUtil;

public class ExecutionChecker
implements ExecutionResultChecker {
    private Project project;

    ExecutionChecker(Project project) {
        this.project = project;
    }

    public void executionResult(RunConfig runConfig, ExecutionContext executionContext, int n) {
        if ("nbmreload".equals(runConfig.getActionName()) && n == 0) {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            File file = new File(nbMavenProject.getMavenProject().getBuild().getDirectory(), "nbm");
            directoryScanner.setBasedir(file);
            directoryScanner.setIncludes(new String[]{"**/modules/*.jar", "**/modules/eager/*.jar", "**/modules/autoload/*.jar"});
            directoryScanner.scan();
            String[] stringArray = directoryScanner.getIncludedFiles();
            if (stringArray != null && stringArray.length > 0) {
                if (stringArray[0].indexOf("eager") > -1 || stringArray[0].indexOf("autoload") > -1) {
                    executionContext.getInputOutput().getErr().println("NetBeans: Cannot reload 'autoload' or 'eager' modules.");
                }
                try {
                    executionContext.getInputOutput().getOut().println("NetBeans: Deploying NBM module in development IDE...");
                    TestModuleDeployer.deployTestModule((File)FileUtil.normalizeFile((File)new File(file, stringArray[0])));
                }
                catch (IOException iOException) {
                    executionContext.getInputOutput().getOut().println("NetBeans: Error redeploying NBM module in development IDE.");
                    Logger.getLogger(ExecutionChecker.class.getName()).log(Level.INFO, "Error reloading netbeans module in development IDE.", iOException);
                }
            } else {
                executionContext.getInputOutput().getErr().println("NetBeans: Cannot find any built NetBeans Module artifacts for reload.");
            }
        }
    }
}

