/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.spi.NodeFactoryUtils;
import org.netbeans.modules.maven.apisupport.AnnotatedNode;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportantFilesNodeFactory
implements NodeFactory {
    static final String IMPORTANT_FILES_NAME = "important.files";
    static final String LAYER = "LAYER-FILE.PLACEHOLDER";
    static final RequestProcessor RP = new RequestProcessor();

    public NodeList createNodes(Project project) {
        if (project.getLookup().lookup(NbModuleProvider.class) != null) {
            return new ImpFilesNL(project);
        }
        return NodeFactorySupport.fixedNodeList((Node[])new Node[0]);
    }

    private static String computeAnnotatedHtmlDisplayName(String string, Set<FileObject> set) {
        String string2 = null;
        if (set != null && set.iterator().hasNext()) {
            try {
                FileSystem.HtmlStatus htmlStatus;
                String string3;
                FileObject fileObject = set.iterator().next();
                FileSystem.Status status = fileObject.getFileSystem().getStatus();
                if (status instanceof FileSystem.HtmlStatus && !string.equals(string3 = (htmlStatus = (FileSystem.HtmlStatus)status).annotateNameHtml(string, set))) {
                    string2 = string3;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
        return string2;
    }

    static final class SpecialFileNode
    extends FilterNode {
        private final String displayName;

        public SpecialFileNode(Node node, String string) {
            super(node);
            this.displayName = string;
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return super.getDisplayName();
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public String getHtmlDisplayName() {
            String string = null;
            DataObject dataObject = (DataObject)this.getLookup().lookup(DataObject.class);
            if (dataObject != null) {
                Set set = dataObject.files();
                string = ImportantFilesNodeFactory.computeAnnotatedHtmlDisplayName(this.getDisplayName(), set);
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImportantFilesChildren
    extends Children.Keys<String> {
        private List<String> visibleFiles = new ArrayList<String>();
        private FileChangeListener fcl;
        boolean nolayer = false;
        private FileChangeListener layerfcl = new FileChangeAdapter(){

            public void fileDeleted(FileEvent fileEvent) {
                ImportantFilesChildren.this.nolayer = true;
                ImportantFilesChildren.this.refreshKeys();
            }
        };
        private static final Map<String, String> FILES = new LinkedHashMap<String, String>();
        private final Project project;

        public ImportantFilesChildren(Project project) {
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.attachListeners();
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            this.removeListeners();
            super.removeNotify();
        }

        protected Node[] createNodes(String string) {
            if (ImportantFilesNodeFactory.LAYER.equals(string)) {
                Node node = NodeFactoryUtils.createLayersNode((Project)this.project);
                if (node != null) {
                    DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
                    if (dataObject != null) {
                        FileObject fileObject = dataObject.getPrimaryFile();
                        fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.layerfcl, (Object)fileObject));
                    }
                    return new Node[]{node};
                }
                return new Node[0];
            }
            FileObject fileObject = this.project.getProjectDirectory().getFileObject(string);
            if (fileObject != null) {
                try {
                    Node node = DataObject.find((FileObject)fileObject).getNodeDelegate();
                    return new Node[]{new SpecialFileNode(node, FILES.get(string))};
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    throw new AssertionError((Object)dataObjectNotFoundException);
                }
            }
            return new Node[0];
        }

        private void refreshKeys() {
            if (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        ImportantFilesChildren.this.refreshKeys();
                    }
                });
                return;
            }
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!this.nolayer) {
                arrayList.add(ImportantFilesNodeFactory.LAYER);
                this.nolayer = false;
            }
            for (String string : FILES.keySet()) {
                FileObject fileObject = this.project.getProjectDirectory().getFileObject(string);
                if (fileObject == null) continue;
                arrayList.add(string);
                hashSet.add(fileObject);
            }
            if (!this.isInitialized() || !((Object)arrayList).equals(this.visibleFiles)) {
                this.visibleFiles = arrayList;
                RP.post(new Runnable(){

                    public void run() {
                        ImportantFilesChildren.this.setKeys(ImportantFilesChildren.this.visibleFiles);
                    }
                });
                ((ImportantFilesNode)this.getNode()).setFiles(hashSet);
            }
        }

        private void attachListeners() {
            block3: {
                try {
                    if (this.fcl == null) {
                        this.fcl = new FileChangeAdapter(){

                            public void fileDataCreated(FileEvent fileEvent) {
                                ImportantFilesChildren.this.refreshKeys();
                            }

                            public void fileDeleted(FileEvent fileEvent) {
                                ImportantFilesChildren.this.refreshKeys();
                            }
                        };
                        this.project.getProjectDirectory().getFileSystem().addFileChangeListener(this.fcl);
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)fileStateInvalidException);
                }
            }
        }

        private void removeListeners() {
            if (this.fcl != null) {
                block3: {
                    try {
                        this.project.getProjectDirectory().getFileSystem().removeFileChangeListener(this.fcl);
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError((Object)fileStateInvalidException);
                    }
                }
                this.fcl = null;
            }
        }

        static {
            FILES.put("src/main/nbm/manifest.mf", NbBundle.getMessage(ImportantFilesNodeFactory.class, (String)"LBL_module_manifest"));
            FILES.put("src/main/nbm/module.xml", NbBundle.getMessage(ImportantFilesNodeFactory.class, (String)"LBL_module.xml"));
        }
    }

    static final class ImportantFilesNode
    extends AnnotatedNode {
        private static final String DISPLAY_NAME = NbBundle.getMessage(ImportantFilesNodeFactory.class, (String)"LBL_important_files");

        public ImportantFilesNode(Project project) {
            super((Children)new ImportantFilesChildren(project));
        }

        ImportantFilesNode(Children children) {
            super(children);
        }

        public String getName() {
            return ImportantFilesNodeFactory.IMPORTANT_FILES_NAME;
        }

        private Image getIcon(boolean bl) {
            Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/apisupport/config-badge.gif", (boolean)true);
            return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon((boolean)bl), (Image)image, (int)8, (int)8);
        }

        public String getDisplayName() {
            return this.annotateName(DISPLAY_NAME);
        }

        public String getHtmlDisplayName() {
            return ImportantFilesNodeFactory.computeAnnotatedHtmlDisplayName(ImportantFilesNode.DISPLAY_NAME, this.getFiles());
        }

        public Image getIcon(int n) {
            return this.annotateIcon(this.getIcon(false), n);
        }

        public Image getOpenedIcon(int n) {
            return this.annotateIcon(this.getIcon(true), n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImpFilesNL
    implements NodeList<String> {
        private Project project;

        public ImpFilesNL(Project project) {
            this.project = project;
        }

        public List<String> keys() {
            return Collections.singletonList(ImportantFilesNodeFactory.IMPORTANT_FILES_NAME);
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public Node node(String string) {
            assert (string == ImportantFilesNodeFactory.IMPORTANT_FILES_NAME);
            return new ImportantFilesNode(this.project);
        }

        public void addNotify() {
        }

        public void removeNotify() {
        }
    }
}

