/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.support;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.JavaSourceTaskFactory;
import org.netbeans.api.java.source.support.OpenedEditors;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CaretAwareJavaSourceTaskFactory
extends JavaSourceTaskFactory {
    private static final int DEFAULT_RESCHEDULE_TIMEOUT = 300;
    private static final RequestProcessor WORKER = new RequestProcessor("CaretAwareJavaSourceTaskFactory worker");
    private int timeout;
    private String[] supportedMimeTypes;
    private Map<JTextComponent, ComponentListener> component2Listener = new WeakHashMap<JTextComponent, ComponentListener>();
    private static Map<FileObject, Integer> file2LastPosition = new WeakHashMap<FileObject, Integer>();

    public CaretAwareJavaSourceTaskFactory(JavaSource.Phase phase, JavaSource.Priority priority) {
        this(phase, priority, null);
    }

    public CaretAwareJavaSourceTaskFactory(JavaSource.Phase phase, JavaSource.Priority priority, String ... stringArray) {
        super(phase, priority);
        OpenedEditors.getDefault().addChangeListener(new ChangeListenerImpl());
        this.timeout = 300;
        this.supportedMimeTypes = stringArray != null ? (String[])stringArray.clone() : null;
    }

    public List<FileObject> getFileObjects() {
        List<FileObject> list = OpenedEditors.filterSupportedMIMETypes(OpenedEditors.getDefault().getVisibleEditorsFiles(), this.supportedMimeTypes);
        return list;
    }

    public static synchronized int getLastPosition(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Cannot pass null file!");
        }
        Integer n = file2LastPosition.get(fileObject);
        if (n == null) {
            return 0;
        }
        return n;
    }

    static synchronized void setLastPosition(FileObject fileObject, int n) {
        file2LastPosition.put(fileObject, n);
    }

    private class ComponentListener
    implements CaretListener,
    Runnable {
        private final Reference<JTextComponent> component;
        private final RequestProcessor.Task rescheduleTask;

        public ComponentListener(JTextComponent jTextComponent) {
            this.component = new WeakReference<JTextComponent>(jTextComponent);
            this.rescheduleTask = WORKER.create((Runnable)this);
        }

        public void run() {
            JTextComponent jTextComponent = this.component.get();
            if (jTextComponent == null) {
                return;
            }
            FileObject fileObject = OpenedEditors.getFileObject(jTextComponent);
            if (fileObject != null) {
                CaretAwareJavaSourceTaskFactory.setLastPosition(fileObject, jTextComponent.getCaretPosition());
                CaretAwareJavaSourceTaskFactory.this.reschedule(fileObject);
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            JTextComponent jTextComponent = this.component.get();
            if (jTextComponent == null) {
                return;
            }
            FileObject fileObject = OpenedEditors.getFileObject(jTextComponent);
            if (fileObject != null) {
                CaretAwareJavaSourceTaskFactory.setLastPosition(fileObject, jTextComponent.getCaretPosition());
                this.rescheduleTask.schedule(CaretAwareJavaSourceTaskFactory.this.timeout);
            }
        }
    }

    private class ChangeListenerImpl
    implements ChangeListener {
        private ChangeListenerImpl() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ArrayList<JTextComponent> arrayList = new ArrayList<JTextComponent>(OpenedEditors.getDefault().getVisibleEditors());
            ArrayList arrayList2 = new ArrayList(CaretAwareJavaSourceTaskFactory.this.component2Listener.keySet());
            arrayList.removeAll(CaretAwareJavaSourceTaskFactory.this.component2Listener.keySet());
            arrayList2.removeAll(OpenedEditors.getDefault().getVisibleEditors());
            for (JTextComponent jTextComponent : arrayList2) {
                jTextComponent.removeCaretListener((CaretListener)CaretAwareJavaSourceTaskFactory.this.component2Listener.remove(jTextComponent));
            }
            for (JTextComponent jTextComponent : arrayList) {
                ComponentListener componentListener = new ComponentListener(jTextComponent);
                jTextComponent.addCaretListener(componentListener);
                CaretAwareJavaSourceTaskFactory.this.component2Listener.put(jTextComponent, componentListener);
                CaretAwareJavaSourceTaskFactory.setLastPosition(OpenedEditors.getFileObject(jTextComponent), jTextComponent.getCaretPosition());
            }
            CaretAwareJavaSourceTaskFactory.this.fileObjectsChanged();
        }
    }
}

