/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.netbeans.modules.java.source.JavaSourceTaskFactoryManager;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.LuceneIndexMBeanImpl;
import org.netbeans.modules.java.source.util.LowMemoryNotifierMBeanImpl;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;

public class JBrowseModule
extends ModuleInstall {
    private static final boolean ENABLE_MBEANS = Boolean.getBoolean("org.netbeans.modules.java.source.enableMBeans");
    private static Logger log = Logger.getLogger(JBrowseModule.class.getName());

    public void restored() {
        super.restored();
        JavaSourceTaskFactoryManager.register();
        if (ENABLE_MBEANS) {
            JBrowseModule.registerMBeans();
        }
        System.setProperty("useJavaUtilZip", "true");
    }

    public void close() {
        super.close();
        try {
            ClassIndexManager.getDefault().takeWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    ClassIndexManager.getDefault().close();
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        if (ENABLE_MBEANS) {
            JBrowseModule.unregisterMBeans();
        }
    }

    private static void registerMBeans() {
        block8: {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                mBeanServer.registerMBean(new LowMemoryNotifierMBeanImpl(), new ObjectName("org.netbeans.modules.java.source:type=LowMemoryNotifier"));
                mBeanServer.registerMBean(LuceneIndexMBeanImpl.getDefault(), new ObjectName("org.netbeans.modules.java.source:type=LuceneIndex"));
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, notCompliantMBeanException.getMessage(), notCompliantMBeanException);
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, malformedObjectNameException.getMessage(), malformedObjectNameException);
                }
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, instanceAlreadyExistsException.getMessage(), instanceAlreadyExistsException);
                }
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                if (!log.isLoggable(Level.SEVERE)) break block8;
                log.log(Level.SEVERE, mBeanRegistrationException.getMessage(), mBeanRegistrationException);
            }
        }
    }

    private static void unregisterMBeans() {
        block6: {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                mBeanServer.unregisterMBean(new ObjectName("org.netbeans.modules.java.source:type=LowMemoryNotifier"));
                mBeanServer.unregisterMBean(new ObjectName("org.netbeans.modules.java.source:type=LuceneIndex"));
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, malformedObjectNameException.getMessage(), malformedObjectNameException);
                }
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, instanceNotFoundException.getMessage(), instanceNotFoundException);
                }
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                if (!log.isLoggable(Level.SEVERE)) break block6;
                log.log(Level.SEVERE, mBeanRegistrationException.getMessage(), mBeanRegistrationException);
            }
        }
    }
}

