/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.openide.util.Exceptions;

public class JavaBinaryIndexer
extends BinaryIndexer {
    static final Logger LOG = Logger.getLogger(JavaBinaryIndexer.class.getName());

    protected void index(final Context context) {
        LOG.log(Level.FINE, "index({0})", context.getRootURI());
        try {
            final ClassIndexManager classIndexManager = ClassIndexManager.getDefault();
            classIndexManager.prepareWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws IOException, InterruptedException {
                    BinaryAnalyser binaryAnalyser;
                    CachingArchiveProvider.getDefault().clearArchive(context.getRootURI());
                    File file = JavaIndex.getClassFolder(context.getRootURI());
                    FileObjects.deleteRecursively(file);
                    ClassIndexImpl classIndexImpl = classIndexManager.createUsagesQuery(context.getRootURI(), false);
                    if (classIndexImpl == null) {
                        return null;
                    }
                    if (context.isAllFilesIndexing() && (binaryAnalyser = classIndexImpl.getBinaryAnalyser()) != null) {
                        try {
                            BinaryAnalyser.Result result = binaryAnalyser.start(context.getRootURI(), new AtomicBoolean(false), new AtomicBoolean(false));
                            while (result == BinaryAnalyser.Result.CANCELED) {
                                result = binaryAnalyser.resume();
                            }
                            Object var6_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            BinaryAnalyser.Changes changes = binaryAnalyser.finish();
                            Map map = IndexingController.getDefault().getBinaryRootDependencies();
                            Map map2 = IndexingController.getDefault().getRootDependencies();
                            ArrayList<ElementHandle<TypeElement>> arrayList = new ArrayList<ElementHandle<TypeElement>>(changes.changed.size() + changes.removed.size());
                            arrayList.addAll(changes.changed);
                            arrayList.addAll(changes.removed);
                            Map<URL, Set<URL>> map3 = JavaCustomIndexer.findDependent(context.getRootURI(), map2, map, arrayList, !changes.added.isEmpty());
                            for (Map.Entry<URL, Set<URL>> entry : map3.entrySet()) {
                                context.addSupplementaryFiles(entry.getKey(), (Collection)entry.getValue());
                            }
                            throw throwable;
                        }
                        BinaryAnalyser.Changes changes = binaryAnalyser.finish();
                        Map map = IndexingController.getDefault().getBinaryRootDependencies();
                        Map map4 = IndexingController.getDefault().getRootDependencies();
                        ArrayList<ElementHandle<TypeElement>> arrayList = new ArrayList<ElementHandle<TypeElement>>(changes.changed.size() + changes.removed.size());
                        arrayList.addAll(changes.changed);
                        arrayList.addAll(changes.removed);
                        Map<URL, Set<URL>> map5 = JavaCustomIndexer.findDependent(context.getRootURI(), map4, map, arrayList, !changes.added.isEmpty());
                        for (Map.Entry<URL, Set<URL>> entry : map5.entrySet()) {
                            context.addSupplementaryFiles(entry.getKey(), (Collection)entry.getValue());
                        }
                    }
                    return null;
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends BinaryIndexerFactory {
        public BinaryIndexer createIndexer() {
            return new JavaBinaryIndexer();
        }

        public String getIndexerName() {
            return "java";
        }

        public int getIndexVersion() {
            return 14;
        }

        public void rootsRemoved(final Iterable<? extends URL> iterable) {
            assert (iterable != null);
            final ClassIndexManager classIndexManager = ClassIndexManager.getDefault();
            try {
                classIndexManager.prepareWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, InterruptedException {
                        for (URL uRL : iterable) {
                            classIndexManager.removeRoot(uRL);
                        }
                        return null;
                    }
                });
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }
    }
}

