/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.SourcePositions;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.java.source.parsing.DocPositionRegion;
import org.netbeans.modules.java.source.usages.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FindMethodRegionsVisitor
extends SimpleTreeVisitor<Void, Void> {
    private final Document doc;
    private final SourcePositions pos;
    private final AtomicBoolean canceled;
    private CompilationUnitTree cu;
    private final List<Pair<DocPositionRegion, MethodTree>> posRegions = new LinkedList<Pair<DocPositionRegion, MethodTree>>();

    public FindMethodRegionsVisitor(Document document, SourcePositions sourcePositions, AtomicBoolean atomicBoolean) {
        assert (document != null);
        assert (sourcePositions != null);
        assert (atomicBoolean != null);
        this.doc = document;
        this.pos = sourcePositions;
        this.canceled = atomicBoolean;
    }

    public List<Pair<DocPositionRegion, MethodTree>> getResult() {
        if (this.canceled.get()) {
            this.posRegions.clear();
        }
        return this.posRegions;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, Void void_) {
        this.cu = compilationUnitTree;
        for (Tree tree : compilationUnitTree.getTypeDecls()) {
            this.visit(tree, void_);
        }
        return null;
    }

    @Override
    public Void visitClass(ClassTree classTree, Void void_) {
        for (Tree tree : classTree.getMembers()) {
            this.visit(tree, void_);
        }
        return null;
    }

    @Override
    public Void visitMethod(MethodTree methodTree, Void void_) {
        assert (this.cu != null);
        if (!this.canceled.get()) {
            int n = (int)this.pos.getStartPosition(this.cu, methodTree.getBody());
            int n2 = (int)this.pos.getEndPosition(this.cu, methodTree.getBody());
            if (n >= 0) {
                try {
                    this.posRegions.add(Pair.of(new DocPositionRegion(this.doc, n, n2), methodTree));
                }
                catch (BadLocationException badLocationException) {
                    this.posRegions.clear();
                }
            }
        }
        return null;
    }
}

