/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Iterators {
    private static final String NULL_AS_PARAMETER_MESSAGE = "Iterator(s) passed in as parameter must NOT be null.";

    private Iterators() {
    }

    public static <T> Iterable<T> chained(Iterable<? extends Iterable<T>> iterable) {
        return new ChainedIterable(iterable);
    }

    public static <T> Iterable<T> filter(Iterable<T> iterable, Comparable<? super T> comparable) {
        Parameters.notNull((CharSequence)"it", iterable);
        Parameters.notNull((CharSequence)"c", comparable);
        return new FilterIterable<T>(iterable, comparable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainedIterator<E>
    implements Iterator<E> {
        protected final Iterator<? extends Iterable<E>> iteratorChain;
        protected Iterator<E> currentIterator = null;

        public ChainedIterator(Iterable<? extends Iterable<E>> iterable) {
            this.iteratorChain = iterable.iterator();
        }

        protected void updateCurrentIterator() {
            if (this.currentIterator == null) {
                this.currentIterator = !this.iteratorChain.hasNext() ? Collections.emptyList().iterator() : this.iteratorChain.next().iterator();
            }
            while (!this.currentIterator.hasNext() && this.iteratorChain.hasNext()) {
                this.currentIterator = this.iteratorChain.next().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.updateCurrentIterator();
            return this.currentIterator.hasNext();
        }

        @Override
        public E next() {
            this.updateCurrentIterator();
            return this.currentIterator.next();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainedIterable<T>
    implements Iterable<T> {
        final Iterable<? extends Iterable<T>> iterables;

        ChainedIterable(Iterable<? extends Iterable<T>> iterable) {
            assert (iterable != null);
            this.iterables = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            return new ChainedIterator(this.iterables);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterIterator<T>
    implements Iterator<T> {
        private final Iterator<T> it;
        private final Comparable<? super T> c;
        private T nextValue;

        public FilterIterator(Iterator<T> iterator, Comparable<? super T> comparable) {
            this.it = iterator;
            this.c = comparable;
        }

        @Override
        public boolean hasNext() {
            if (this.nextValue != null) {
                return true;
            }
            while (this.it.hasNext()) {
                T t = this.it.next();
                if (this.c.compareTo(t) == 0) continue;
                this.nextValue = t;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T t = this.nextValue;
            this.nextValue = null;
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported operation.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterIterable<T>
    implements Iterable<T> {
        private final Iterable<T> it;
        private final Comparable<? super T> c;

        public FilterIterable(Iterable<T> iterable, Comparable<? super T> comparable) {
            this.it = iterable;
            this.c = comparable;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilterIterator<T>(this.it.iterator(), this.c);
        }
    }
}

