/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server.ui.node;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.server.ServerRegistry;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public final class RootNode
extends AbstractNode {
    private static final String SERVERS_ICON = "org/netbeans/modules/server/ui/resources/servers.png";
    private static final Logger LOGGER = Logger.getLogger(RootNode.class.getName());
    private static RootNode node;

    private RootNode(ChildFactory childFactory) {
        super(Children.create((org.openide.nodes.ChildFactory)childFactory, (boolean)true));
        this.setName("");
        this.setDisplayName(NbBundle.getMessage(RootNode.class, (String)"Server_Registry_Node_Name"));
        this.setShortDescription(NbBundle.getMessage(RootNode.class, (String)"Server_Registry_Node_Short_Description"));
        this.setIconBaseWithExtension(SERVERS_ICON);
    }

    public static synchronized RootNode getInstance() {
        if (node == null) {
            ChildFactory childFactory = new ChildFactory();
            childFactory.init();
            node = new RootNode(childFactory);
        }
        return node;
    }

    public Action[] getActions(boolean bl) {
        Action[] actionArray = Utilities.actionsForPath((String)"Servers/Actions").toArray(new Action[0]);
        for (int i = 0; i < actionArray.length; ++i) {
            if (actionArray[i] == null || !Boolean.TRUE.equals(actionArray[i].getValue("serverNodeHidden"))) continue;
            actionArray[i] = null;
        }
        return actionArray;
    }

    static void enableActionsOnExpand() {
        FileObject fileObject = FileUtil.getConfigFile((String)"Servers/Actions");
        if (fileObject != null) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                Enumeration enumeration = fileObject2.getAttributes();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    boolean bl = false;
                    if (string.startsWith("property-")) {
                        if (System.getProperty(string = string.substring("property-".length())) != null) {
                            bl = true;
                        }
                    } else if (string.startsWith("config-") && FileUtil.getConfigFile((String)(string = string.substring("config-".length()))) != null) {
                        bl = true;
                    }
                    if (!bl) continue;
                    Lookup lookup = Lookups.forPath((String)"Servers/Actions");
                    for (Lookup.Item item : lookup.lookupResult(Action.class).allItems()) {
                        if (!item.getId().contains(fileObject2.getName())) continue;
                        Action action = (Action)item.getInstance();
                        action.actionPerformed(new ActionEvent((Object)RootNode.getInstance(), 0, "noui"));
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceComparator
    implements Comparator<ServerInstance>,
    Serializable {
        private InstanceComparator() {
        }

        @Override
        public int compare(ServerInstance serverInstance, ServerInstance serverInstance2) {
            boolean bl = false;
            boolean bl2 = false;
            if (serverInstance.getDisplayName() == null) {
                LOGGER.log(Level.INFO, "Instance display name is null for {0}", serverInstance);
                bl = true;
            }
            if (serverInstance2.getDisplayName() == null) {
                LOGGER.log(Level.INFO, "Instance display name is null for {0}", serverInstance2);
                bl2 = true;
            }
            if (bl && bl2) {
                return 0;
            }
            if (bl && !bl2) {
                return -1;
            }
            if (!bl && bl2) {
                return 1;
            }
            return serverInstance.getDisplayName().compareTo(serverInstance2.getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildFactory
    extends org.openide.nodes.ChildFactory<ServerInstance>
    implements ChangeListener,
    Runnable {
        private static final Comparator<ServerInstance> COMPARATOR = new InstanceComparator();
        private final List<ServerInstanceProvider> types = new ArrayList<ServerInstanceProvider>();
        private static boolean actionsPropertiesDone;

        public void init() {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ChildFactory childFactory = ChildFactory.this;
                    synchronized (childFactory) {
                        ServerRegistry serverRegistry = ServerRegistry.getInstance();
                        serverRegistry.addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)ChildFactory.this, (Object)serverRegistry));
                        ChildFactory.this.updateState(new ChangeEvent(serverRegistry));
                    }
                }
            });
        }

        @Override
        public void stateChanged(final ChangeEvent changeEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ChildFactory.this.updateState(changeEvent);
                }
            });
        }

        private synchronized void updateState(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof ServerRegistry) {
                for (ServerInstanceProvider serverInstanceProvider : this.types) {
                    serverInstanceProvider.removeChangeListener(this);
                }
                this.types.clear();
                this.types.addAll(((ServerRegistry)changeEvent.getSource()).getProviders());
                for (ServerInstanceProvider serverInstanceProvider : this.types) {
                    serverInstanceProvider.addChangeListener(this);
                }
            }
            this.refresh();
        }

        protected final void refresh() {
            this.refresh(false);
        }

        protected Node createNodeForKey(ServerInstance serverInstance) {
            return serverInstance.getFullNode();
        }

        protected boolean createKeys(List<ServerInstance> list) {
            ArrayList<ServerInstance> arrayList = new ArrayList<ServerInstance>();
            Mutex.EVENT.readAccess((Runnable)this);
            ServerRegistry serverRegistry = ServerRegistry.getInstance();
            for (ServerInstanceProvider serverInstanceProvider : serverRegistry.getProviders()) {
                arrayList.addAll(serverInstanceProvider.getInstances());
            }
            Collections.sort(arrayList, COMPARATOR);
            list.addAll(arrayList);
            return true;
        }

        @Override
        public void run() {
            if (actionsPropertiesDone) {
                return;
            }
            assert (EventQueue.isDispatchThread());
            actionsPropertiesDone = true;
            RootNode.enableActionsOnExpand();
            ServerRegistry.getInstance().getProviders();
        }
    }
}

