/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.dd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.netbeans.api.j2ee.core.Profile;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DDHelper {
    private static final String RESOURCE_FOLDER = "org/netbeans/modules/j2ee/common/dd/resources/";

    private DDHelper() {
    }

    public static FileObject createWebXml(Profile profile, FileObject fileObject) throws IOException {
        return DDHelper.createWebXml(profile, true, fileObject);
    }

    public static FileObject createWebXml(Profile profile, boolean bl, FileObject fileObject) throws IOException {
        String string = null;
        if ((Profile.JAVA_EE_6_FULL == profile || Profile.JAVA_EE_6_WEB == profile) && bl) {
            string = "web-3.0.xml";
        } else if (Profile.JAVA_EE_5 == profile) {
            string = "web-2.5.xml";
        } else if (Profile.J2EE_14 == profile) {
            string = "web-2.4.xml";
        } else if (Profile.J2EE_13 == profile) {
            string = "web-2.3.xml";
        }
        if (string == null) {
            return null;
        }
        MakeFileCopy makeFileCopy = new MakeFileCopy(RESOURCE_FOLDER + string, fileObject, "web.xml");
        FileUtil.runAtomicAction((Runnable)makeFileCopy);
        if (makeFileCopy.getException() != null) {
            throw makeFileCopy.getException();
        }
        return makeFileCopy.getResult();
    }

    public static FileObject createWebFragmentXml(Profile profile, FileObject fileObject) throws IOException {
        String string = null;
        if (Profile.JAVA_EE_6_FULL == profile || Profile.JAVA_EE_6_WEB == profile) {
            string = "web-fragment-3.0.xml";
        }
        if (string == null) {
            return null;
        }
        MakeFileCopy makeFileCopy = new MakeFileCopy(RESOURCE_FOLDER + string, fileObject, "web-fragment.xml");
        FileUtil.runAtomicAction((Runnable)makeFileCopy);
        if (makeFileCopy.getException() != null) {
            throw makeFileCopy.getException();
        }
        return makeFileCopy.getResult();
    }

    private static class MakeFileCopy
    implements Runnable {
        private String fromFile;
        private FileObject toDir;
        private String toFile;
        private IOException exception;
        private FileObject result;

        MakeFileCopy(String string, FileObject fileObject, String string2) {
            this.fromFile = string;
            this.toDir = fileObject;
            this.toFile = string2;
        }

        IOException getException() {
            return this.exception;
        }

        FileObject getResult() {
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.toDir.getFileObject(this.toFile) != null) {
                    throw new IllegalStateException("file " + this.toFile + " already exists in " + this.toDir);
                }
                FileObject fileObject = FileUtil.createData((FileObject)this.toDir, (String)this.toFile);
                String string = this.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.fromFile));
                if (string != null) {
                    FileLock fileLock = fileObject.lock();
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject.getOutputStream(fileLock)));
                    try {
                        bufferedWriter.write(string);
                    }
                    finally {
                        bufferedWriter.close();
                        fileLock.releaseLock();
                    }
                }
                this.result = fileObject;
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readResource(InputStream inputStream) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            String string = System.getProperty("line.separator");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append(string);
                    string2 = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
            return stringBuilder.toString();
        }
    }
}

