/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.util.concurrent.Callable;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.export.ExportCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

class CommandRunnable
implements Runnable,
Cancellable {
    private final Client client;
    private final GlobalOptions options;
    private final Command cmd;
    private Throwable failure;
    private boolean aborted;
    private ExecutorSupport support;
    private static boolean testRetry = Boolean.getBoolean("netbeans.debug.cvs.io.retry");

    public CommandRunnable(Client client, GlobalOptions globalOptions, Command command, ExecutorSupport executorSupport) {
        this.client = client;
        this.options = globalOptions;
        this.cmd = command;
        this.support = executorSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block13: {
            Runnable runnable = this;
            synchronized (runnable) {
                if (this.isAborted()) {
                    return;
                }
                this.support.commandStarted(this);
            }
            runnable = new CounterRunnable();
            RequestProcessor.Task task = RequestProcessor.getDefault().create(runnable);
            ((CounterRunnable)runnable).initTask(task);
            task.schedule(500);
            if (testRetry && !this.support.t9yRetryFlag) {
                this.support.t9yRetryFlag = true;
                String string = "Testing retry logic. Retry attempt will be OK. (-Dnetbeans.debug.cvs.io.retry=true)";
                throw new AuthenticationException(string, string);
            }
            Utils.logVCSClientEvent((String)"CVS", (String)"JAVALIB");
            this.execute();
            Object var5_6 = null;
            task.cancel();
            try {
                this.client.getConnection().close();
            }
            catch (Throwable throwable) {
                ErrorManager.getDefault().notify(16, throwable);
            }
            break block13;
            {
                catch (Throwable throwable) {
                    this.failure = throwable;
                    Object var5_7 = null;
                    task.cancel();
                    try {
                        this.client.getConnection().close();
                    }
                    catch (Throwable throwable2) {
                        ErrorManager.getDefault().notify(16, throwable2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                task.cancel();
                try {
                    this.client.getConnection().close();
                }
                catch (Throwable throwable3) {
                    ErrorManager.getDefault().notify(16, throwable3);
                }
                throw throwable;
            }
        }
    }

    private void execute() throws Throwable {
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                CommandRunnable.this.client.executeCommand(CommandRunnable.this.cmd, CommandRunnable.this.options);
                return null;
            }
        };
        String string = this.cmd.getCVSCommand();
        if (string == null) {
            string = "";
        }
        boolean bl = string.startsWith("update") && (this.options == null || !this.options.isDoNoChanges()) || string.startsWith("export") || string.startsWith("remove") || string.startsWith("checkout") || string.startsWith("commit");
        File[] fileArray = null;
        if (bl) {
            if (this.cmd instanceof BasicCommand) {
                BasicCommand basicCommand = (BasicCommand)this.cmd;
                fileArray = basicCommand.getFiles();
            } else if (this.cmd instanceof ExportCommand) {
                ExportCommand exportCommand = (ExportCommand)this.cmd;
                fileArray = new File[]{new File(exportCommand.getExportDirectory())};
            }
        }
        if (bl) {
            IndexingBridge.getInstance().runWithoutIndexing((Callable)callable, fileArray);
        } else {
            callable.call();
        }
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public synchronized boolean isAborted() {
        return this.aborted;
    }

    public synchronized boolean cancel() {
        if (this.aborted) {
            return false;
        }
        this.aborted = true;
        this.client.abort();
        return true;
    }

    public String toString() {
        return "CommandRunnable command=" + this.cmd.getCVSCommand();
    }

    private class CounterRunnable
    implements Runnable {
        private RequestProcessor.Task task;
        private long counter;

        private CounterRunnable() {
        }

        public void run() {
            long l = CommandRunnable.this.client.getCounter();
            long l2 = l - this.counter;
            this.counter = l;
            CommandRunnable.this.support.increaseDataCounter(l2);
            this.task.schedule(500);
        }

        void initTask(RequestProcessor.Task task) {
            this.task = task;
        }
    }
}

