/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.lib.cvsclient.file.FileReadOnlyHandler;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.system.cvss.Annotator;
import org.netbeans.modules.versioning.system.cvss.CVS;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsFileTableModel;
import org.netbeans.modules.versioning.system.cvss.CvsLiteAdminHandler;
import org.netbeans.modules.versioning.system.cvss.CvsLiteFileHandler;
import org.netbeans.modules.versioning.system.cvss.CvsLiteGzippedFileHandler;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVisibilityQuery;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.FileStatusProvider;
import org.netbeans.modules.versioning.system.cvss.FilesystemHandler;
import org.netbeans.modules.versioning.system.cvss.IllegalCommandException;
import org.netbeans.modules.versioning.system.cvss.NotVersionedException;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.CvsSynchronizeTopComponent;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvsVersioningSystem {
    private static CvsVersioningSystem instance;
    public static final String FILENAME_CVSIGNORE = ".cvsignore";
    public static final String FILENAME_CVS = "CVS";
    public static final Object EVENT_PARAM_CHANGED;
    public static final Object PARAM_BATCH_REFRESH_RUNNING;
    public static final Object EVENT_VERSIONED_FILES_CHANGED;
    public static final Object EVENT_REFRESH_ANNOTATIONS;
    public static final String FILENAME_CVS_REPOSITORY = "CVS/Repository";
    public static final String FILENAME_CVS_ENTRIES = "CVS/Entries";
    private static final Set textExtensions;
    public static Logger LOG;
    private final Map<String, ClientRuntime> clientsCache = new HashMap<String, ClientRuntime>();
    private final Map params = new HashMap();
    private GlobalOptions defaultGlobalOptions;
    private FileStatusCache fileStatusCache;
    private CvsLiteAdminHandler sah;
    private CvsLiteFileHandler workdirFileHandler;
    private CvsLiteGzippedFileHandler workdirGzippedFileHandler;
    private FilesystemHandler filesystemHandler;
    private VCSAnnotator fileStatusProvider;
    private Annotator annotator;
    private final Set<Pattern> userIgnorePatterns = new HashSet<Pattern>();
    private boolean userIgnorePatternsReset;
    private long userIgnorePatternsTimestamp;
    private final Set<File> unignoreOverride = new HashSet<File>(1);
    private final Set<File> alreadyGeneratedFiles = new HashSet<File>(5);
    private final Set<File> unversionedParents = Collections.synchronizedSet(new HashSet(20));
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);
    private static final int STATUS_DIFFABLE = 1272;

    public static synchronized CvsVersioningSystem getInstance() {
        if (instance == null) {
            instance = new CvsVersioningSystem();
            instance.init();
        }
        return instance;
    }

    private void init() {
        this.defaultGlobalOptions = CvsVersioningSystem.createGlobalOptions();
        this.sah = new CvsLiteAdminHandler();
        this.workdirFileHandler = new CvsLiteFileHandler();
        FileUtils.setFileReadOnlyHandler((FileReadOnlyHandler)this.workdirFileHandler);
        this.workdirGzippedFileHandler = new CvsLiteGzippedFileHandler();
        this.fileStatusCache = new FileStatusCache(this);
        this.filesystemHandler = new FilesystemHandler(this);
        this.annotator = new Annotator(this);
        this.fileStatusProvider = new FileStatusProvider();
    }

    void shutdown() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    CvsSynchronizeTopComponent.getInstance().close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private CvsVersioningSystem() {
    }

    public CvsFileTableModel getFileTableModel(Context context, int n) {
        return new CvsFileTableModel(context, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRuntime getClientRuntime(String string) {
        ClientRuntime clientRuntime;
        string.length();
        Map<String, ClientRuntime> map = this.clientsCache;
        synchronized (map) {
            clientRuntime = this.clientsCache.get(string);
            if (clientRuntime == null) {
                clientRuntime = new ClientRuntime(string);
                this.clientsCache.put(string, clientRuntime);
            }
        }
        return clientRuntime;
    }

    String detectCvsRoot(Command command) throws NotVersionedException {
        File[] fileArray;
        Object object;
        if (command instanceof AddCommand) {
            object = (AddCommand)command;
            fileArray = object.getFiles();
        } else if (command instanceof BasicCommand) {
            object = (BasicCommand)command;
            fileArray = object.getFiles();
        } else {
            throw new NotVersionedException("Cannot determine CVSRoot for command: " + command);
        }
        object = fileArray[0];
        try {
            return Utils.getCVSRootFor((File)object);
        }
        catch (IOException iOException) {
            throw new NotVersionedException("Cannot determine CVSRoot for: " + object);
        }
    }

    public RequestProcessor.Task post(Command command, ExecutorSupport executorSupport) throws CommandException, AuthenticationException, NotVersionedException, IllegalCommandException, IOException {
        return this.post(command, this.defaultGlobalOptions, executorSupport);
    }

    public RequestProcessor.Task post(Command command, GlobalOptions globalOptions, ExecutorSupport executorSupport) throws IllegalCommandException {
        ClientRuntime clientRuntime = this.getClientRuntime(command, globalOptions);
        RequestProcessor.Task task = clientRuntime.createTask(command, globalOptions != null ? globalOptions : this.defaultGlobalOptions, executorSupport);
        task.schedule(0);
        return task;
    }

    public ClientRuntime getClientRuntime(Command command, GlobalOptions globalOptions) {
        String string;
        if (globalOptions != null && globalOptions.getCVSRoot() != null) {
            string = globalOptions.getCVSRoot();
        } else {
            try {
                string = this.detectCvsRoot(command);
            }
            catch (NotVersionedException notVersionedException) {
                if (globalOptions == null) {
                    return null;
                }
                string = globalOptions.getCVSRoot();
            }
        }
        return this.getClientRuntime(string);
    }

    public FileStatusCache getStatusCache() {
        return this.fileStatusCache;
    }

    public void addVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.addListener(versioningListener);
    }

    public void removeVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.removeListener(versioningListener);
    }

    boolean isUnignored(File file) {
        return this.unignoreOverride.contains(file);
    }

    boolean isIgnored(File file) {
        Object object;
        if (file.isDirectory() && ((File)(object = new File(file, FILENAME_CVS_REPOSITORY))).canRead()) {
            return false;
        }
        object = file.getName();
        if (".nbintdb".equals(object)) {
            return true;
        }
        if (this.isUnignored(file)) {
            return false;
        }
        HashSet<Pattern> hashSet = new HashSet<Pattern>(Arrays.asList(CvsModuleConfig.getDefault().getIgnoredFilePatterns()));
        this.addUserPatterns(hashSet);
        this.addCvsIgnorePatterns(hashSet, file.getParentFile());
        for (Pattern serializable : hashSet) {
            if (!serializable.matcher((CharSequence)object).matches()) continue;
            return true;
        }
        if (FILENAME_CVSIGNORE.equals(object)) {
            return false;
        }
        int n = SharabilityQuery.getSharability((File)file);
        if (n == 2) {
            if (CvsVisibilityQuery.isHiddenFolder(file)) {
                return false;
            }
            File file2 = new File(file.getParentFile(), FILENAME_CVSIGNORE);
            if (file.exists() && !file2.exists() && !this.alreadyGeneratedFiles.add(file2)) {
                return true;
            }
            try {
                this.setIgnored(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void addUserPatterns(Set<Pattern> set) {
        File file = new File(System.getProperty("user.home"), FILENAME_CVSIGNORE);
        long l = file.lastModified();
        if (l > this.userIgnorePatternsTimestamp || l == 0L && this.userIgnorePatternsTimestamp > 0L) {
            this.userIgnorePatternsTimestamp = l;
            this.parseUserPatterns(file);
        }
        if (this.userIgnorePatternsReset) {
            set.clear();
        }
        set.addAll(this.userIgnorePatterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseUserPatterns(File file) {
        this.userIgnorePatternsReset = false;
        this.userIgnorePatterns.clear();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if ("!".equals(string)) {
                    this.userIgnorePatternsReset = true;
                    this.userIgnorePatterns.clear();
                    continue;
                }
                try {
                    this.userIgnorePatterns.add(CvsVersioningSystem.sh2regex(string));
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Pattern sh2regex(String string) throws IOException {
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*");
        string = string.replaceAll("\\?", ".");
        try {
            return Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IOException(patternSyntaxException.getMessage());
        }
    }

    public static boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof CVS && !Utils.isPartOfCVSMetadata(file);
    }

    public void versionedFilesChanged() {
        this.unversionedParents.clear();
        this.listenerSupport.fireVersioningEvent(EVENT_VERSIONED_FILES_CHANGED);
    }

    File getTopmostManagedParent(File file) {
        long l = System.currentTimeMillis();
        LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        if (this.unversionedParents.contains(file)) {
            LOG.fine(" cached as unversioned");
            return null;
        }
        if (Utils.isPartOfCVSMetadata(file)) {
            LOG.fine(" part of metaddata");
            while (file != null) {
                if (file.getName().equals(FILENAME_CVS) && (file.isDirectory() || !file.exists())) {
                    file = file.getParentFile();
                    LOG.log(Level.FINE, " will use parent {0}", new Object[]{file});
                    break;
                }
                file = file.getParentFile();
            }
        }
        HashSet<File> hashSet = new HashSet<File>();
        File file2 = null;
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (org.netbeans.modules.versioning.util.Utils.isScanForbidden((File)file)) break;
            if (Utils.containsMetadata(file)) {
                LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                file2 = file;
                hashSet.clear();
            } else {
                LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                if (file.exists()) {
                    hashSet.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (hashSet.size() > 0) {
            LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(hashSet);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, " getTopmostManagedParent returns {0} after {1} millis", new Object[]{file2, System.currentTimeMillis() - l});
        }
        return file2;
    }

    private void addCvsIgnorePatterns(Set<Pattern> set, File file) {
        Set<String> set2;
        try {
            set2 = this.readCvsIgnoreEntries(file);
        }
        catch (IOException iOException) {
            return;
        }
        for (String string : set2) {
            if ("!".equals(string)) {
                set.clear();
                continue;
            }
            try {
                set.add(CvsVersioningSystem.sh2regex(string));
            }
            catch (IOException iOException) {}
        }
    }

    private boolean isInCvsIgnore(File file) {
        try {
            String string = this.computePatternToIgnore(file.getName());
            return this.readCvsIgnoreEntries(file.getParentFile()).contains(string);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
    }

    public boolean isIgnoredFilename(File file) {
        return FILENAME_CVS.equals(file.getName());
    }

    public AdminHandler getAdminHandler() {
        return this.sah;
    }

    public FileHandler getFileHandler() {
        return this.workdirFileHandler;
    }

    public FileHandler getGzippedFileHandler() {
        return this.workdirGzippedFileHandler;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getParameter(Object object) {
        Map map = this.params;
        synchronized (map) {
            return this.params.get(object);
        }
    }

    public KeywordSubstitutionOptions getDefaultKeywordSubstitution(File file) {
        return this.isText(file) || !this.isBinary(file) ? KeywordSubstitutionOptions.DEFAULT : KeywordSubstitutionOptions.BINARY;
    }

    public boolean isText(File file) {
        if (FILENAME_CVSIGNORE.equals(file.getName())) {
            return true;
        }
        try {
            Entry entry = this.sah.getEntry(file);
            if (entry != null) {
                return !entry.isBinary();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (org.netbeans.modules.versioning.util.Utils.isFileContentText((File)file)) {
            return true;
        }
        int n = file.getName().lastIndexOf(46);
        return n != -1 && textExtensions.contains(file.getName().substring(n + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBinary(File file) {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            inputStream = new BufferedInputStream(inputStream);
            for (int i = 0; i < 1024; ++i) {
                int n = inputStream.read();
                if (n == -1) {
                    break;
                }
                if (n >= 32 || n == 9 || n == 10 || n == 13) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.notify(1, (Throwable)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(Object object, Object object2) {
        Object object3;
        Map map = this.params;
        synchronized (map) {
            object3 = this.params.put(object, object2);
        }
        if (object3 != object2) {
            this.listenerSupport.fireVersioningEvent(EVENT_PARAM_CHANGED, object);
        }
    }

    public void setIgnored(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                this.setIgnored(fileArray[i]);
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private void setIgnored(File file) throws IOException {
        if (file.exists()) {
            this.addToCvsIgnore(file);
        }
    }

    void setNotUnignored(File file) {
        this.unignoreOverride.remove(file);
    }

    public void setNotignored(File[] fileArray) {
        for (File file : fileArray) {
            if (this.isInCvsIgnore(file)) {
                try {
                    this.removeFromCvsIgnore(file);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                continue;
            }
            this.unignoreOverride.add(file);
            this.fileStatusCache.refresh(file, 0);
        }
    }

    private void addToCvsIgnore(File file) throws IOException {
        String string;
        Set<String> set = this.readCvsIgnoreEntries(file.getParentFile());
        if (set.add(string = this.computePatternToIgnore(file.getName()))) {
            this.writeCvsIgnoreEntries(file.getParentFile(), set);
        }
    }

    private String computePatternToIgnore(String string) {
        return string.replace(' ', '?');
    }

    private void removeFromCvsIgnore(File file) throws IOException {
        String string;
        Set<String> set = this.readCvsIgnoreEntries(file.getParentFile());
        if (set.remove(string = this.computePatternToIgnore(file.getName()))) {
            this.writeCvsIgnoreEntries(file.getParentFile(), set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> readCvsIgnoreEntries(File file) throws IOException {
        File file2 = new File(file, FILENAME_CVSIGNORE);
        HashSet<String> hashSet = new HashSet<String>(5);
        if (!file2.canRead()) {
            return hashSet;
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file2));
            while ((string = bufferedReader.readLine()) != null) {
                hashSet.addAll(Arrays.asList(string.trim().split(" ")));
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCvsIgnoreEntries(File file, Set set) throws IOException {
        File file2 = new File(file, FILENAME_CVSIGNORE);
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        if (set.size() == 0) {
            if (fileObject != null) {
                fileObject.delete();
            }
            return;
        }
        if (fileObject == null || !fileObject.isValid()) {
            fileObject = FileUtil.toFileObject((File)file);
            fileObject = fileObject.createData(FILENAME_CVSIGNORE);
        }
        FileLock fileLock = fileObject.lock();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(fileObject.getOutputStream(fileLock));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                printWriter.println(iterator.next());
            }
        }
        finally {
            fileLock.releaseLock();
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public static void ignoreFilesystemEvents(boolean bl) {
        FilesystemHandler.ignoreEvents(bl);
    }

    public static GlobalOptions createGlobalOptions() {
        GlobalOptions globalOptions = new GlobalOptions();
        if (System.getProperty("cvsClientLog") == null) {
            int n = 4;
            String string = System.getProperty("netbeans.experimental.cvs.io.compressionLevel");
            if (string != null) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (0 <= n2 && n2 < 10) {
                        n = n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n > 0) {
                globalOptions.setCompressionLevel(n);
            }
        }
        return globalOptions;
    }

    public VCSAnnotator getVCSAnnotator() {
        return this.fileStatusProvider;
    }

    public VCSInterceptor getVCSInterceptor() {
        return this.filesystemHandler;
    }

    public void getOriginalFile(File file, File file2) {
        FileInformation fileInformation = this.fileStatusCache.getStatus(file);
        if ((fileInformation.getStatus() & 0x4F8) == 0) {
            return;
        }
        try {
            if (CvsVersioningSystem.getInstance().getAdminHandler().getEntry(file) == null) {
                return;
            }
            File file3 = VersionsCache.getInstance().getRemoteFile(file, "*", null, true);
            if (file3 == null) {
                throw new IOException("Unable to get BASE revision of " + file);
            }
            org.netbeans.modules.versioning.util.Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(file2), (InputStream)new FileInputStream(file3));
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Unable to get original file", exception);
        }
    }

    public void refreshAllAnnotations() {
        this.listenerSupport.fireVersioningEvent(EVENT_REFRESH_ANNOTATIONS);
    }

    static {
        EVENT_PARAM_CHANGED = new Object();
        PARAM_BATCH_REFRESH_RUNNING = new Object();
        EVENT_VERSIONED_FILES_CHANGED = new Object();
        EVENT_REFRESH_ANNOTATIONS = new Object();
        textExtensions = new HashSet<String>(Arrays.asList("txt", "xml", "html", "properties", "mf", "jhm", "hs", "form"));
        LOG = Logger.getLogger(CvsVersioningSystem.class.getName());
    }
}

