/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ResourceBundle;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.openide.util.NbBundle;

public class FileInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_NOTVERSIONED_NOTMANAGED = 1;
    public static final int STATUS_NOTVERSIONED_EXCLUDED = 2;
    public static final int STATUS_NOTVERSIONED_NEWLOCALLY = 4;
    public static final int STATUS_VERSIONED_UPTODATE = 8;
    public static final int STATUS_VERSIONED_MODIFIEDLOCALLY = 16;
    public static final int STATUS_VERSIONED_MODIFIEDINREPOSITORY = 32;
    public static final int STATUS_VERSIONED_CONFLICT = 64;
    public static final int STATUS_VERSIONED_MERGE = 128;
    public static final int STATUS_VERSIONED_REMOVEDLOCALLY = 256;
    public static final int STATUS_VERSIONED_NEWINREPOSITORY = 512;
    public static final int STATUS_VERSIONED_REMOVEDINREPOSITORY = 1024;
    public static final int STATUS_VERSIONED_DELETEDLOCALLY = 2048;
    public static final int STATUS_VERSIONED_ADDEDLOCALLY = 4096;
    public static final int STATUS_ALL = -1;
    public static final int STATUS_MANAGED = -2;
    public static final int STATUS_IN_REPOSITORY = 4088;
    public static final int STATUS_LOCAL_CHANGE = 6612;
    public static final int STATUS_REMOTE_CHANGE = 1696;
    private final int status;
    private final boolean isDirectory;
    private transient Entry cvsEntry;

    public FileInformation() {
        this.status = 0;
        this.isDirectory = false;
    }

    FileInformation(int n, Entry entry, boolean bl) {
        this.status = n;
        this.cvsEntry = entry;
        this.isDirectory = bl;
    }

    FileInformation(int n, boolean bl) {
        this(n, null, bl);
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public Entry getEntry(File file) {
        if (this.cvsEntry == null && file != null) {
            this.readEntry(file);
        }
        return this.cvsEntry;
    }

    private void readEntry(File file) {
        try {
            this.cvsEntry = CvsVersioningSystem.getInstance().getAdminHandler().getEntry(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getStatusText() {
        ResourceBundle resourceBundle = NbBundle.getBundle(FileInformation.class);
        if (this.status == 0) {
            return resourceBundle.getString("CTL_FileInfoStatus_Unknown");
        }
        if (this.status == 2) {
            return resourceBundle.getString("CTL_FileInfoStatus_Excluded");
        }
        if (this.status == 4) {
            return resourceBundle.getString("CTL_FileInfoStatus_NewLocally");
        }
        if (this.status == 4096) {
            return resourceBundle.getString("CTL_FileInfoStatus_AddedLocally");
        }
        if (this.status == 8) {
            return resourceBundle.getString("CTL_FileInfoStatus_UpToDate");
        }
        if (this.status == 512) {
            return resourceBundle.getString("CTL_FileInfoStatus_NewInRepository");
        }
        if (this.status == 256) {
            return resourceBundle.getString("CTL_FileInfoStatus_RemovedLocally");
        }
        if (this.status == 2048) {
            return resourceBundle.getString("CTL_FileInfoStatus_DeletedLocally");
        }
        if (this.status == 16) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedLocally");
        }
        if (this.status == 32) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedInRepository");
        }
        if (this.status == 1024) {
            return resourceBundle.getString("CTL_FileInfoStatus_RemovedInRepository");
        }
        if (this.status == 64) {
            return resourceBundle.getString("CTL_FileInfoStatus_Conflict");
        }
        if (this.status == 128) {
            return resourceBundle.getString("CTL_FileInfoStatus_Merge");
        }
        return "";
    }

    public String getShortStatusText() {
        ResourceBundle resourceBundle = NbBundle.getBundle(FileInformation.class);
        if (this.status == 2) {
            return resourceBundle.getString("CTL_FileInfoStatus_Excluded_Short");
        }
        if (this.status == 4) {
            return resourceBundle.getString("CTL_FileInfoStatus_NewLocally_Short");
        }
        if (this.status == 4096) {
            return resourceBundle.getString("CTL_FileInfoStatus_AddedLocally_Short");
        }
        if (this.status == 256) {
            return resourceBundle.getString("CTL_FileInfoStatus_RemovedLocally_Short");
        }
        if (this.status == 2048) {
            return resourceBundle.getString("CTL_FileInfoStatus_DeletedLocally_Short");
        }
        if (this.status == 16) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedLocally_Short");
        }
        if (this.status == 64) {
            return resourceBundle.getString("CTL_FileInfoStatus_Conflict_Short");
        }
        if (this.status == 128) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedLocally_Short");
        }
        return "";
    }
}

