/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.actions.ChangeCVSRootPanel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.CvsRootRewriter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ChangeCVSRootAction
extends AbstractAction {
    private final String RECENT_CHANGED_ROOTS = "recentChangedRoots";
    private final VCSContext ctx;

    public ChangeCVSRootAction(String string, VCSContext vCSContext) {
        super(string);
        this.ctx = vCSContext;
    }

    public boolean isEnabled() {
        return this.ctx.getRootFiles().size() > 0 && this.allDirectories();
    }

    private boolean allDirectories() {
        for (File file : this.ctx.getRootFiles()) {
            if (file.isDirectory()) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ResourceBundle resourceBundle = NbBundle.getBundle(ChangeCVSRootAction.class);
        final ChangeCVSRootPanel changeCVSRootPanel = new ChangeCVSRootPanel();
        changeCVSRootPanel.getWorkingCopy().setText(this.getWorkingCopy());
        changeCVSRootPanel.getCurrentCVSRoot().setText(this.getCurrentRoot());
        List list = Utils.getStringList((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)"recentChangedRoots");
        changeCVSRootPanel.getNewRootCombo().setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        if (list.size() > 0) {
            changeCVSRootPanel.getNewRootCombo().setSelectedItem(list.get(0));
        } else {
            changeCVSRootPanel.getNewRootCombo().setSelectedItem(this.getNewRoot());
        }
        final JButton jButton = new JButton(resourceBundle.getString("CTL_CvsRootForm_Action_Change"));
        jButton.setToolTipText(resourceBundle.getString("TT_CvsRootForm_Action_Change"));
        JButton jButton2 = new JButton(resourceBundle.getString("CTL_CvsRootForm_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ChangeCVSRootAction.class, (String)"ACSD_CvsRootForm_Action_Cancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)changeCVSRootPanel, resourceBundle.getString("CTL_CvsRootForm_Title"), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, null, null);
        dialogDescriptor.setClosingOptions(null);
        dialogDescriptor.setHelpCtx(new HelpCtx(ChangeCVSRootAction.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CvsRootForm"));
        Component component = changeCVSRootPanel.getNewRootCombo().getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    ChangeCVSRootAction.this.validate(changeCVSRootPanel, jButton);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    ChangeCVSRootAction.this.validate(changeCVSRootPanel, jButton);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    ChangeCVSRootAction.this.validate(changeCVSRootPanel, jButton);
                }
            });
        }
        changeCVSRootPanel.getNewRootCombo().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeCVSRootAction.this.validate(changeCVSRootPanel, jButton);
            }
        });
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != jButton) {
            return;
        }
        final String string = changeCVSRootPanel.getNewRootCombo().getEditor().getItem().toString();
        Utils.insert((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)"recentChangedRoots", (String)string, (int)20);
        Utils.createTask((Runnable)new Runnable(){

            public void run() {
                ChangeCVSRootAction.this.rewrite(string);
            }
        }).schedule(0);
    }

    private void rewrite(String string) {
        for (File file : this.ctx.getRootFiles()) {
            CvsRootRewriter cvsRootRewriter = new CvsRootRewriter(file, string);
            cvsRootRewriter.rewrite();
        }
    }

    private String getCurrentRoot() {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : this.ctx.getRootFiles()) {
            try {
                String string = CvsRootRewriter.getCvsRoot(file);
                if (string == null) continue;
                stringBuilder.append(string);
                stringBuilder.append(", ");
            }
            catch (IOException iOException) {
                Logger.getLogger(ChangeCVSRootAction.class.getName()).log(Level.WARNING, "", iOException);
            }
        }
        if (stringBuilder.length() == 0) {
            return NbBundle.getMessage(ChangeCVSRootAction.class, (String)"MSG_CvsRootForm_NoCurrentRoot");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }

    private String getNewRoot() {
        File file = (File)this.ctx.getRootFiles().iterator().next();
        try {
            return CvsRootRewriter.getCvsRoot(file);
        }
        catch (IOException iOException) {
            Logger.getLogger(ChangeCVSRootAction.class.getName()).log(Level.WARNING, "", iOException);
            return "";
        }
    }

    private String getWorkingCopy() {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : this.ctx.getRootFiles()) {
            stringBuilder.append(file.getAbsolutePath());
            stringBuilder.append(", ");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }

    public void validate(ChangeCVSRootPanel changeCVSRootPanel, JButton jButton) {
        try {
            CVSRoot.parse((String)changeCVSRootPanel.getNewRootCombo().getEditor().getItem().toString());
            jButton.setEnabled(true);
        }
        catch (Exception exception) {
            jButton.setEnabled(false);
        }
    }
}

