/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffFileTable;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffNode;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffSetupSource;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.Setup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiDiffPanel
extends JPanel
implements ActionListener,
VersioningListener,
DiffSetupSource,
PropertyChangeListener {
    private Setup[] setups;
    private final DelegatingUndoRedo delegatingUndoRedo = new DelegatingUndoRedo();
    private final Context context;
    private int displayStatuses;
    private final String contextName;
    private int currentType;
    private int currentIndex = -1;
    private int currentModelIndex = -1;
    private RequestProcessor.Task prepareTask;
    private DiffPrepareTask dpt;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private RequestProcessor.Task refreshTask;
    private ExecutorGroup group;
    private volatile boolean executed;
    private JComponent diffView;
    private DiffFileTable fileTable;
    private boolean dividerSet;
    private boolean fileTableSetSelectedIndexContext;
    private JToggleButton allToggle;
    private JButton commitButton;
    private JToolBar controlsToolBar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JToggleButton localToggle;
    private JButton nextButton;
    private JButton prevButton;
    private JButton refreshButton;
    private JToggleButton remoteToggle;
    private JSplitPane splitPane;
    private JButton updateButton;

    public MultiDiffPanel(Context context, int n, String string, ExecutorGroup executorGroup) {
        this.context = context;
        this.contextName = string;
        this.group = executorGroup;
        this.currentType = n;
        this.initComponents();
        this.setupComponents();
        if (CvsModuleConfig.getDefault().getPreferences().getBoolean("autoDiffRefresh", true)) {
            this.onRefreshButton();
        } else {
            this.refreshSetups();
        }
        this.refreshComponents();
        this.refreshTask = Utils.createTask((Runnable)new RefreshViewTask());
    }

    public MultiDiffPanel(File file, String string, String string2) {
        this.context = null;
        this.contextName = file.getName();
        this.initComponents();
        this.setupComponents();
        this.localToggle.setVisible(false);
        this.remoteToggle.setVisible(false);
        this.allToggle.setVisible(false);
        this.fileTable.getComponent().setVisible(false);
        this.commitButton.setVisible(false);
        this.refreshButton.setVisible(false);
        this.updateButton.setVisible(false);
        this.setups = new Setup[]{new Setup(file, string, string2)};
        this.setDiffIndex(0, 0);
        this.dpt = new DiffPrepareTask(this.setups);
        this.prepareTask = RequestProcessor.getDefault().post((Runnable)this.dpt);
    }

    public void setSelectedIndex(int n) {
        if (this.fileTableSetSelectedIndexContext) {
            return;
        }
        this.setDiffIndex(n, 0);
    }

    UndoRedo getUndoRedo() {
        return this.delegatingUndoRedo;
    }

    private void cancelBackgroundTasks() {
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
    }

    void componentClosed() {
        this.setups = null;
        this.prevAction.setEnabled(false);
        this.nextAction.setEnabled(false);
        this.cancelBackgroundTasks();
    }

    public synchronized void setGroup(ExecutorGroup executorGroup) {
        this.group = executorGroup;
        if (this.executed && executorGroup != null) {
            executorGroup.executed();
        }
    }

    void requestActive() {
        if (this.diffView != null) {
            this.diffView.requestFocusInWindow();
        }
    }

    private void setupComponents() {
        this.fileTable = new DiffFileTable(this);
        this.splitPane.setTopComponent(this.fileTable.getComponent());
        this.splitPane.setBottomComponent((Component)new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent")));
        this.commitButton.addActionListener(this);
        this.localToggle.addActionListener(this);
        this.remoteToggle.addActionListener(this);
        this.allToggle.addActionListener(this);
        this.commitButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_CommitDiff_Tooltip", (Object)this.contextName));
        this.updateButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_UpdateDiff_Tooltip", (Object)this.contextName));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.localToggle);
        buttonGroup.add(this.remoteToggle);
        buttonGroup.add(this.allToggle);
        if (this.currentType == 0) {
            this.localToggle.setSelected(true);
        } else if (this.currentType == 1) {
            this.remoteToggle.setSelected(true);
        } else if (this.currentType == 2) {
            this.allToggle.setSelected(true);
        }
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MultiDiffPanel.this.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MultiDiffPanel.this.onPrevButton();
            }
        };
        this.nextButton.setAction(this.nextAction);
        this.prevButton.setAction(this.prevAction);
    }

    private void refreshComponents() {
        int n;
        DiffController diffController = this.setups != null && this.currentModelIndex != -1 ? this.setups[this.currentModelIndex].getView() : null;
        int n2 = n = diffController != null ? diffController.getDifferenceIndex() : -1;
        if (diffController != null) {
            this.nextAction.setEnabled(this.currentIndex < this.setups.length - 1 || n < diffController.getDifferenceCount() - 1);
        } else {
            this.nextAction.setEnabled(false);
        }
        this.prevAction.setEnabled(this.currentIndex > 0 || n > 0);
        this.dividerSet = false;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.refreshTask != null) {
            CvsVersioningSystem.getInstance().getStatusCache().addVersioningListener(this);
        }
        JComponent jComponent = (JComponent)this.getParent();
        jComponent.getActionMap().put("jumpNext", this.nextAction);
        jComponent.getActionMap().put("jumpPrev", this.prevAction);
    }

    private void updateSplitLocation() {
        Dimension dimension;
        if (this.dividerSet) {
            return;
        }
        JComponent jComponent = (JComponent)this.getParent();
        Dimension dimension2 = dimension = jComponent == null ? new Dimension() : jComponent.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MultiDiffPanel.this.updateSplitLocation();
                }
            });
            return;
        }
        this.dividerSet = true;
        JTable jTable = this.fileTable.getTable();
        int n = jTable.getPreferredSize().height + jTable.getTableHeader().getPreferredSize().height;
        if (n > dimension.height / 3) {
            n = dimension.height / 3;
        }
        if (n <= jTable.getTableHeader().getPreferredSize().height) {
            n = jTable.getTableHeader().getPreferredSize().height * 3;
        }
        this.splitPane.setDividerLocation(n);
    }

    @Override
    public void removeNotify() {
        CvsVersioningSystem.getInstance().getStatusCache().removeVersioningListener(this);
        super.removeNotify();
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            if (!this.affectsView(versioningEvent)) {
                return;
            }
            if (CvsVersioningSystem.getInstance().getParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) != null) {
                this.refreshTask.schedule(1000);
            } else {
                this.refreshTask.schedule(200);
            }
        } else if (versioningEvent.getId() == CvsVersioningSystem.EVENT_PARAM_CHANGED && versioningEvent.getParams()[0].equals(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) && CvsVersioningSystem.getInstance().getParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) == null) {
            this.refreshTask.schedule(0);
        }
    }

    private boolean affectsView(VersioningEvent versioningEvent) {
        File file = (File)versioningEvent.getParams()[0];
        FileInformation fileInformation = (FileInformation)versioningEvent.getParams()[1];
        FileInformation fileInformation2 = (FileInformation)versioningEvent.getParams()[2];
        if (fileInformation == null) {
            if ((fileInformation2.getStatus() & this.displayStatuses) == 0) {
                return false;
            }
        } else {
            if ((fileInformation.getStatus() & this.displayStatuses) + (fileInformation2.getStatus() & this.displayStatuses) == 0) {
                return false;
            }
            if (fileInformation.getStatus() == fileInformation2.getStatus()) {
                return false;
            }
        }
        return this.context.contains(file);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDiffIndex(int n, int n2) {
        this.currentIndex = n;
        DiffController diffController = null;
        if (this.currentIndex != -1) {
            File file;
            this.currentModelIndex = this.showingFileTable() ? this.fileTable.getModelIndex(this.currentIndex) : 0;
            diffController = this.setups[this.currentModelIndex].getView();
            TopComponent topComponent = (TopComponent)this.getClientProperty(TopComponent.class);
            if (topComponent != null) {
                FileObject fileObject;
                Node node = Node.EMPTY;
                file = this.setups[this.currentModelIndex].getBaseFile();
                if (file != null && (fileObject = FileUtil.toFileObject((File)file)) != null) {
                    node = new AbstractNode(Children.LEAF, Lookups.singleton((Object)fileObject));
                }
                topComponent.setActivatedNodes(new Node[]{node});
            }
            this.diffView = null;
            boolean bl = false;
            if (diffController != null) {
                if (this.showingFileTable()) {
                    this.fileTableSetSelectedIndexContext = true;
                    this.fileTable.setSelectedIndex(this.currentIndex);
                    this.fileTableSetSelectedIndexContext = false;
                }
                this.diffView = diffController.getJComponent();
                this.diffView.getActionMap().put("jumpNext", this.nextAction);
                this.diffView.getActionMap().put("jumpPrev", this.prevAction);
                this.setBottomComponent();
                if (n2 == -1) {
                    n2 = diffController.getDifferenceCount() - 1;
                }
                if (n2 >= 0 && n2 < diffController.getDifferenceCount()) {
                    diffController.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, n2);
                }
                if (!SwingUtilities.isDescendingFrom(this, (Component)((Object)(file = WindowManager.getDefault().getRegistry().getActivated())))) {
                    // empty if block
                }
            } else {
                this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
            }
        } else {
            this.currentModelIndex = -1;
            this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoFileSelected"));
            this.setBottomComponent();
        }
        this.delegatingUndoRedo.setDiffView(this.diffView);
        this.refreshComponents();
    }

    private boolean showingFileTable() {
        return this.fileTable.getComponent().isVisible();
    }

    private void setBottomComponent() {
        int n = this.splitPane.getDividerLocation();
        this.splitPane.setBottomComponent(this.diffView);
        this.splitPane.setDividerLocation(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.commitButton) {
            this.onCommitButton();
        } else if (object == this.localToggle || object == this.remoteToggle || object == this.allToggle) {
            this.onDiffTypeChanged();
        }
    }

    private void onRefreshButton() {
        LifecycleManager.getDefault().saveAll();
        this.refreshSetups();
        this.executeUpdateCommand(true);
    }

    private void onUpdateButton() {
        LifecycleManager.getDefault().saveAll();
        this.executeUpdateCommand(false);
    }

    private void onCommitButton() {
        LifecycleManager.getDefault().saveAll();
        CommitAction.invokeCommit(this.contextName, this.context, null);
    }

    private void executeUpdateCommand(boolean bl) {
        if (this.context == null || this.context.getRootFiles().length == 0) {
            return;
        }
        UpdateCommand updateCommand = new UpdateCommand();
        String string = bl ? NbBundle.getMessage(MultiDiffPanel.class, (String)"BK0001") : NbBundle.getMessage(MultiDiffPanel.class, (String)"BK0002");
        updateCommand.setDisplayName(string);
        GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
        if (this.context.getExclusions().size() > 0) {
            globalOptions.setExclusions(this.context.getExclusions().toArray(new File[this.context.getExclusions().size()]));
        }
        updateCommand.setFiles(this.context.getRootFiles());
        updateCommand.setBuildDirectories(true);
        updateCommand.setPruneDirectories(true);
        globalOptions.setDoNoChanges(bl);
        ExecutorGroup executorGroup = new ExecutorGroup(string);
        executorGroup.addExecutors(UpdateExecutor.splitCommand(updateCommand, CvsVersioningSystem.getInstance(), globalOptions, this.contextName));
        executorGroup.execute();
    }

    private void onNextButton() {
        DiffController diffController;
        if (this.showingFileTable()) {
            this.currentIndex = this.fileTable.getSelectedIndex();
            this.currentModelIndex = this.fileTable.getSelectedModelIndex();
        }
        if ((diffController = this.setups[this.currentModelIndex].getView()) != null) {
            int n = diffController.getDifferenceIndex();
            if (++n >= diffController.getDifferenceCount()) {
                if (++this.currentIndex >= this.setups.length) {
                    --this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, 0);
                }
            } else {
                diffController.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, n);
            }
        } else {
            if (++this.currentIndex >= this.setups.length) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, 0);
        }
        this.refreshComponents();
    }

    private void onPrevButton() {
        DiffController diffController = this.setups[this.currentModelIndex].getView();
        if (diffController != null) {
            int n = diffController.getDifferenceIndex();
            if (--n < 0) {
                if (--this.currentIndex < 0) {
                    ++this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, -1);
                }
            } else {
                diffController.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, n);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.setups.length - 1;
            }
            this.setDiffIndex(this.currentIndex, -1);
        }
        this.refreshComponents();
    }

    @Override
    public Collection<Setup> getSetups() {
        if (this.setups == null) {
            return Collections.emptySet();
        }
        return Arrays.asList(this.setups);
    }

    @Override
    public String getSetupDisplayName() {
        return this.contextName;
    }

    private void refreshSetups() {
        Serializable serializable;
        if (this.dpt != null) {
            this.prepareTask.cancel();
        }
        switch (this.currentType) {
            case 0: {
                this.displayStatuses = 6612;
                break;
            }
            case 1: {
                this.displayStatuses = 1696;
                break;
            }
            case 2: {
                this.displayStatuses = 8180;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
            }
        }
        File[] fileArray = DiffExecutor.getModifiedFiles(this.context, this.displayStatuses);
        Setup[] setupArray = new Setup[fileArray.length];
        for (int i = 0; i < setupArray.length; ++i) {
            serializable = fileArray[i];
            setupArray[i] = new Setup((File)serializable, this.currentType);
            setupArray[i].setNode((Node)new DiffNode(setupArray[i]));
        }
        Arrays.sort(setupArray, new SetupsComparator());
        this.setups = setupArray;
        this.fileTable.setTableModel(this.setupToNodes(this.setups));
        if (this.setups.length == 0) {
            String string;
            switch (this.currentType) {
                case 0: {
                    string = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoLocalChanges");
                    break;
                }
                case 1: {
                    string = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoRemoteChanges");
                    break;
                }
                case 2: {
                    string = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoAllChanges");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
                }
            }
            this.setups = null;
            this.fileTable.setTableModel(new Node[0]);
            this.fileTable.getComponent().setEnabled(false);
            this.fileTable.getComponent().setPreferredSize(null);
            serializable = this.fileTable.getComponent().getPreferredSize();
            this.fileTable.getComponent().setPreferredSize(new Dimension(((Dimension)serializable).width + 1, ((Dimension)serializable).height));
            this.diffView = null;
            this.diffView = new NoContentPanel(string);
            this.setBottomComponent();
            this.nextAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.revalidate();
            this.repaint();
            this.executed();
        } else {
            this.fileTable.getComponent().setEnabled(true);
            this.fileTable.getComponent().setPreferredSize(null);
            Dimension dimension = this.fileTable.getComponent().getPreferredSize();
            this.fileTable.getComponent().setPreferredSize(new Dimension(dimension.width + 1, dimension.height));
            this.setDiffIndex(0, 0);
            this.dpt = new DiffPrepareTask(this.setups);
            this.prepareTask = RequestProcessor.getDefault().post((Runnable)this.dpt);
        }
    }

    private Node[] setupToNodes(Setup[] setupArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>(setupArray.length);
        for (Setup setup : setupArray) {
            arrayList.add(setup.getNode());
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private void onDiffTypeChanged() {
        if (this.localToggle.isSelected()) {
            if (this.currentType == 0) {
                return;
            }
            this.currentType = 0;
        } else if (this.remoteToggle.isSelected()) {
            if (this.currentType == 1) {
                return;
            }
            this.currentType = 1;
        } else if (this.allToggle.isSelected()) {
            if (this.currentType == 2) {
                return;
            }
            this.currentType = 2;
        }
        this.refreshSetups();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("(void) differencesChanged".equals(propertyChangeEvent.getPropertyName())) {
            this.refreshComponents();
        }
    }

    private synchronized void executed() {
        if (this.group != null) {
            this.group.executed();
        } else {
            this.executed = true;
        }
    }

    private void initComponents() {
        this.controlsToolBar = new JToolBar();
        this.allToggle = new JToggleButton();
        this.jPanel3 = new JPanel();
        this.localToggle = new JToggleButton();
        this.jPanel4 = new JPanel();
        this.remoteToggle = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.nextButton = new JButton();
        this.prevButton = new JButton();
        this.jPanel2 = new JPanel();
        this.refreshButton = new JButton();
        this.updateButton = new JButton();
        this.jPanel5 = new JPanel();
        this.commitButton = new JButton();
        this.splitPane = new JSplitPane();
        this.controlsToolBar.setFloatable(false);
        this.controlsToolBar.setRollover(true);
        this.allToggle.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/remote_vs_local.png")));
        this.allToggle.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_All_Tooltip"));
        this.allToggle.setFocusable(false);
        this.allToggle.setHorizontalTextPosition(0);
        this.allToggle.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.allToggle);
        this.jPanel3.setMaximumSize(new Dimension(12, Short.MAX_VALUE));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 12, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel3);
        this.localToggle.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/local_vs_local.png")));
        this.localToggle.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Local_Tooltip"));
        this.localToggle.setFocusable(false);
        this.localToggle.setHorizontalTextPosition(0);
        this.localToggle.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.localToggle);
        this.jPanel4.setMaximumSize(new Dimension(12, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(0, 12, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel4);
        this.remoteToggle.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/remote_vs_remote.png")));
        this.remoteToggle.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Remote_Tooltip"));
        this.remoteToggle.setFocusable(false);
        this.remoteToggle.setHorizontalTextPosition(0);
        this.remoteToggle.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.remoteToggle);
        this.jPanel1.setMaximumSize(new Dimension(80, Short.MAX_VALUE));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(0, 80, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel1);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png")));
        this.nextButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Next_Tooltip"));
        this.nextButton.setFocusable(false);
        this.nextButton.setHorizontalTextPosition(0);
        this.nextButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.nextButton);
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png")));
        this.prevButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Prev_Tooltip"));
        this.prevButton.setFocusable(false);
        this.prevButton.setHorizontalTextPosition(0);
        this.prevButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.prevButton);
        this.jPanel2.setMaximumSize(new Dimension(30, Short.MAX_VALUE));
        GroupLayout groupLayout4 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(0, 30, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel2);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"refreshButton.toolTipText"));
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiDiffPanel.this.refreshButtonActionPerformed(actionEvent);
            }
        });
        this.controlsToolBar.add(this.refreshButton);
        this.updateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/update.png")));
        this.updateButton.setText(NbBundle.getMessage(MultiDiffPanel.class, (String)"jButton1.text"));
        this.updateButton.setFocusable(false);
        this.updateButton.setHorizontalTextPosition(0);
        this.updateButton.setVerticalTextPosition(3);
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiDiffPanel.this.updateButtonActionPerformed(actionEvent);
            }
        });
        this.controlsToolBar.add(this.updateButton);
        this.jPanel5.setMaximumSize(new Dimension(20, Short.MAX_VALUE));
        GroupLayout groupLayout5 = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel5);
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/commit.png")));
        this.commitButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_CommitDiff_Tooltip"));
        this.commitButton.setFocusable(false);
        this.commitButton.setHorizontalTextPosition(0);
        this.commitButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.commitButton);
        this.splitPane.setOrientation(0);
        GroupLayout groupLayout6 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((Component)this.controlsToolBar, -1, 716, Short.MAX_VALUE).add((Component)this.splitPane, -1, 716, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)this.controlsToolBar, -2, 25, -2).addPreferredGap(0).add((Component)this.splitPane, -1, 331, Short.MAX_VALUE)));
    }

    private void updateButtonActionPerformed(ActionEvent actionEvent) {
        this.onUpdateButton();
    }

    private void refreshButtonActionPerformed(ActionEvent actionEvent) {
        this.onRefreshButton();
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MultiDiffPanel.this.refreshSetups();
                }
            });
        }
    }

    private static class SetupsComparator
    extends Utils.ByImportanceComparator {
        private FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();

        public int compare(Object object, Object object2) {
            File file = ((Setup)object).getBaseFile();
            File file2 = ((Setup)object2).getBaseFile();
            int n = super.compare(this.cache.getStatus(file), this.cache.getStatus(file2));
            if (n == 0) {
                return file.getName().compareToIgnoreCase(file2.getName());
            }
            return n;
        }
    }

    private class DiffPrepareTask
    implements Runnable {
        private final Setup[] prepareSetups;

        public DiffPrepareTask(Setup[] setupArray) {
            this.prepareSetups = setupArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block7: {
                block6: {
                    try {
                        for (int i = 0; i < this.prepareSetups.length; ++i) {
                            if (this.prepareSetups != MultiDiffPanel.this.setups) {
                                Object var7_7 = null;
                                break block6;
                            }
                            try {
                                this.prepareSetups[i].initSources(MultiDiffPanel.this.group);
                                final int n = i;
                                StreamSource streamSource = this.prepareSetups[n].getFirstSource();
                                StreamSource streamSource2 = this.prepareSetups[n].getSecondSource();
                                final DiffController diffController = DiffController.create((StreamSource)streamSource, (StreamSource)streamSource2);
                                diffController.addPropertyChangeListener((PropertyChangeListener)MultiDiffPanel.this);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        DiffPrepareTask.this.prepareSetups[n].setView(diffController);
                                        if (DiffPrepareTask.this.prepareSetups != MultiDiffPanel.this.setups) {
                                            return;
                                        }
                                        if (MultiDiffPanel.this.currentModelIndex == n) {
                                            MultiDiffPanel.this.setDiffIndex(MultiDiffPanel.this.currentIndex, 0);
                                        }
                                        MultiDiffPanel.this.updateSplitLocation();
                                    }
                                });
                                continue;
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                        }
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        MultiDiffPanel.this.executed();
                        throw throwable;
                    }
                }
                MultiDiffPanel.this.executed();
                return;
            }
            Object var7_8 = null;
            MultiDiffPanel.this.executed();
        }
    }
}

