/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.util;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.system.cvss.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements Serializable {
    public static final Context Empty = new Context(Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET);
    private static final long serialVersionUID = 1L;
    private final Set filteredFiles;
    private final Set rootFiles;
    private final Set exclusions;

    public Context(Set set, Set set2, Set set3) {
        this.filteredFiles = set;
        this.rootFiles = set2;
        this.exclusions = set3;
        while (this.normalize()) {
        }
    }

    private boolean normalize() {
        for (File file : this.rootFiles) {
            Iterator iterator = this.exclusions.iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (!Utils.isParentOrEqual(file2, file)) continue;
                iterator.remove();
                this.exclusionRemoved(file2, file);
                return true;
            }
        }
        this.removeDuplicates(this.rootFiles);
        this.removeDuplicates(this.exclusions);
        return false;
    }

    private void removeDuplicates(Set set) {
        ArrayList<File> arrayList = new ArrayList<File>();
        block0: for (File file : set) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (Utils.isParentOrEqual(file2, file) && (file.isFile() || !VersioningSupport.isFlat((File)file2))) continue block0;
                if (!Utils.isParentOrEqual(file, file2) || !file2.isFile() && VersioningSupport.isFlat((File)file)) continue;
                iterator.remove();
            }
            arrayList.add(file);
        }
        set.clear();
        set.addAll(arrayList);
    }

    private void exclusionRemoved(File file, File file2) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (Utils.isParentOrEqual(file2, file3)) continue;
            this.exclusions.add(file3);
        }
    }

    public Set<File> getExclusions() {
        return this.exclusions;
    }

    public File[] getFiles() {
        return this.filteredFiles.toArray(new File[this.filteredFiles.size()]);
    }

    public File[] getRootFiles() {
        return this.rootFiles.toArray(new File[this.rootFiles.size()]);
    }

    public boolean contains(File file) {
        block0: for (File file2 : this.rootFiles) {
            if (!Utils.isParentOrEqual(file2, file)) continue;
            for (File file3 : this.exclusions) {
                if (!Utils.isParentOrEqual(file3, file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    public Context union(Context context) {
        HashSet hashSet = new HashSet(this.filteredFiles);
        HashSet hashSet2 = new HashSet(this.rootFiles);
        HashSet hashSet3 = new HashSet(this.exclusions);
        hashSet.addAll(context.filteredFiles);
        hashSet2.addAll(context.rootFiles);
        hashSet3.addAll(context.exclusions);
        Context context2 = new Context(hashSet, hashSet2, hashSet3);
        return context2;
    }
}

